## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ordinalTables)

## ----vision_data--------------------------------------------------------------
print(vision_data)

## ----marginal_homogeneity-----------------------------------------------------
stuart_result <- Stuart_marginal_homogeneity(vision_data)
bhapkar_result <- Bhapkar_marginal_homogeneity(vision_data)
ireland_result <- Ireland_marginal_homogeneity(vision_data)

## ----cliff_independent--------------------------------------------------------
cliff_independent <- Cliff_independent_from_table(vision_data)

## ----cliff_tables-------------------------------------------------------------
cliff_result <- Cliff_dependent_compute_from_table(vision_data)

## ----clayton------------------------------------------------------------------
clayton_result <- Clayton_marginal_location(rowSums(vision_data), colSums(vision_data))

## ----agresti------------------------------------------------------------------
result <- Agresti_weighted_tau(vision_data)

## ----agresti_weighted---------------------------------------------------------
w <- c(-3, -1, 1, 3)
agresti_result <- Agresti_w_diff(w, vision_data)

## ----agresti_weighted_spread--------------------------------------------------
w <- c(3, 1, 1, 3)
agresti_result_spread <- Agresti_w_diff(w, vision_data)

## ----mccullagh----------------------------------------------------------------
mccullagh_result <- McCullagh_logistic_model(vision_data)

