# Radiant - Business analytics using R and Shiny


## Introduction to Radiant

<iframe width="640" height="375" src="https://www.youtube.com/embed/7L3hDpLw53I" frameborder="0" allowfullscreen></iframe>

## Installing R, Rstudio, and Radiant on Windows

For Windows, download and run the all-in-one installer for <a href="https://www.dropbox.com/s/0l6va4pz3s8wghq/Rady-Radiant-Installer-Latest.exe?dl=1" target="_blank">R, Rstudio, and Radiant</a>. For a video tutorial see the `Install Radiant on Windows` video below:

<iframe width="640" height="375" src="https://www.youtube.com/embed/ZNgwgosdNhM" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

> Note: Some users have reported that the Malwarebytes software can inappropriately block R-packages from being installed or updated. If you use Malwarebytes and are experiencing problems you can try (temporarily) turning it off during the install process or when upgrading.

> Credits: Thanks go to Brandon Salas at the Rady School of Management for creating the Windows installer

## Installing R, Rstudio, and Radiant on macOS

For Mac, first download and install R from <a href="https://cloud.r-project.org/bin/macosx/el-capitan/base/R-latest.pkg" target="_blank">https://cran.r-project.org/bin/macosx/</a>. Download the .pkg file, double-click, and follow the prompts. After R has been installed, open R, copy-and-paste the command below into R, and press return. Accept all default settings during the install process:

```r
source("https://raw.githubusercontent.com/radiant-rstats/minicran/gh-pages/install.R")
```

For a video tutorial see the `Installing R, Rstudio, and Radiant on macOS` video below:

<iframe width="640" height="375" src="https://www.youtube.com/embed/f5h2oDBsnJI" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

## Starting, stopping, and updating

<iframe width="640" height="375" src="https://www.youtube.com/embed/rNPnnqJhmD4" frameborder="0" allowfullscreen></iframe>

## Getting help

<iframe width="640" height="375" src="https://www.youtube.com/embed/9qAQio9Hb7k" frameborder="0" allowfullscreen></iframe>

## Getting data in and out

<iframe width="640" height="375" src="https://www.youtube.com/embed/PuoMc1x4MD8" frameborder="0" allowfullscreen></iframe>

## Fast and efficient analysis

<iframe width="640" height="375" src="https://www.youtube.com/embed/wtHIz-umoME" frameborder="0" allowfullscreen></iframe>

## Reproducible analysis

<iframe width="640" height="375" src="https://www.youtube.com/embed/pNNQc2lHR8Q" frameborder="0" allowfullscreen></iframe>

## Using Radiant for Model Evaluation

The state file used in the demo is available for download from [GitHub](https://radiant-rstats.github.io/docs/examples/demo-dvd-rnd.state.rda) 

<iframe width="640" height="375" src="https://www.youtube.com/embed/9fugq5dXNhk" frameborder="0" allowfullscreen></iframe>

## Radiant Tutorial Series

For additional video tutorials see the **Radiant Tutorial Series** playlist linked below that covers:

* Decision Analysis (_Model > Decision analysis_)
* Probability calculator (_Basics > Probability calculator_)
* Hypothesis testing:
    - _Basics > Single mean_
    - _Basics > Single proportion_
    - _Basics > Compare proportions_
    - _Basics > Compare means_
    - _Basics > Cross-tabs_
* Linear regression (_Model > Linear regression_)
* Simulation (_Model > Simulation_)

<a href="https://www.youtube.com/playlist?list=PLNhtaetb48EdKRIY7MewCyvb_1x7dV3xw" target="_blank">https://www.youtube.com/playlist?list=PLNhtaetb48EdKRIY7MewCyvb_1x7dV3xw</a>

<!--
## Visualizing data
<iframe width="640" height="375" src="" frameborder="0" allowfullscreen></iframe>
-->

## License


Radiant is licensed under the <a href="https://tldrlegal.com/license/gnu-affero-general-public-license-v3-(agpl-3.0)" target="\_blank">AGPLv3</a>. As a summary, the AGPLv3 license requires, attribution, including copyright and license information in copies of the software, stating changes if the code is modified, and disclosure of all source code. Details are in the COPYING file.

The documentation, images, and videos for the `radiant.data` package are licensed under the creative commons attribution and share-alike license <a href="https://creativecommons.org/licenses/by-sa/4.0/" target="_blank">CC-BY-SA</a>. All other documentation and videos on this site, as well as the help files for `radiant.design`, `radiant.basics`, `radiant.model`, and `radiant.multivariate`, are licensed under the creative commons attribution, non-commercial, share-alike license <a href="https://creativecommons.org/licenses/by-nc-sa/4.0/" target="_blank">CC-NC-SA</a>.

If you are interested in using any of the radiant packages please email me at radiant@rady.ucsd.edu

&copy; Vincent Nijs (2024) <a rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/" target="_blank"><img alt="Creative Commons License" style="border-width:0" src="imgs/by-sa.png" /></a>
