/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.stereo.AbstractStereo;

public class DoubleBondStereochemistry
extends AbstractStereo<IBond, IBond>
implements IDoubleBondStereochemistry {
    public DoubleBondStereochemistry(IBond stereoBond, IBond[] ligandBonds, IDoubleBondStereochemistry.Conformation stereo) {
        this(stereoBond, ligandBonds, IDoubleBondStereochemistry.Conformation.toConfig((IDoubleBondStereochemistry.Conformation)stereo));
    }

    public DoubleBondStereochemistry(IBond stereoBond, IBond[] ligandBonds, int config) {
        super((IChemObject)stereoBond, (IChemObject[])ligandBonds, 0x2100 | 0xFF & config);
    }

    @Override
    public void setBuilder(IChemObjectBuilder builder) {
        super.setBuilder(builder);
    }

    public IBond[] getBonds() {
        return this.getCarriers().toArray(new IBond[0]);
    }

    public IBond getStereoBond() {
        return (IBond)this.getFocus();
    }

    public IDoubleBondStereochemistry.Conformation getStereo() {
        return IDoubleBondStereochemistry.Conformation.toConformation((int)this.getConfigOrder());
    }

    public IDoubleBondStereochemistry map(Map<IAtom, IAtom> atoms, Map<IBond, IBond> bonds) {
        return (IDoubleBondStereochemistry)super.map(atoms, bonds);
    }

    @Override
    protected IStereoElement<IBond, IBond> create(IBond focus, List<IBond> carriers, int cfg) {
        return new DoubleBondStereochemistry(focus, carriers.toArray(new IBond[2]), cfg);
    }
}

