/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.chartPanel;

import dmLab.gui.chartPanel.DataSeries;
import dmLab.gui.chartPanel.LineChart;
import dmLab.utils.GeneralUtils;
import dmLab.utils.MathUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class MyLineChart
extends LineChart {
    private float[] x;
    private float[] y;
    private float[] xValues;
    private float[] yValues;
    private float maxX;
    private float maxY;
    private float minX;
    private float minY;
    private final int defaultBorder = 20;
    private final int maxNumberOfLabes = 10;
    private final int defaultArrowSize = 5;

    /*
     * WARNING - void declaration
     */
    public MyLineChart(String chartTitle, int imageWidth, int imageHeight) {
        super((String)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final BufferedImage draw(ArrayList<DataSeries> series) {
        MyLineChart myLineChart;
        DataSeries s = series.get(0);
        String cfr_ignored_0 = s.seriesTitle;
        float[] fArray = ((DataSeries)((Object)myLineChart)).y;
        float[] fArray2 = s.x;
        myLineChart = this;
        this.x = (float[])fArray2.clone();
        myLineChart.y = (float[])fArray.clone();
        myLineChart.xValues = (float[])fArray2.clone();
        myLineChart.yValues = (float[])fArray.clone();
        myLineChart.maxX = MathUtils.maxValue(fArray2);
        myLineChart.maxY = MathUtils.maxValue(fArray);
        myLineChart.minX = MathUtils.minValue(fArray2);
        myLineChart.minY = MathUtils.minValue(fArray);
        if (fArray2.length == fArray.length) {
            for (int i = 0; i < fArray2.length; ++i) {
                if (myLineChart.maxX - myLineChart.minX != 0.0f) {
                    myLineChart.x[i] = (fArray2[i] - myLineChart.minX) / (myLineChart.maxX - myLineChart.minX);
                }
                if (myLineChart.maxY - myLineChart.minY == 0.0f) continue;
                myLineChart.y[i] = 1.0f - (fArray[i] - myLineChart.minY) / (myLineChart.maxY - myLineChart.minY);
            }
        }
        return ((LineChart)myLineChart).redraw();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BufferedImage redraw() {
        void var1_1;
        if (this.x == null || this.y == null) {
            return null;
        }
        BufferedImage img = new BufferedImage(this.imgWidth, this.imgHeight, 1);
        Graphics g = img.getGraphics();
        g.setColor(Color.white);
        Polygon p = new Polygon();
        p.addPoint(0, 0);
        p.addPoint(this.imgWidth, 0);
        p.addPoint(this.imgWidth, this.imgHeight);
        p.addPoint(0, this.imgHeight);
        g.fillPolygon(p);
        g.setColor(Color.black);
        g.drawLine(20, this.imgHeight - 20, this.imgWidth - 20, this.imgHeight - 20);
        g.drawLine(this.imgWidth - 20, this.imgHeight - 20, this.imgWidth - 20 - 5, this.imgHeight - 20 + 5);
        g.drawLine(this.imgWidth - 20, this.imgHeight - 20, this.imgWidth - 20 - 5, this.imgHeight - 20 - 5);
        g.drawLine(20, 20, 20, this.imgHeight - 20);
        g.drawLine(20, 20, 25, 25);
        g.drawLine(20, 20, 15, 25);
        float sizeX = this.imgWidth - 40;
        float sizeY = this.imgHeight - 40;
        int lastCoordinateX = 0;
        int lastCoordinateY = 0;
        if (this.x.length != this.y.length) {
            g.drawString("Error x.length!=y.length", this.imgWidth / 4, this.imgHeight / 2);
        } else {
            int scale = 1;
            if (this.x.length > 10) {
                scale = (int)Math.ceil((double)this.x.length / 10.0);
            }
            if (scale <= 0) {
                scale = 1;
            }
            for (int i = 0; i < this.x.length; ++i) {
                int coordinateX = (int)(20.0f + sizeX * this.x[i]);
                int coordinateY = (int)(20.0f + sizeY * this.y[i]);
                if (i % scale == 0) {
                    g.drawString(GeneralUtils.formatFloat(this.xValues[i], 1), coordinateX, this.imgHeight);
                    g.drawString(GeneralUtils.formatFloat(this.yValues[i], 1), 0, coordinateY);
                }
                if (i > 0) {
                    g.drawLine(lastCoordinateX, lastCoordinateY, coordinateX, coordinateY);
                }
                lastCoordinateX = coordinateX;
                lastCoordinateY = coordinateY;
            }
        }
        return var1_1;
    }
}

