/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.protocol.json;

import com.simba.athena.amazonaws.AmazonServiceException;
import com.simba.athena.amazonaws.AmazonWebServiceResponse;
import com.simba.athena.amazonaws.SDKGlobalConfiguration;
import com.simba.athena.amazonaws.annotation.SdkProtectedApi;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.http.HttpResponseHandler;
import com.simba.athena.amazonaws.protocol.OperationInfo;
import com.simba.athena.amazonaws.protocol.Protocol;
import com.simba.athena.amazonaws.protocol.ProtocolRequestMarshaller;
import com.simba.athena.amazonaws.protocol.json.JsonClientMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonContentTypeResolver;
import com.simba.athena.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonOperationMetadata;
import com.simba.athena.amazonaws.protocol.json.JsonProtocolMarshallerBuilder;
import com.simba.athena.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.simba.athena.amazonaws.protocol.json.SdkStructuredCborFactory;
import com.simba.athena.amazonaws.protocol.json.SdkStructuredIonFactory;
import com.simba.athena.amazonaws.protocol.json.SdkStructuredJsonFactory;
import com.simba.athena.amazonaws.protocol.json.SdkStructuredPlainJsonFactory;
import com.simba.athena.amazonaws.protocol.json.StructuredJsonGenerator;
import com.simba.athena.amazonaws.transform.JsonErrorUnmarshaller;
import com.simba.athena.amazonaws.transform.JsonUnmarshallerContext;
import com.simba.athena.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
@SdkProtectedApi
public class SdkJsonProtocolFactory
implements SdkJsonMarshallerFactory {
    private final JsonClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkJsonProtocolFactory(JsonClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    @Override
    public StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @Override
    public String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.metadata);
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return JsonProtocolMarshallerBuilder.standard().jsonGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).sendExplicitNullForPayload(false).build();
    }

    private StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(this.errorUnmarshallers, errorResponsMetadata.getCustomErrorCodeFieldName());
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
    }

    private SdkStructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? SdkStructuredIonFactory.SDK_ION_BINARY_FACTORY : SdkStructuredIonFactory.SDK_ION_TEXT_FACTORY;
        }
        return SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return JsonContentTypeResolver.CBOR;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? JsonContentTypeResolver.ION_BINARY : JsonContentTypeResolver.ION_TEXT;
        }
        return JsonContentTypeResolver.JSON;
    }

    private boolean isCborEnabled() {
        return this.metadata.isSupportsCbor() && !SDKGlobalConfiguration.isCborDisabled();
    }

    private boolean isIonEnabled() {
        return this.metadata.isSupportsIon();
    }

    boolean isIonBinaryEnabled() {
        return !SDKGlobalConfiguration.isIonBinaryDisabled();
    }
}

