/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.iamsupport.model.CredentialsHolder;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.shaded.apache.http.HttpEntity;
import com.simba.athena.shaded.apache.http.NameValuePair;
import com.simba.athena.shaded.apache.http.client.entity.UrlEncodedFormEntity;
import com.simba.athena.shaded.apache.http.client.methods.CloseableHttpResponse;
import com.simba.athena.shaded.apache.http.client.methods.HttpGet;
import com.simba.athena.shaded.apache.http.client.methods.HttpPost;
import com.simba.athena.shaded.apache.http.impl.client.CloseableHttpClient;
import com.simba.athena.shaded.apache.http.message.BasicNameValuePair;
import com.simba.athena.shaded.apache.http.util.EntityUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PingCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private static final String KEY_PARTNER_SPID = "partner_spid";
    protected String m_partnerSpId;

    @Override
    public void addParameter(String string, String string2) {
        super.addParameter(string, string2);
        if (KEY_PARTNER_SPID.equalsIgnoreCase(string)) {
            this.m_partnerSpId = string2;
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        this.m_partnerSpId = StringUtils.isNullOrEmpty(this.m_partnerSpId) ? "urn%3Aamazon%3Awebservices" : URLEncoder.encode(this.m_partnerSpId, "UTF-8");
        String string = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/idp/startSSO.ping?PartnerSpId=" + this.m_partnerSpId;
        CloseableHttpClient closeableHttpClient = null;
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(5);
        try {
            Object object;
            String string2;
            closeableHttpClient = this.getHttpClient();
            HttpGet httpGet = new HttpGet(string);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpGet);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            String string3 = EntityUtils.toString(httpEntity);
            for (String object22 : this.getInputTagsfromHTML(string3)) {
                string2 = this.getValueByKey(object22, "name");
                object = this.getValueByKey(object22, "value");
                if (string2.contains("user") || string2.contains("email")) {
                    arrayList.add(new BasicNameValuePair(string2, this.m_userName));
                    continue;
                }
                if (string2.contains("pass")) {
                    arrayList.add(new BasicNameValuePair(string2, this.m_password));
                    continue;
                }
                if (StringUtils.isNullOrEmpty(string2)) continue;
                arrayList.add(new BasicNameValuePair(string2, (String)object));
            }
            String string4 = this.getFormAction(string3);
            if (!StringUtils.isNullOrEmpty(string4) && string4.startsWith("/")) {
                string = "https://" + this.m_idpHost + ':' + this.m_idpPort + (String)string4;
            }
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)arrayList));
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + closeableHttpResponse.getStatusLine().getReasonPhrase());
            }
            string2 = EntityUtils.toString(closeableHttpResponse.getEntity());
            object = SAML_PATTERN.matcher(string2);
            if (!((Matcher)object).find()) {
                throw new IOException("Failed to retrieve SAMLAssertion.");
            }
            String string5 = ((Matcher)object).group(1);
            return string5;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SdkClientException("Failed create SSLContext.", generalSecurityException);
        }
        finally {
            IOUtils.closeQuietly(closeableHttpClient, null);
        }
    }

    @Override
    protected CredentialsHolder performPostSAMLAction(String string, String string2, CredentialsHolder credentialsHolder) throws SdkClientException {
        return null;
    }
}

