/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.IntegrableUnivariateFunction;
import dr.math.RiemannApproximation;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public abstract class SpatialKernel
extends AbstractModel
implements IntegrableUnivariateFunction {
    private ArrayList<Parameter> params;
    public static final String SPATIAL_KERNEL_FUNCTION = "spatialKernelFunction";
    public static final String PARAMETERS = "parameters";
    public static final String KERNEL_TYPE = "type";
    public static final String INTEGRATOR_STEPS = "integratorSteps";
    public static final String ALPHA = "kernel.alpha";
    public static final String R_0 = "kernel.r0";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("parameters", new XMLSyntaxRule[]{new ElementRule(Parameter.class, 1, Integer.MAX_VALUE)}, 1, 1), AttributeRule.newStringRule("type"), AttributeRule.newIntegerRule("integratorSteps", true)};

        @Override
        public String getParserName() {
            return SpatialKernel.SPATIAL_KERNEL_FUNCTION;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            try {
                String string = (String)xMLObject.getAttribute(SpatialKernel.KERNEL_TYPE);
                XMLObject xMLObject2 = xMLObject.getChild(SpatialKernel.PARAMETERS);
                ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
                for (int i = 0; i < xMLObject2.getChildCount(); ++i) {
                    Parameter object = (Parameter)xMLObject2.getChild(i);
                    arrayList.add(object);
                }
                SpatialKernel spatialKernel = null;
                for (Type type : Type.values()) {
                    if (!type.getXmlName().equals(string)) continue;
                    spatialKernel = type.makeKernelFunction(arrayList);
                }
                if (spatialKernel == null) {
                    throw new XMLParseException("Unknown spatial kernel type");
                }
                if (xMLObject.hasAttribute(SpatialKernel.INTEGRATOR_STEPS)) {
                    spatialKernel.configureIntegrator(Integer.parseInt((String)xMLObject.getAttribute(SpatialKernel.INTEGRATOR_STEPS)));
                }
                return spatialKernel;
            }
            catch (Exception exception) {
                throw new XMLParseException("Failed to initiate spatial kernel (" + exception.toString() + ")");
            }
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a spatial kernel function with a single parameter.";
        }

        @Override
        public Class getReturnType() {
            return SpatialKernel.class;
        }
    };

    public SpatialKernel(String string) {
        super(string);
    }

    public ArrayList<Parameter> getParams() {
        return this.params;
    }

    public Parameter getParam(int n) {
        return this.params.get(n);
    }

    public void setParam(int n, Parameter parameter) {
        this.params.set(n, parameter);
    }

    public static double EuclideanDistance(double[] dArray, double[] dArray2) {
        return Math.sqrt(Math.pow(dArray[0] - dArray2[0], 2.0) + Math.pow(dArray[1] - dArray2[1], 2.0));
    }

    @Override
    public double getUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getLowerBound() {
        return 0.0;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    public double value(double d) {
        return this.evaluate(d);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void acceptState() {
    }

    public void configureIntegrator(int n) {
    }

    public abstract SpatialKernel newInstance(ArrayList<Parameter> var1) throws InstantiationException;

    public class Logistic
    extends SpatialKernel {
        private Parameter alpha;
        private Parameter r_0;
        RiemannApproximation integrator;

        @Override
        public SpatialKernel newInstance(ArrayList<Parameter> arrayList) throws InstantiationException {
            return new Logistic(Type.LOGISTIC.getXmlName(), arrayList);
        }

        public Logistic() throws InstantiationException {
            this(Type.GAUSSIAN.getXmlName(), null);
        }

        public Logistic(String string, ArrayList<Parameter> arrayList) throws InstantiationException {
            this(string, arrayList, 25);
        }

        @Override
        public void configureIntegrator(int n) {
            this.integrator = new RiemannApproximation(n);
        }

        public Logistic(String string, ArrayList<Parameter> arrayList, int n) throws InstantiationException {
            super(string);
            if (arrayList.size() != 2) {
                throw new InstantiationException("Wrong number of parameters for this spatial kernal function");
            }
            boolean bl = false;
            boolean bl2 = false;
            for (Parameter parameter : arrayList) {
                if (parameter.getId().equals(SpatialKernel.ALPHA)) {
                    bl = true;
                    this.alpha = parameter;
                }
                if (!parameter.getId().equals(SpatialKernel.R_0)) continue;
                bl2 = true;
                this.r_0 = parameter;
            }
            if (!bl || !bl2) {
                throw new InstantiationException("Kernel function does not have the required parameters");
            }
            this.addVariable(this.alpha);
            this.addVariable(this.r_0);
            this.integrator = new RiemannApproximation(n);
        }

        @Override
        public double evaluate(double d) {
            return this.evaluate(d, this.alpha.getParameterValue(0), this.r_0.getParameterValue(0));
        }

        public double evaluate(double d, double d2, double d3) {
            return 1.0 / (1.0 + Math.pow(d / d3, d2));
        }

        @Override
        public double evaluateIntegral(double d, double d2) {
            return this.integrator.integrate(this, d, d2);
        }
    }

    public class Gaussian
    extends SpatialKernel {
        private Parameter alpha;
        RiemannApproximation integrator;

        @Override
        public SpatialKernel newInstance(ArrayList<Parameter> arrayList) throws InstantiationException {
            return new Gaussian(Type.GAUSSIAN.getXmlName(), arrayList);
        }

        public Gaussian(String string, ArrayList<Parameter> arrayList) throws InstantiationException {
            this(string, arrayList, 25);
        }

        public Gaussian() throws InstantiationException {
            this(Type.GAUSSIAN.getXmlName(), null);
        }

        @Override
        public void configureIntegrator(int n) {
            this.integrator = new RiemannApproximation(n);
        }

        public Gaussian(String string, ArrayList<Parameter> arrayList, int n) throws InstantiationException {
            super(string);
            if (arrayList.size() != 1) {
                throw new InstantiationException("Wrong number of parameters for this spatial kernal function");
            }
            if (!arrayList.get(0).getId().equals(SpatialKernel.ALPHA)) {
                throw new InstantiationException("No parameter named alpha");
            }
            this.alpha = arrayList.get(0);
            this.addVariable(this.alpha);
            this.integrator = new RiemannApproximation(n);
        }

        @Override
        public double evaluate(double d) {
            return this.evaluate(d, this.alpha.getParameterValue(0));
        }

        public double evaluate(double d, double d2) {
            return Math.exp(-Math.pow(d, 2.0) * d2);
        }

        @Override
        public double evaluateIntegral(double d, double d2) {
            return this.integrator.integrate(this, d, d2);
        }
    }

    public class PowerLaw
    extends SpatialKernel {
        private Parameter alpha;

        @Override
        public SpatialKernel newInstance(ArrayList<Parameter> arrayList) throws InstantiationException {
            return new PowerLaw(Type.POWER_LAW.getXmlName(), arrayList);
        }

        public PowerLaw(String string, ArrayList<Parameter> arrayList) throws InstantiationException {
            super(string);
            if (arrayList.size() != 1) {
                throw new InstantiationException("Wrong number of parameters for this spatial kernal function");
            }
            if (!arrayList.get(0).getId().equals(SpatialKernel.ALPHA)) {
                throw new InstantiationException("No parameter named alpha");
            }
            this.alpha = arrayList.get(0);
            this.addVariable(this.alpha);
        }

        public PowerLaw() throws InstantiationException {
            this(Type.POWER_LAW.getXmlName(), null);
        }

        @Override
        public double evaluate(double d) {
            return this.evaluate(d, this.alpha.getParameterValue(0));
        }

        public double evaluate(double d, double d2) {
            return Math.pow(d, -d2);
        }

        @Override
        public double evaluateIntegral(double d, double d2) {
            double d3 = ((Parameter)SpatialKernel.this.params.get(0)).getParameterValue(0);
            return -d3 * Math.pow(d2, -d3 - 1.0) + -d3 * Math.pow(d, -d3 - 1.0);
        }
    }

    public class Exponential
    extends SpatialKernel {
        private Parameter alpha;

        @Override
        public SpatialKernel newInstance(ArrayList<Parameter> arrayList) throws InstantiationException {
            return new Exponential(Type.EXPONENTIAL.getXmlName(), arrayList);
        }

        public Exponential(String string, ArrayList<Parameter> arrayList) throws InstantiationException {
            super(string);
            if (arrayList.size() != 1) {
                throw new InstantiationException("Wrong number of parameters for this spatial kernal function");
            }
            if (!arrayList.get(0).getId().equals(SpatialKernel.ALPHA)) {
                throw new InstantiationException("No parameter named alpha");
            }
            this.alpha = arrayList.get(0);
            this.addVariable(this.alpha);
        }

        public Exponential() throws InstantiationException {
            this(Type.EXPONENTIAL.getXmlName(), null);
        }

        @Override
        public double evaluate(double d) {
            return this.evaluate(d, this.alpha.getParameterValue(0));
        }

        public double evaluate(double d, double d2) {
            return Math.exp(-d * d2);
        }

        @Override
        public double evaluateIntegral(double d, double d2) {
            double d3 = this.alpha.getParameterValue(0);
            return -(1.0 / d3) * Math.exp(-d3 * d2) + 1.0 / d3 * Math.exp(-d3 * d);
        }
    }

    public static enum Type {
        EXPONENTIAL("exponential", Exponential.class),
        POWER_LAW("powerLaw", PowerLaw.class),
        GAUSSIAN("gaussian", Gaussian.class),
        LOGISTIC("logistic", Logistic.class);

        private final String xmlName;
        private final Class kernelClass;

        String getXmlName() {
            return this.xmlName;
        }

        SpatialKernel makeKernelFunction(ArrayList<Parameter> arrayList) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
            Constructor constructor = this.kernelClass.getConstructor(SpatialKernel.class, String.class, ArrayList.class);
            return (SpatialKernel)constructor.newInstance(null, this.xmlName, arrayList);
        }

        private Type(String string2, Class clazz) {
            this.xmlName = string2;
            this.kernelClass = clazz;
        }
    }
}

