/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.GammaDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GammaDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
GradientProvider,
HessianProvider {
    public static final String GAMMA_DISTRIBUTION_MODEL = "gammaDistributionModel";
    public static final String ONE_P_GAMMA_DISTRIBUTION_MODEL = "onePGammaDistributionModel";
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return GammaDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return GammaDistributionModel.this.offset;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final GammaParameterizationType parameterization;
    private final Variable<Double> shape;
    private final Variable<Double> scale;
    private final Variable<Double> rate;
    private final Variable<Double> mean;
    private final double offset;

    public GammaDistributionModel(Variable<Double> variable, Variable<Double> variable2) {
        this(GammaParameterizationType.ShapeScale, variable, variable2, 0.0);
    }

    public GammaDistributionModel(Variable<Double> variable) {
        this(GammaParameterizationType.OneParameter, variable, null, 0.0);
    }

    public GammaDistributionModel(GammaParameterizationType gammaParameterizationType, Variable<Double> variable, Variable<Double> variable2, double d) {
        super(GAMMA_DISTRIBUTION_MODEL);
        this.offset = d;
        this.parameterization = gammaParameterizationType;
        this.shape = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        switch (gammaParameterizationType) {
            case ShapeScale: {
                this.scale = variable2;
                this.addVariable(this.scale);
                this.scale.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
                this.rate = null;
                this.mean = null;
                break;
            }
            case ShapeRate: {
                this.rate = variable2;
                this.addVariable(this.rate);
                this.rate.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
                this.scale = null;
                this.mean = null;
                break;
            }
            case ShapeMean: {
                this.mean = variable2;
                this.addVariable(this.mean);
                this.mean.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
                this.scale = null;
                this.rate = null;
                break;
            }
            case OneParameter: {
                this.scale = null;
                this.rate = null;
                this.mean = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown parameterization type");
            }
        }
    }

    @Override
    public double pdf(double d) {
        if (d < this.offset) {
            return 0.0;
        }
        return GammaDistribution.pdf(d - this.offset, this.getShape(), this.getScale());
    }

    @Override
    public double logPdf(double d) {
        if (d < this.offset) {
            return Double.NEGATIVE_INFINITY;
        }
        return GammaDistribution.logPdf(d - this.offset, this.getShape(), this.getScale());
    }

    @Override
    public double cdf(double d) {
        if (d < this.offset) {
            return 0.0;
        }
        return GammaDistribution.cdf(d - this.offset, this.getShape(), this.getScale());
    }

    @Override
    public double quantile(double d) {
        try {
            return new GammaDistributionImpl(this.getShape(), this.getScale()).inverseCumulativeProbability(d) + this.offset;
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
    }

    @Override
    public double mean() {
        return GammaDistribution.mean(this.getShape(), this.getScale()) + this.offset;
    }

    @Override
    public double variance() {
        return GammaDistribution.variance(this.getShape(), this.getScale());
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        double d = this.getShape();
        double d2 = this.getScale();
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = GammaDistribution.gradLogPdf(dArray[i] - this.offset, d, d2);
        }
        return dArray2;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        double[] dArray = GradientProvider.toDoubleArray(object);
        double[] dArray2 = new double[dArray.length];
        double d = this.getShape();
        double d2 = this.getScale();
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = GammaDistribution.hessianLogPdf(dArray[i] - this.offset, d, d2);
        }
        return dArray2;
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        return HessianProvider.expandDiagonals(this.getDiagonalHessianLogDensity(object));
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    public double getShape() {
        return this.shape.getValue(0);
    }

    public double getScale() {
        switch (this.parameterization) {
            case ShapeScale: {
                return this.scale.getValue(0);
            }
            case ShapeRate: {
                return 1.0 / this.rate.getValue(0);
            }
            case ShapeMean: {
                return this.mean.getValue(0) / this.getShape();
            }
            case OneParameter: {
                return 1.0 / this.getShape();
            }
        }
        throw new IllegalArgumentException("Unknown parameterization type");
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static enum GammaParameterizationType {
        ShapeScale,
        ShapeRate,
        ShapeMean,
        OneParameter;

    }
}

