/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.RandomGenerator;
import dr.math.distributions.TDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TDistributionModel
extends AbstractModel
implements ParametricDistributionModel,
RandomGenerator {
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return TDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> location;
    private final Variable<Double> scale;
    private final Variable<Double> df;

    public TDistributionModel(Parameter parameter, Parameter parameter2, Parameter parameter3) {
        super("normalDistributionModel");
        this.location = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.scale = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.df = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public double getLocation() {
        return this.location.getValue(0);
    }

    public double getScale() {
        return this.scale.getValue(0);
    }

    public double getDF() {
        return this.df.getValue(0);
    }

    @Override
    public double pdf(double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double logPdf(double d) {
        return TDistribution.logPDF(d, this.getLocation(), this.getScale(), this.getDF());
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.location;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Object nextRandom() {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double logPdf(Object object) {
        double d = (Double)object;
        return this.logPdf(d);
    }
}

