/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Copyable;

public class FastVector
implements Copyable,
Serializable {
    private Object[] m_Objects;
    private int m_Size = 0;
    private int m_CapacityIncrement = 1;
    private int m_CapacityMultiplier = 2;

    public FastVector() {
        this.m_Objects = new Object[0];
    }

    public FastVector(int n) {
        this.m_Objects = new Object[n];
    }

    public final void addElement(Object object) {
        if (this.m_Size == this.m_Objects.length) {
            Object[] objectArray = new Object[this.m_CapacityMultiplier * (this.m_Objects.length + this.m_CapacityIncrement)];
            System.arraycopy(this.m_Objects, 0, objectArray, 0, this.m_Size);
            this.m_Objects = objectArray;
        }
        this.m_Objects[this.m_Size] = object;
        ++this.m_Size;
    }

    public final int capacity() {
        return this.m_Objects.length;
    }

    public final Object copy() {
        FastVector fastVector = new FastVector(this.m_Objects.length);
        fastVector.m_Size = this.m_Size;
        fastVector.m_CapacityIncrement = this.m_CapacityIncrement;
        fastVector.m_CapacityMultiplier = this.m_CapacityMultiplier;
        System.arraycopy(this.m_Objects, 0, fastVector.m_Objects, 0, this.m_Size);
        return fastVector;
    }

    public final Object copyElements() {
        FastVector fastVector = new FastVector(this.m_Objects.length);
        fastVector.m_Size = this.m_Size;
        fastVector.m_CapacityIncrement = this.m_CapacityIncrement;
        fastVector.m_CapacityMultiplier = this.m_CapacityMultiplier;
        for (int i = 0; i < this.m_Size; ++i) {
            fastVector.m_Objects[i] = ((Copyable)this.m_Objects[i]).copy();
        }
        return fastVector;
    }

    public final Object elementAt(int n) {
        return this.m_Objects[n];
    }

    public final Enumeration elements() {
        return new FastVectorEnumeration(this);
    }

    public final Enumeration elements(int n) {
        return new FastVectorEnumeration(this, n);
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < this.m_Objects.length; ++i) {
            if (!object.equals(this.m_Objects[i])) continue;
            return true;
        }
        return false;
    }

    public final Object firstElement() {
        return this.m_Objects[0];
    }

    public final int indexOf(Object object) {
        for (int i = 0; i < this.m_Size; ++i) {
            if (!object.equals(this.m_Objects[i])) continue;
            return i;
        }
        return -1;
    }

    public final void insertElementAt(Object object, int n) {
        if (this.m_Size < this.m_Objects.length) {
            System.arraycopy(this.m_Objects, n, this.m_Objects, n + 1, this.m_Size - n);
            this.m_Objects[n] = object;
        } else {
            Object[] objectArray = new Object[this.m_CapacityMultiplier * (this.m_Objects.length + this.m_CapacityIncrement)];
            System.arraycopy(this.m_Objects, 0, objectArray, 0, n);
            objectArray[n] = object;
            System.arraycopy(this.m_Objects, n, objectArray, n + 1, this.m_Size - n);
            this.m_Objects = objectArray;
        }
        ++this.m_Size;
    }

    public final Object lastElement() {
        return this.m_Objects[this.m_Size - 1];
    }

    public final void removeElementAt(int n) {
        System.arraycopy(this.m_Objects, n + 1, this.m_Objects, n, this.m_Size - n - 1);
        this.m_Objects[this.m_Size - 1] = null;
        --this.m_Size;
    }

    public final void removeAllElements() {
        this.m_Objects = new Object[this.m_Objects.length];
        this.m_Size = 0;
    }

    public final void appendElements(FastVector fastVector) {
        this.setCapacity(this.size() + fastVector.size());
        System.arraycopy(fastVector.m_Objects, 0, this.m_Objects, this.size(), fastVector.size());
        this.m_Size = this.m_Objects.length;
    }

    public final Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.m_Objects, 0, objectArray, 0, this.size());
        return objectArray;
    }

    public final void setCapacity(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.m_Objects, 0, objectArray, 0, Math.min(n, this.m_Size));
        this.m_Objects = objectArray;
        if (this.m_Objects.length < this.m_Size) {
            this.m_Size = this.m_Objects.length;
        }
    }

    public final void setElementAt(Object object, int n) {
        this.m_Objects[n] = object;
    }

    public final int size() {
        return this.m_Size;
    }

    public final void swap(int n, int n2) {
        Object object = this.m_Objects[n];
        this.m_Objects[n] = this.m_Objects[n2];
        this.m_Objects[n2] = object;
    }

    public final void trimToSize() {
        Object[] objectArray = new Object[this.m_Size];
        System.arraycopy(this.m_Objects, 0, objectArray, 0, this.m_Size);
        this.m_Objects = objectArray;
    }

    public class FastVectorEnumeration
    implements Enumeration {
        private int m_Counter;
        private FastVector m_Vector;
        private int m_SpecialElement;

        public FastVectorEnumeration(FastVector fastVector2) {
            this.m_Counter = 0;
            this.m_Vector = fastVector2;
            this.m_SpecialElement = -1;
        }

        public FastVectorEnumeration(FastVector fastVector2, int n) {
            this.m_Vector = fastVector2;
            this.m_SpecialElement = n;
            this.m_Counter = n == 0 ? 1 : 0;
        }

        public final boolean hasMoreElements() {
            return this.m_Counter < this.m_Vector.size();
        }

        public final Object nextElement() {
            Object object = this.m_Vector.elementAt(this.m_Counter);
            ++this.m_Counter;
            if (this.m_Counter == this.m_SpecialElement) {
                ++this.m_Counter;
            }
            return object;
        }
    }
}

