/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.Global;
import org.openfast.NumericValue;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.IntegerCodec;

public final class SignedInteger
extends IntegerCodec {
    private static final long serialVersionUID = 1L;

    SignedInteger() {
    }

    public byte[] encodeValue(ScalarValue value) {
        long longValue = ((NumericValue)value).toLong();
        int size = SignedInteger.getSignedIntegerSize(longValue);
        byte[] encoding = new byte[size];
        int factor = 0;
        while (factor < size) {
            int bitMask = factor == size - 1 ? 63 : 127;
            encoding[size - factor - 1] = (byte)(longValue >> factor * 7 & (long)bitMask);
            ++factor;
        }
        encoding[0] = (byte)((long)encoding[0] | 0x40L & longValue >> 57);
        return encoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScalarValue decode(InputStream in) {
        long value = 0L;
        try {
            int byt = in.read();
            if (byt < 0) {
                Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                return null;
            }
            if ((byt & 0x40) > 0) {
                value = -1L;
            }
            value = value << 7 | (long)(byt & 0x7F);
            while (true) {
                if ((byt & 0x80) != 0) {
                    return SignedInteger.createValue(value);
                }
                byt = in.read();
                if (byt < 0) {
                    Global.handleError(FastConstants.END_OF_STREAM, "The end of the input stream has been reached.");
                    return null;
                }
                value = value << 7 | (long)(byt & 0x7F);
            }
        }
        catch (IOException e) {
            Global.handleError(FastConstants.IO_ERROR, "A IO error has been encountered while decoding.", e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

