/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.calendar;

import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.NationalCalendar;
import ec.tstoolkit.timeseries.calendars.NationalCalendarProvider;
import ec.tstoolkit.timeseries.calendars.SpecialDayEvent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jd2.xml.calendar.AbstractXmlCalendar;
import jd2.xml.calendar.XmlSpecialDayEvent;

@XmlRootElement(name="nationalCalendar")
@XmlType(name="nationalCalendarType")
public class XmlNationalCalendar
extends AbstractXmlCalendar {
    static final String NAME = "nationalCalendarType";
    @XmlElement(name="specialDayEvent")
    public XmlSpecialDayEvent[] sd;
    @XmlAttribute
    public Boolean meancorrection;
    @XmlAttribute
    public Boolean julianCal;

    private void setMean(boolean mean) {
        this.meancorrection = !mean ? Boolean.valueOf(mean) : null;
    }

    private boolean isMean() {
        return this.meancorrection == null ? true : this.meancorrection;
    }

    private void setJulian(boolean julian) {
        this.julianCal = julian ? Boolean.valueOf(julian) : null;
    }

    private boolean isJulian() {
        return this.julianCal == null ? false : this.julianCal;
    }

    public static XmlNationalCalendar create(String code, GregorianCalendarManager mgr) {
        IGregorianCalendarProvider cal = (IGregorianCalendarProvider)mgr.get(code);
        if (cal == null || !(cal instanceof NationalCalendarProvider)) {
            return null;
        }
        NationalCalendarProvider t = (NationalCalendarProvider)cal;
        XmlNationalCalendar xcal = new XmlNationalCalendar();
        xcal.name = code;
        xcal.setMean(t.isLongTermMeanCorrection());
        xcal.setJulian(t.isJulianEaster());
        int n = t.events().size();
        if (n > 0) {
            xcal.sd = new XmlSpecialDayEvent[n];
            int i = 0;
            for (SpecialDayEvent s : t.events()) {
                XmlSpecialDayEvent tmp = new XmlSpecialDayEvent();
                tmp.copy(s);
                xcal.sd[i++] = tmp;
            }
        }
        return xcal;
    }

    @Override
    public boolean addTo(GregorianCalendarManager mgr) {
        NationalCalendar nc = new NationalCalendar(this.isMean(), this.isJulian());
        if (this.sd != null) {
            for (int i = 0; i < this.sd.length; ++i) {
                nc.add(this.sd[i].create());
            }
        }
        NationalCalendarProvider rslt = new NationalCalendarProvider(nc);
        if (this.name != null) {
            mgr.set(this.name, (Object)rslt);
            return true;
        }
        return false;
    }
}

