/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.TrackingTripleIterator;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleEventManager
implements GraphEventManager {
    protected Graph graph;
    protected List listeners;

    SimpleEventManager(Graph graph) {
        this.graph = graph;
        this.listeners = new ArrayList();
    }

    public GraphEventManager register(GraphListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public GraphEventManager unregister(GraphListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public boolean listening() {
        return this.listeners.size() > 0;
    }

    public void notifyAddTriple(Graph g, Triple t) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddTriple(g, t);
        }
    }

    public void notifyAddArray(Graph g, Triple[] ts) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddArray(g, ts);
        }
    }

    public void notifyAddList(Graph g, List L) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddList(g, L);
        }
    }

    public void notifyAddIterator(Graph g, List it) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddIterator(g, it.iterator());
        }
    }

    public void notifyAddIterator(Graph g, Iterator it) {
        this.notifyAddIterator(g, IteratorCollection.iteratorToList(it));
    }

    public void notifyAddGraph(Graph g, Graph added) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyAddGraph(g, added);
        }
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteTriple(g, t);
        }
    }

    public void notifyDeleteArray(Graph g, Triple[] ts) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteArray(g, ts);
        }
    }

    public void notifyDeleteList(Graph g, List L) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteList(g, L);
        }
    }

    public void notifyDeleteIterator(Graph g, List L) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteIterator(g, L.iterator());
        }
    }

    public void notifyDeleteIterator(Graph g, Iterator it) {
        this.notifyDeleteIterator(g, IteratorCollection.iteratorToList(it));
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyDeleteGraph(g, removed);
        }
    }

    public void notifyEvent(Graph source, Object event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((GraphListener)this.listeners.get(i)).notifyEvent(source, event);
        }
    }

    public static ExtendedIterator notifyingRemove(final Graph g, Iterator i) {
        return new TrackingTripleIterator(i){
            protected final GraphEventManager gem;
            {
                super(x0);
                this.gem = g.getEventManager();
            }

            public void remove() {
                super.remove();
                this.gem.notifyDeleteTriple(g, this.current);
            }
        };
    }
}

