/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR;

import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.Rule;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyCFAR.myDataset;
import org.core.Fichero;

public class RuleBase {
    ArrayList<Rule> ruleBase;
    DataBase dataBase;
    myDataset train;
    int WrongNDefault;
    int n_variables;
    int fitness;
    int[] totalLabels;

    public boolean BETTER(int a, int b) {
        return a > b;
    }

    public RuleBase() {
    }

    public RuleBase(DataBase dataBase, myDataset train) {
        this.ruleBase = new ArrayList();
        this.dataBase = dataBase;
        this.train = train;
        this.n_variables = dataBase.numVariables();
        this.fitness = 0;
        this.totalLabels = new int[this.n_variables];
        for (int i = 0; i < this.n_variables; ++i) {
            this.totalLabels[i] = dataBase.numLabels(i);
        }
    }

    public RuleBase clone() {
        int i;
        RuleBase br = new RuleBase();
        br.ruleBase = new ArrayList();
        for (i = 0; i < this.ruleBase.size(); ++i) {
            br.ruleBase.add(this.ruleBase.get(i).clone());
        }
        br.dataBase = this.dataBase;
        br.train = this.train;
        br.n_variables = this.n_variables;
        br.fitness = this.fitness;
        br.totalLabels = new int[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            br.totalLabels[i] = this.totalLabels[i];
        }
        return br;
    }

    public void add(Rule rule) {
        this.ruleBase.add(rule);
    }

    public void add(Itemset itemset, long time) {
        int i;
        int[] antecedent = new int[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            antecedent[i] = -1;
        }
        for (i = 0; i < itemset.size(); ++i) {
            Item item = itemset.get(i);
            antecedent[item.getVariable()] = item.getValue();
        }
        Rule r = new Rule(this.dataBase);
        r.asignaAntecedente(antecedent);
        r.setConsequent(itemset.getClas());
        r.setConfidence(itemset.getSupportClass() / itemset.getSupport());
        r.setSupport(itemset.getSupportClass());
        r.setTime(time);
        this.ruleBase.add(r);
    }

    public Rule get(int pos) {
        return this.ruleBase.get(pos);
    }

    public int size() {
        return this.ruleBase.size();
    }

    public void sort() {
        Collections.sort(this.ruleBase);
    }

    public Rule remove(int pos) {
        return this.ruleBase.remove(pos);
    }

    public void removeRules() {
        double minRate = 1.0;
        int pos = -1;
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule rule = this.ruleBase.get(i);
            if (rule.getRightN() < 1) {
                this.ruleBase.remove(i);
                --i;
                continue;
            }
            double rate = 1.0 * (double)rule.getRightN() / (1.0 * (double)rule.getWrongN() + (double)rule.getRightN());
            if (!(rate < minRate)) continue;
            minRate = rate;
            pos = i;
        }
        if (this.ruleBase.size() > 0 && pos > -1) {
            this.ruleBase.remove(pos);
        }
    }

    public void evalua() {
        int n_clasificados = 0;
        for (int j = 0; j < this.train.size(); ++j) {
            int Prediction = this.FRM_WR(this.train.getExample(j));
            if (this.train.getOutputAsInteger(j) != Prediction) continue;
            ++n_clasificados;
        }
        this.fitness = n_clasificados;
    }

    public int FRM(double[] example) {
        return this.FRM_WR(example);
    }

    private int FRM_WR(double[] example) {
        int clas = -1;
        double max = 0.0;
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule r = this.ruleBase.get(i);
            double DF = r.matching(example);
            if (!(DF > max)) continue;
            max = DF;
            clas = r.getClas();
        }
        if (clas < 0) {
            return 0;
        }
        return clas;
    }

    public double getAccuracy() {
        return (double)this.fitness / (double)this.train.size();
    }

    public void selection() {
        Rule rulei;
        int i;
        for (i = 0; i < this.ruleBase.size(); ++i) {
            rulei = this.ruleBase.get(i);
            rulei.orderPrecede();
        }
        this.sort();
        for (i = 0; i < this.ruleBase.size(); ++i) {
            rulei = this.ruleBase.get(i);
            for (int j = i + 1; j < this.ruleBase.size(); ++j) {
                Rule rulej = this.ruleBase.get(j);
                if (!rulei.isSubset(rulej)) continue;
                this.ruleBase.remove(j);
                --j;
            }
        }
    }

    private void rateError() {
        int n_errores = 0;
        for (int j = 0; j < this.train.size(); ++j) {
            int Prediction = this.FRM_WR(this.train.getExample(j));
            if (this.train.getOutputAsInteger(j) == Prediction) continue;
            ++n_errores;
        }
        this.fitness = n_errores;
    }

    public RuleBase classifier() {
        for (int i = 0; i < this.ruleBase.size(); ++i) {
            Rule rule = this.ruleBase.get(i);
            rule.orderDF();
        }
        this.fitness = this.train.size();
        RuleBase bestRuleBase = this.clone();
        System.out.println("Fitness Inicial: " + this.fitness);
        if (this.ruleBase.size() > 1) {
            boolean stop;
            do {
                this.calculateRightNWrongN();
                this.removeRules();
                this.rateError();
                System.out.println("Fitness: " + this.fitness + " NRules: " + this.ruleBase.size());
                stop = true;
                if (this.fitness > bestRuleBase.fitness) continue;
                bestRuleBase = this.clone();
                if (this.ruleBase.size() <= 1 || this.fitness <= 0) continue;
                stop = false;
            } while (!stop);
        }
        bestRuleBase.evalua();
        return bestRuleBase;
    }

    private void calculateRightNWrongN() {
        Rule rule;
        int j;
        int nData = this.train.size();
        for (j = 0; j < this.ruleBase.size(); ++j) {
            rule = this.ruleBase.get(j);
            rule.setIni();
        }
        this.WrongNDefault = 0;
        for (int i = 0; i < nData; ++i) {
            for (j = 0; j < this.ruleBase.size(); ++j) {
                rule = this.ruleBase.get(j);
                rule.matching(this.train.getExample(i));
            }
            this.sort();
            boolean stop = false;
            for (j = 0; j < this.ruleBase.size() && !stop; ++j) {
                rule = this.ruleBase.get(j);
                if (this.train.getOutputAsInteger(i) == rule.getClas()) {
                    rule.incrRightN();
                    stop = true;
                    continue;
                }
                rule.incrWrongN();
            }
        }
    }

    public String printString() {
        int i;
        String[] names = this.train.names();
        String[] clases = this.train.clases();
        String cadena = new String("");
        int ant = 0;
        for (i = 0; i < this.ruleBase.size(); ++i) {
            int j;
            Rule r = this.ruleBase.get(i);
            cadena = cadena + (i + 1) + ": ";
            for (j = 0; j < this.n_variables && r.antecedente[j] < 0; ++j) {
            }
            if (j < this.n_variables && r.antecedente[j] >= 0) {
                cadena = cadena + names[j] + " IS " + r.dataBase.print(j, r.antecedente[j]);
                ++ant;
            }
            ++j;
            while (j < this.n_variables - 1) {
                if (r.antecedente[j] >= 0) {
                    cadena = cadena + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedente[j]);
                    ++ant;
                }
                ++j;
            }
            if (j < this.n_variables && r.antecedente[j] >= 0) {
                cadena = cadena + " AND " + names[j] + " IS " + r.dataBase.print(j, r.antecedente[j]) + ": " + clases[r.clase] + "\n";
                ++ant;
                continue;
            }
            cadena = cadena + ": " + clases[r.clase] + "\n";
        }
        cadena = cadena + (i + 1) + ": Default IS " + clases[0] + "\n";
        cadena = cadena + "\n\n";
        cadena = cadena + "@Dsupp and Dconf:\n\n";
        for (i = 0; i < this.ruleBase.size(); ++i) {
            Rule rule = this.ruleBase.get(i);
            cadena = cadena + (i + 1) + ": ";
            cadena = cadena + "Dsupp: " + rule.getSupport() + " AND Dconf: " + rule.getConfidence() + "\n";
        }
        cadena = "@Number of rules: " + (this.ruleBase.size() + 1) + " Number of Antecedents by rule: " + (double)ant * 1.0 / ((double)this.ruleBase.size() + 1.0) + "\n\n" + cadena;
        return cadena;
    }

    public void saveFile(String filename) {
        String stringOut = new String("");
        stringOut = this.printString();
        Fichero.escribeFichero(filename, stringOut);
    }
}

