/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.EPSILON_SVR;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import keel.Algorithms.SVM.EPSILON_SVR.parseParameters;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.libsvm.svm;
import org.libsvm.svm_model;
import org.libsvm.svm_node;
import org.libsvm.svm_parameter;
import org.libsvm.svm_problem;

public class svmRegression {
    double[] mean = null;
    double[] std_dev = null;
    double tempData = 0.0;
    String[][] X = null;
    String[] mostCommon;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    int nneigh = 1;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");
    String svmType;
    String kernelType;
    double C;
    double eps;
    int degree;
    double gamma;
    double coef0;
    double nu;
    double p;
    int shrinking;
    int probability = 0;
    long seed;
    int nr_weight = 0;

    public svmRegression(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    private void write_results(String output) {
        try {
            FileWriter file_write = new FileWriter(output);
            file_write.write(this.IS.getHeader());
            file_write.write("@data\n");
            for (int i = 0; i < this.ndatos; ++i) {
                file_write.write(this.X[i][0]);
                for (int j = 1; j < 2; ++j) {
                    file_write.write(" " + this.X[i][j]);
                }
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void config_read(String fileParam) {
        parseParameters parameters = new parseParameters();
        parameters.parseConfigurationFile(fileParam);
        this.input_train_name = parameters.getTrainingInputFile();
        this.input_test_name = parameters.getTestInputFile();
        this.output_train_name = parameters.getTrainingOutputFile();
        this.output_test_name = parameters.getTestOutputFile();
        this.seed = Long.parseLong(parameters.getParameter(0));
        this.kernelType = parameters.getParameter(1);
        this.C = Double.parseDouble(parameters.getParameter(2));
        this.eps = Double.parseDouble(parameters.getParameter(3));
        this.degree = Integer.parseInt(parameters.getParameter(4));
        this.gamma = Double.parseDouble(parameters.getParameter(5));
        this.coef0 = Double.parseDouble(parameters.getParameter(6));
        this.nu = Double.parseDouble(parameters.getParameter(7));
        this.p = Double.parseDouble(parameters.getParameter(8));
        this.shrinking = Integer.parseInt(parameters.getParameter(9));
    }

    public void process() {
        svm_node[] SVMn;
        int n;
        int i;
        boolean out;
        boolean in;
        int[] N = new int[this.nneigh];
        double[] Ndist = new double[this.nneigh];
        svm_problem SVMp = null;
        svm_parameter SVMparam = new svm_parameter();
        svm_model svr = null;
        Object outputsCandidate = null;
        boolean same = true;
        Vector instancesSelected = new Vector();
        Vector instancesSelected2 = new Vector();
        SVMparam.C = this.C;
        SVMparam.cache_size = 10.0;
        SVMparam.degree = this.degree;
        SVMparam.eps = this.eps;
        SVMparam.gamma = this.gamma;
        SVMparam.nr_weight = 0;
        SVMparam.nu = this.nu;
        SVMparam.p = this.p;
        SVMparam.shrinking = this.shrinking;
        SVMparam.probability = 0;
        if (this.kernelType.compareTo("LINEAR") == 0) {
            SVMparam.kernel_type = 0;
        } else if (this.kernelType.compareTo("POLY") == 0) {
            SVMparam.kernel_type = 1;
        } else if (this.kernelType.compareTo("RBF") == 0) {
            SVMparam.kernel_type = 2;
        } else if (this.kernelType.compareTo("SIGMOID") == 0) {
            SVMparam.kernel_type = 3;
        }
        SVMparam.svm_type = 3;
        try {
            this.IS.readSet(this.input_train_name, true);
            in = false;
            out = false;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][2];
            this.mostCommon = new String[this.nvariables];
            SVMp = new svm_problem();
            SVMp.l = this.ndatos;
            SVMp.y = new double[SVMp.l];
            SVMp.x = new svm_node[SVMp.l][this.nentradas + 1];
            for (int l = 0; l < SVMp.l; ++l) {
                for (int n2 = 0; n2 < Attributes.getInputNumAttributes() + 1; ++n2) {
                    SVMp.x[l][n2] = new svm_node();
                }
            }
            for (i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                SVMp.y[i] = inst.getAllOutputValues()[0];
                for (n = 0; n < Attributes.getInputNumAttributes(); ++n) {
                    SVMp.x[i][n].index = n;
                    SVMp.x[i][n].value = inst.getAllInputValues()[n];
                    SVMp.y[i] = inst.getAllOutputValues()[0];
                }
                SVMp.x[i][this.nentradas].index = -1;
            }
            if (svm.svm_check_parameter(SVMp, SVMparam) != null) {
                System.out.println("SVM parameter error in training:");
                System.out.println(svm.svm_check_parameter(SVMp, SVMparam));
                System.exit(-1);
            }
            if (this.ndatos > 0) {
                svr = svm.svm_train(SVMp, SVMparam);
            }
            for (i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                this.X[i][0] = new String(String.valueOf(inst.getAllOutputValues()[0]));
                SVMn = new svm_node[Attributes.getInputNumAttributes() + 1];
                for (n = 0; n < Attributes.getInputNumAttributes(); ++n) {
                    SVMn[n] = new svm_node();
                    SVMn[n].index = n;
                    SVMn[n].value = inst.getAllInputValues()[n];
                }
                SVMn[this.nentradas] = new svm_node();
                SVMn[this.nentradas].index = -1;
                this.X[i][1] = new String(String.valueOf(svm.svm_predict(svr, SVMn)));
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        this.write_results(this.output_train_name);
        try {
            this.IS.readSet(this.input_test_name, false);
            in = false;
            out = false;
            this.ndatos = this.IS.getNumInstances();
            this.nvariables = Attributes.getNumAttributes();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nsalidas = Attributes.getOutputNumAttributes();
            this.X = new String[this.ndatos][2];
            this.mostCommon = new String[this.nvariables];
            for (i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                this.X[i][0] = new String(String.valueOf(inst.getAllOutputValues()[0]));
                SVMn = new svm_node[Attributes.getInputNumAttributes() + 1];
                for (n = 0; n < Attributes.getInputNumAttributes(); ++n) {
                    SVMn[n] = new svm_node();
                    SVMn[n].index = n;
                    SVMn[n].value = inst.getAllInputValues()[n];
                }
                SVMn[this.nentradas] = new svm_node();
                SVMn[this.nentradas].index = -1;
                this.X[i][1] = new String(String.valueOf(svm.svm_predict(svr, SVMn)));
            }
        }
        catch (Exception e) {
            System.out.println("Dataset exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        System.out.println("escribiendo test");
        this.write_results(this.output_test_name);
    }
}

