/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Selection.BSE;

import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import org.core.Fichero;

public class BSE
extends Metodo {
    private int k;

    public BSE(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        int j;
        int l;
        int[] clasesS;
        boolean[][] conjM;
        int[][] conjN;
        double[][] conjR;
        double[][] conjS;
        int claseObt;
        int i;
        int nSel = 0;
        int bestEval = 0;
        boolean parar = false;
        long tiempo = System.currentTimeMillis();
        boolean[] marcas = new boolean[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
        }
        nSel = this.datosTrain.length;
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        for (i = 0; i < this.datosTrain.length; ++i) {
            claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu);
            if (claseObt != this.clasesTrain[i]) continue;
            ++bestEval;
        }
        while (!parar) {
            int peor = -1;
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (!marcas[i]) continue;
                marcas[i] = false;
                int eval = 0;
                conjS = new double[--nSel][this.datosTrain[0].length];
                conjR = new double[nSel][this.datosTrain[0].length];
                conjN = new int[nSel][this.datosTrain[0].length];
                conjM = new boolean[nSel][this.datosTrain[0].length];
                clasesS = new int[nSel];
                l = 0;
                for (j = 0; j < this.datosTrain.length; ++j) {
                    if (!marcas[j]) continue;
                    for (int m = 0; m < this.datosTrain[0].length; ++m) {
                        conjS[l][m] = this.datosTrain[j][m];
                        conjR[l][m] = this.realTrain[j][m];
                        conjN[l][m] = this.nominalTrain[j][m];
                        conjM[l][m] = this.nulosTrain[j][m];
                    }
                    clasesS[l] = this.clasesTrain[j];
                    ++l;
                }
                for (j = 0; j < this.datosTrain.length; ++j) {
                    claseObt = KNN.evaluacionKNN2(this.k, conjS, conjR, conjN, conjM, clasesS, this.datosTrain[j], this.realTrain[j], this.nominalTrain[j], this.nulosTrain[j], nClases, this.distanceEu);
                    if (claseObt != this.clasesTrain[j]) continue;
                    ++eval;
                }
                if (eval >= bestEval) {
                    peor = i;
                    bestEval = eval;
                }
                marcas[i] = true;
                ++nSel;
            }
            if (peor >= 0) {
                marcas[peor] = false;
                --nSel;
                continue;
            }
            parar = true;
        }
        conjS = new double[nSel][this.datosTrain[0].length];
        conjR = new double[nSel][this.datosTrain[0].length];
        conjN = new int[nSel][this.datosTrain[0].length];
        conjM = new boolean[nSel][this.datosTrain[0].length];
        clasesS = new int[nSel];
        l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("BSE " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        int[][] trainRealClass = new int[this.datosTrain.length][1];
        int[][] trainPrediction = new int[this.datosTrain.length][1];
        for (i = 0; i < this.datosTrain.length; ++i) {
            trainRealClass[i][0] = this.clasesTrain[i];
            trainPrediction[i][0] = KNN.evaluate(this.datosTrain[i], conjS, nClases, clasesS, this.k);
        }
        KNN.writeOutput(this.ficheroSalida[0], trainRealClass, trainPrediction, this.entradas, this.salida, this.relation);
        int[][] realClass = new int[this.datosTest.length][1];
        int[][] prediction = new int[this.datosTest.length][1];
        for (i = 0; i < realClass.length; ++i) {
            realClass[i][0] = this.clasesTest[i];
            prediction[i][0] = KNN.evaluate(this.datosTest[i], conjS, nClases, clasesS, this.k);
        }
        KNN.writeOutput(this.ficheroSalida[1], realClass, prediction, this.entradas, this.salida, this.relation);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroValidation = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

