/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD;

import java.util.ArrayList;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.DataBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Item;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.Itemset;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.RuleBase;
import keel.Algorithms.Associative_Classification.ClassifierFuzzyFARCHD.myDataset;

public class Apriori {
    ArrayList<Itemset> L2;
    double minsup;
    double minconf;
    double[] minSupps;
    int nClasses;
    int nVariables;
    int depth;
    long ruleStage1;
    RuleBase ruleBase;
    RuleBase ruleBaseClase;
    myDataset train;
    DataBase dataBase;

    public Apriori() {
    }

    public Apriori(RuleBase ruleBase, DataBase dataBase, myDataset train, double minsup, double minconf, int depth) {
        this.train = train;
        this.dataBase = dataBase;
        this.ruleBase = ruleBase;
        this.minconf = minconf;
        this.depth = depth;
        this.nClasses = this.train.getnClasses();
        this.nVariables = this.train.getnInputs();
        this.L2 = new ArrayList();
        this.minSupps = new double[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            this.minSupps[i] = this.train.frecuentClass(i) * minsup;
        }
    }

    public void generateRB() {
        this.ruleStage1 = 0L;
        this.ruleBaseClase = new RuleBase(this.dataBase, this.train, this.ruleBase.getK(), this.ruleBase.getTypeInference());
        for (int i = 0; i < this.nClasses; ++i) {
            this.minsup = this.minSupps[i];
            this.generateL2(i);
            this.generateLarge(this.L2, i);
            this.ruleBaseClase.reduceRules(i);
            this.ruleBase.add(this.ruleBaseClase);
            this.ruleBaseClase.clear();
            System.gc();
        }
    }

    private void generateL2(int clas) {
        this.L2.clear();
        Itemset itemset = new Itemset(clas);
        for (int i = 0; i < this.nVariables; ++i) {
            if (this.dataBase.numLabels(i) <= 1) continue;
            for (int j = 0; j < this.dataBase.numLabels(i); ++j) {
                Item item = new Item(i, j);
                itemset.add(item);
                itemset.calculateSupports(this.dataBase, this.train);
                if (itemset.getSupportClass() >= this.minsup) {
                    this.L2.add(itemset.clone());
                }
                itemset.remove(0);
            }
        }
        this.generateRules(this.L2, clas);
    }

    public int hasUncoverClass(int clas) {
        int uncover = 0;
        for (int j = 0; j < this.train.size(); ++j) {
            if (this.train.getOutputAsInteger(j) != clas) continue;
            boolean stop = false;
            for (int i = 0; i < this.L2.size() && !stop; ++i) {
                Itemset itemset = this.L2.get(i);
                double degree = itemset.degree(this.dataBase, this.train.getExample(j));
                if (!(degree > 0.0)) continue;
                stop = true;
            }
            if (stop) continue;
            ++uncover;
        }
        return uncover;
    }

    private void generateLarge(ArrayList<Itemset> Lk, int clas) {
        int size = Lk.size();
        if (size > 1 && Lk.get(0).size() < this.nVariables && Lk.get(0).size() < this.depth) {
            ArrayList<Itemset> Lnew = new ArrayList<Itemset>();
            for (int i = 0; i < size - 1; ++i) {
                Itemset itemseti = Lk.get(i);
                for (int j = i + 1; j < size; ++j) {
                    Itemset itemsetj = Lk.get(j);
                    if (!this.isCombinable(itemseti, itemsetj)) continue;
                    Itemset newItemset = itemseti.clone();
                    newItemset.add(itemsetj.get(itemsetj.size() - 1).clone());
                    newItemset.calculateSupports(this.dataBase, this.train);
                    if (!(newItemset.getSupportClass() >= this.minsup)) continue;
                    Lnew.add(newItemset);
                }
                this.generateRules(Lnew, clas);
                this.generateLarge(Lnew, clas);
                Lnew.clear();
                System.gc();
            }
        }
    }

    private boolean isCombinable(Itemset itemseti, Itemset itemsetj) {
        Item itemi = itemseti.get(itemseti.size() - 1);
        Item itemj = itemsetj.get(itemseti.size() - 1);
        return itemi.getVariable() < itemj.getVariable();
    }

    public long getRulesStage1() {
        return this.ruleStage1;
    }

    private void generateRules(ArrayList<Itemset> Lk, int clas) {
        for (int i = Lk.size() - 1; i >= 0; --i) {
            Itemset itemset = Lk.get(i);
            double confidence = itemset.getSupport() > 0.0 ? itemset.getSupportClass() / itemset.getSupport() : 0.0;
            if (confidence > 0.4) {
                this.ruleBaseClase.add(itemset);
                ++this.ruleStage1;
            }
            if (!(confidence > this.minconf)) continue;
            Lk.remove(i);
        }
        if (this.ruleBaseClase.size() > 500000) {
            this.ruleBaseClase.reduceRules(clas);
            System.gc();
        }
    }
}

