/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import keel.Algorithms.Decision_Trees.M5.Information;
import keel.Algorithms.Decision_Trees.M5.Interval;
import keel.Algorithms.Decision_Trees.M5.M5;
import keel.Algorithms.Decision_Trees.M5.M5Instance;
import keel.Algorithms.Decision_Trees.M5.M5Instances;
import keel.Algorithms.Decision_Trees.M5.M5Kernel;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;

public class EvaluateModel {
    private int m_NumClasses;
    private int m_NumFolds;
    private double m_Incorrect;
    private double m_Correct;
    private double m_Unclassified;
    private double m_MissingClass;
    private double m_WithClass;
    private double[][] m_ConfusionMatrix;
    private String[] m_ClassNames;
    private boolean m_ClassIsNominal;
    private double[] m_ClassPriors;
    private double m_ClassPriorsSum;
    private double m_TotalCost;
    private double m_SumErr;
    private double m_SumAbsErr;
    private double m_SumSqrErr;
    private double m_SumClass;
    private double m_SumSqrClass;
    private double m_SumPredicted;
    private double m_SumSqrPredicted;
    private double m_SumClassPredicted;
    private double m_SumPriorAbsErr;
    private double m_SumPriorSqrErr;
    private double m_SumKBInfo;
    private static int k_MarginResolution = 500;
    private double[] m_MarginCounts;
    private int m_NumTrainClassVals;
    private double[] m_TrainClassVals;
    private double[] m_TrainClassWeights;
    private M5Kernel m_PriorErrorEstimator;
    private M5Kernel m_ErrorEstimator;
    private static final double MIN_SF_PROB = Double.MIN_VALUE;
    private double m_SumPriorEntropy;
    private double m_SumSchemeEntropy;

    public EvaluateModel(M5Instances data) throws Exception {
        this.m_NumClasses = data.numClasses();
        this.m_NumFolds = 1;
        this.m_ClassIsNominal = data.classAttribute().isNominal();
        if (this.m_ClassIsNominal) {
            this.m_ConfusionMatrix = new double[this.m_NumClasses][this.m_NumClasses];
            this.m_ClassNames = new String[this.m_NumClasses];
            for (int i = 0; i < this.m_NumClasses; ++i) {
                this.m_ClassNames[i] = data.classAttribute().value(i);
            }
        }
        this.m_ClassPriors = new double[this.m_NumClasses];
        this.setPriors(data);
        this.m_MarginCounts = new double[k_MarginResolution + 1];
    }

    public double[][] confusionMatrix() {
        double[][] newMatrix = new double[this.m_ConfusionMatrix.length][0];
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            newMatrix[i] = new double[this.m_ConfusionMatrix[i].length];
            System.arraycopy(this.m_ConfusionMatrix[i], 0, newMatrix[i], 0, this.m_ConfusionMatrix[i].length);
        }
        return newMatrix;
    }

    public void crossValidateModel(M5 classifier, M5Instances data, int numFolds) throws Exception {
        if ((data = new M5Instances(data)).classAttribute().isNominal()) {
            data.stratify(numFolds);
        }
        for (int i = 0; i < numFolds; ++i) {
            M5Instances train = data.trainCV(numFolds, i);
            this.setPriors(train);
            classifier.buildClassifier(train);
            M5Instances test = data.testCV(numFolds, i);
            this.evaluateModel(classifier, test);
        }
        this.m_NumFolds = numFolds;
    }

    public void crossValidateModel(String classifierString, M5Instances data, int numFolds, String[] options) throws Exception {
        this.crossValidateModel(M5.forName(classifierString, options), data, numFolds);
    }

    public static String evaluateModel(String classifierString, String[] options) throws Exception {
        M5 classifier;
        try {
            classifier = (M5)Class.forName(classifierString).newInstance();
        }
        catch (Exception e) {
            throw new Exception("Can't find class with name " + classifierString + '.');
        }
        return EvaluateModel.evaluateModel(classifier, options);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("The first argument must be the class name of a classifier");
            }
            String classifier = args[0];
            args[0] = "";
            System.out.println(EvaluateModel.evaluateModel(classifier, args));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static String evaluateModel(M5 classifier, String[] options) throws Exception {
        PrintWriter pw;
        StringBuffer a;
        String testFileName;
        String objectOutputFileName;
        String objectInputFileName;
        String trainFileName;
        M5Instances train = null;
        M5Instances test = null;
        M5Instances template = null;
        int seed = 1;
        int folds = 10;
        int classIndex = -1;
        boolean IRstatistics = false;
        boolean noOutput = false;
        boolean printClassifications = false;
        boolean trainStatistics = true;
        boolean printMargins = false;
        boolean printComplexityStatistics = false;
        boolean printGraph = false;
        boolean classStatistics = false;
        boolean printSource = false;
        StringBuffer text = new StringBuffer();
        BufferedReader trainReader = null;
        BufferedReader testReader = null;
        ObjectInputStream objectInputStream = null;
        StringBuffer schemeOptionsText = null;
        Interval attributesToOutput = null;
        long trainTimeStart = 0L;
        long trainTimeElapsed = 0L;
        long testTimeStart = 0L;
        long testTimeElapsed = 0L;
        try {
            String attributeRangeString;
            String foldsString;
            String name;
            String classIndexString = M5StaticUtils.getOption('c', options);
            if (classIndexString.length() != 0) {
                classIndex = Integer.parseInt(classIndexString);
            }
            trainFileName = M5StaticUtils.getOption('t', options);
            objectInputFileName = M5StaticUtils.getOption('l', options);
            objectOutputFileName = M5StaticUtils.getOption('d', options);
            testFileName = M5StaticUtils.getOption('T', options);
            if (trainFileName.length() == 0) {
                if (objectInputFileName.length() == 0) {
                    throw new Exception("No training file and no object input file given.");
                }
                if (testFileName.length() == 0) {
                    throw new Exception("No training file and no test file given.");
                }
            } else if (objectInputFileName.length() != 0) {
                throw new Exception("Classifier not incremental, or no test file provided: can't use both train and model file.");
            }
            try {
                if (trainFileName.length() != 0) {
                    trainReader = new BufferedReader(new FileReader(trainFileName));
                }
                if (testFileName.length() != 0) {
                    testReader = new BufferedReader(new FileReader(testFileName));
                }
                if (objectInputFileName.length() != 0) {
                    InputStream is = new FileInputStream(objectInputFileName);
                    if (objectInputFileName.endsWith(".gz")) {
                        is = new GZIPInputStream(is);
                    }
                    objectInputStream = new ObjectInputStream(is);
                }
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + '.');
            }
            if (testFileName.length() != 0) {
                template = test = new M5Instances(testReader, 1);
                if (classIndex != -1) {
                    test.setClassIndex(classIndex - 1);
                } else {
                    name = test.NameClassIndex();
                    if (!name.equalsIgnoreCase("")) {
                        test.setClass(test.attribute(name));
                    } else {
                        test.setClassIndex(test.numAttributes() - 1);
                    }
                }
                if (classIndex > test.numAttributes()) {
                    throw new Exception("Index of class attribute too large.");
                }
            }
            if (trainFileName.length() != 0) {
                template = train = new M5Instances(trainReader);
                if (classIndex != -1) {
                    train.setClassIndex(classIndex - 1);
                } else {
                    name = train.NameClassIndex();
                    if (!name.equalsIgnoreCase("")) {
                        train.setClass(train.attribute(name));
                    } else {
                        train.setClassIndex(train.numAttributes() - 1);
                    }
                }
                if (classIndex > train.numAttributes()) {
                    throw new Exception("Index of class attribute too large.");
                }
            }
            if (template == null) {
                throw new Exception("No actual dataset provided to use as template");
            }
            String seedString = M5StaticUtils.getOption('s', options);
            if (seedString.length() != 0) {
                seed = Integer.parseInt(seedString);
            }
            if ((foldsString = M5StaticUtils.getOption('x', options)).length() != 0) {
                folds = Integer.parseInt(foldsString);
            }
            classStatistics = M5StaticUtils.getFlag('i', options);
            noOutput = M5StaticUtils.getFlag('o', options);
            trainStatistics = !M5StaticUtils.getFlag('v', options);
            printComplexityStatistics = M5StaticUtils.getFlag('k', options);
            printMargins = M5StaticUtils.getFlag('r', options);
            printGraph = M5StaticUtils.getFlag('g', options);
            String sourceClass = M5StaticUtils.getOption('z', options);
            printSource = sourceClass.length() != 0;
            try {
                attributeRangeString = M5StaticUtils.getOption('p', options);
            }
            catch (Exception e) {
                throw new Exception(e.getMessage() + "\nNOTE: the -p option has changed. " + "It now expects a parameter specifying a range of attributes " + "to list with the predictions. Use '-p 0' for none.");
            }
            if (attributeRangeString.length() != 0) {
                printClassifications = true;
                if (!attributeRangeString.equals("0")) {
                    attributesToOutput = new Interval(attributeRangeString);
                }
            }
            if (objectInputFileName.length() != 0) {
                M5StaticUtils.checkForRemainingOptions(options);
            } else {
                for (int i = 0; i < options.length; ++i) {
                    if (options[i].length() == 0) continue;
                    if (schemeOptionsText == null) {
                        schemeOptionsText = new StringBuffer();
                    }
                    if (options[i].indexOf(32) != -1) {
                        schemeOptionsText.append('\"' + options[i] + "\" ");
                        continue;
                    }
                    schemeOptionsText.append(options[i] + " ");
                }
                classifier.setOptions(options);
            }
            M5StaticUtils.checkForRemainingOptions(options);
        }
        catch (Exception e) {
            throw new Exception("\nException: " + e.getMessage());
        }
        EvaluateModel trainingEvaluation = new EvaluateModel(new M5Instances(template, 0));
        EvaluateModel testingEvaluation = new EvaluateModel(new M5Instances(template, 0));
        if (objectInputFileName.length() != 0) {
            classifier = (M5)objectInputStream.readObject();
            objectInputStream.close();
        }
        if (objectInputFileName.length() == 0) {
            M5Instances tempTrain = new M5Instances(train);
            trainingEvaluation.setPriors(tempTrain);
            testingEvaluation.setPriors(tempTrain);
            trainTimeStart = System.currentTimeMillis();
            classifier.buildClassifier(tempTrain);
            trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        }
        if (objectOutputFileName.length() != 0) {
            OutputStream os = new FileOutputStream(objectOutputFileName);
            if (objectOutputFileName.endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
            objectOutputStream.writeObject(classifier);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        if (printClassifications) {
            return EvaluateModel.printClassifications(classifier, new M5Instances(template, 0), testFileName, classIndex, attributesToOutput);
        }
        try {
            a = new StringBuffer();
            a.append(M5.getHeader(testFileName));
            a.append(EvaluateModel.printClassifications(classifier, new M5Instances(test, 0), testFileName, classIndex, attributesToOutput));
            pw = new PrintWriter(new FileOutputStream(M5.testOutFileName));
            pw.print(a.toString());
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            a = new StringBuffer();
            a.append(M5.getHeader(trainFileName));
            a.append(EvaluateModel.printClassifications(classifier, new M5Instances(train, 0), trainFileName, classIndex, attributesToOutput));
            pw = new PrintWriter(new FileOutputStream(M5.trainOutFileName));
            pw.print(a.toString());
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        text.append(M5.getHeaderNoData(trainFileName));
        if (!noOutput && !printMargins) {
            text.append("\n" + classifier.toString() + "\n");
        }
        if (trainStatistics && trainFileName.length() != 0) {
            testTimeStart = System.currentTimeMillis();
            trainingEvaluation.evaluateModel(classifier, train);
            testTimeElapsed = System.currentTimeMillis() - testTimeStart;
            if (printMargins) {
                return trainingEvaluation.toCumulativeMarginDistributionString();
            }
            text.append(trainingEvaluation.toSummaryString("\n@Error on training data:", printComplexityStatistics));
            if (template.classAttribute().isNominal()) {
                if (classStatistics) {
                    text.append("\n" + trainingEvaluation.toClassDetailsString());
                }
                text.append("\n" + trainingEvaluation.toMatrixString());
            }
        }
        if (testFileName.length() != 0) {
            while (test.readInstance(testReader)) {
                testingEvaluation.evaluateModelOnce(classifier, test.instance(0));
                test.delete(0);
            }
            testReader.close();
            text.append("\n" + testingEvaluation.toSummaryString("@Error on test data:", printComplexityStatistics));
        } else if (trainFileName.length() != 0) {
            Random random = new Random(seed);
            random.setSeed(seed);
            train.randomize(random);
            testingEvaluation.crossValidateModel(classifier, train, folds);
            if (template.classAttribute().isNumeric()) {
                text.append("\n" + testingEvaluation.toSummaryString("@Cross-validation:\n", printComplexityStatistics));
            } else {
                text.append("\n" + testingEvaluation.toSummaryString("@Stratified cross-validation:\n", printComplexityStatistics));
            }
        }
        if (template.classAttribute().isNominal()) {
            if (classStatistics) {
                text.append("\n" + testingEvaluation.toClassDetailsString());
            }
            text.append("\n" + testingEvaluation.toMatrixString());
        }
        text.append("\n@ElapsedTime: " + M5StaticUtils.doubleToString((double)(trainTimeElapsed + testTimeElapsed) / 1000.0, 2) + " seconds");
        return text.toString();
    }

    public void evaluateModel(M5 classifier, M5Instances data) throws Exception {
        for (int i = 0; i < data.numInstances(); ++i) {
            this.evaluateModelOnce(classifier, data.instance(i));
        }
    }

    public double evaluateModelOnce(M5 classifier, M5Instance instance) throws Exception {
        M5Instance classMissing = (M5Instance)instance.copy();
        double pred = 0.0;
        classMissing.setDataset(instance.dataset());
        classMissing.setClassMissing();
        if (this.m_ClassIsNominal) {
            pred = classifier.classifyInstance(classMissing);
            this.updateStatsForClassifier(this.makeDistribution(pred), instance);
        } else {
            pred = classifier.classifyInstance(classMissing);
            this.updateStatsForPredictor(pred, instance);
        }
        return pred;
    }

    public double evaluateModelOnce(double[] dist, M5Instance instance) throws Exception {
        double pred;
        if (this.m_ClassIsNominal) {
            pred = M5StaticUtils.maxIndex(dist);
            this.updateStatsForClassifier(dist, instance);
        } else {
            pred = dist[0];
            this.updateStatsForPredictor(pred, instance);
        }
        return pred;
    }

    public void evaluateModelOnce(double prediction, M5Instance instance) throws Exception {
        if (this.m_ClassIsNominal) {
            this.updateStatsForClassifier(this.makeDistribution(prediction), instance);
        } else {
            this.updateStatsForPredictor(prediction, instance);
        }
    }

    public final double numInstances() {
        return this.m_WithClass;
    }

    public final double incorrect() {
        return this.m_Incorrect;
    }

    public final double pctIncorrect() {
        return 100.0 * this.m_Incorrect / this.m_WithClass;
    }

    public final double totalCost() {
        return this.m_TotalCost;
    }

    public final double avgCost() {
        return this.m_TotalCost / this.m_WithClass;
    }

    public final double correct() {
        return this.m_Correct;
    }

    public final double pctCorrect() {
        return 100.0 * this.m_Correct / this.m_WithClass;
    }

    public final double unclassified() {
        return this.m_Unclassified;
    }

    public final double pctUnclassified() {
        return 100.0 * this.m_Unclassified / this.m_WithClass;
    }

    public final double errorRate() {
        if (!this.m_ClassIsNominal) {
            return Math.sqrt(this.m_SumSqrErr / this.m_WithClass);
        }
        return this.m_Incorrect / this.m_WithClass;
    }

    public final double kappa() {
        double[] sumRows = new double[this.m_ConfusionMatrix.length];
        double[] sumColumns = new double[this.m_ConfusionMatrix.length];
        double sumOfWeights = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            for (int j = 0; j < this.m_ConfusionMatrix.length; ++j) {
                int n = i;
                sumRows[n] = sumRows[n] + this.m_ConfusionMatrix[i][j];
                int n2 = j;
                sumColumns[n2] = sumColumns[n2] + this.m_ConfusionMatrix[i][j];
                sumOfWeights += this.m_ConfusionMatrix[i][j];
            }
        }
        double correct = 0.0;
        double chanceAgreement = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            chanceAgreement += sumRows[i] * sumColumns[i];
            correct += this.m_ConfusionMatrix[i][i];
        }
        chanceAgreement /= sumOfWeights * sumOfWeights;
        correct /= sumOfWeights;
        if (chanceAgreement < 1.0) {
            return (correct - chanceAgreement) / (1.0 - chanceAgreement);
        }
        return 1.0;
    }

    public final double correlationCoefficient() throws Exception {
        if (this.m_ClassIsNominal) {
            throw new Exception("Can't compute correlation coefficient: class is nominal!");
        }
        double correlation = 0.0;
        double varActual = this.m_SumSqrClass - this.m_SumClass * this.m_SumClass / this.m_WithClass;
        double varPredicted = this.m_SumSqrPredicted - this.m_SumPredicted * this.m_SumPredicted / this.m_WithClass;
        double varProd = this.m_SumClassPredicted - this.m_SumClass * this.m_SumPredicted / this.m_WithClass;
        correlation = M5StaticUtils.smOrEq(varActual * varPredicted, 0.0) ? 0.0 : varProd / Math.sqrt(varActual * varPredicted);
        return correlation;
    }

    public final double meanAbsoluteError() {
        return this.m_SumAbsErr / this.m_WithClass;
    }

    public final double meanPriorAbsoluteError() {
        return this.m_SumPriorAbsErr / this.m_WithClass;
    }

    public final double relativeAbsoluteError() throws Exception {
        return 100.0 * this.meanAbsoluteError() / this.meanPriorAbsoluteError();
    }

    public final double rootMeanSquaredError() {
        return Math.sqrt(this.m_SumSqrErr / this.m_WithClass);
    }

    public final double rootMeanPriorSquaredError() {
        return Math.sqrt(this.m_SumPriorSqrErr / this.m_WithClass);
    }

    public final double rootRelativeSquaredError() {
        return 100.0 * this.rootMeanSquaredError() / this.rootMeanPriorSquaredError();
    }

    public final double priorEntropy() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute entropy of class prior: class numeric!");
        }
        double entropy = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            entropy -= this.m_ClassPriors[i] / this.m_ClassPriorsSum * M5StaticUtils.log2(this.m_ClassPriors[i] / this.m_ClassPriorsSum);
        }
        return entropy;
    }

    public final double KBInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        return this.m_SumKBInfo;
    }

    public final double KBMeanInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        return this.m_SumKBInfo / this.m_WithClass;
    }

    public final double KBRelativeInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        return 100.0 * this.KBInformation() / this.priorEntropy();
    }

    public final double SFPriorEntropy() {
        return this.m_SumPriorEntropy;
    }

    public final double SFMeanPriorEntropy() {
        return this.m_SumPriorEntropy / this.m_WithClass;
    }

    public final double SFSchemeEntropy() {
        return this.m_SumSchemeEntropy;
    }

    public final double SFMeanSchemeEntropy() {
        return this.m_SumSchemeEntropy / this.m_WithClass;
    }

    public final double SFEntropyGain() {
        return this.m_SumPriorEntropy - this.m_SumSchemeEntropy;
    }

    public final double SFMeanEntropyGain() {
        return (this.m_SumPriorEntropy - this.m_SumSchemeEntropy) / this.m_WithClass;
    }

    public String toCumulativeMarginDistributionString() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Class must be nominal for margin distributions");
        }
        String result = "";
        double cumulativeCount = 0.0;
        for (int i = 0; i <= k_MarginResolution; ++i) {
            if (this.m_MarginCounts[i] != 0.0) {
                double margin = (double)i * 2.0 / (double)k_MarginResolution - 1.0;
                result = result + M5StaticUtils.doubleToString(margin, 7, 3) + ' ' + M5StaticUtils.doubleToString((cumulativeCount += this.m_MarginCounts[i]) * 100.0 / this.m_WithClass, 7, 3) + '\n';
                continue;
            }
            if (i != 0) continue;
            result = M5StaticUtils.doubleToString(-1.0, 7, 3) + ' ' + M5StaticUtils.doubleToString(0.0, 7, 3) + '\n';
        }
        return result;
    }

    public String toSummaryString() {
        return this.toSummaryString("", false);
    }

    public String toSummaryString(boolean printComplexityStatistics) {
        return this.toSummaryString("=== Summary ===\n", printComplexityStatistics);
    }

    public String toSummaryString(String title, boolean printComplexityStatistics) {
        double mad = 0.0;
        StringBuffer text = new StringBuffer();
        text.append(title + "\n");
        try {
            if (this.m_WithClass > 0.0) {
                if (this.m_ClassIsNominal) {
                    text.append("@Correctly Classified Instances     ");
                    text.append(M5StaticUtils.doubleToString(this.correct(), 12, 4) + "     " + M5StaticUtils.doubleToString(this.pctCorrect(), 12, 4) + " %\n");
                    text.append("@Incorrectly Classified Instances   ");
                    text.append(M5StaticUtils.doubleToString(this.incorrect(), 12, 4) + "     " + M5StaticUtils.doubleToString(this.pctIncorrect(), 12, 4) + " %\n");
                    text.append("@Kappa statistic                    ");
                    text.append(M5StaticUtils.doubleToString(this.kappa(), 12, 4) + "\n");
                    if (printComplexityStatistics) {
                        text.append("@K&B Relative Info Score            ");
                        text.append(M5StaticUtils.doubleToString(this.KBRelativeInformation(), 12, 4) + " %\n");
                        text.append("@K&B Information Score              ");
                        text.append(M5StaticUtils.doubleToString(this.KBInformation(), 12, 4) + " bits");
                        text.append(M5StaticUtils.doubleToString(this.KBMeanInformation(), 12, 4) + " bits/instance\n");
                    }
                } else {
                    text.append("@Correlation coefficient            ");
                    text.append(M5StaticUtils.doubleToString(this.correlationCoefficient(), 12, 4) + "\n");
                }
                if (printComplexityStatistics) {
                    text.append("@Class complexity | order 0         ");
                    text.append(M5StaticUtils.doubleToString(this.SFPriorEntropy(), 12, 4) + " bits");
                    text.append(M5StaticUtils.doubleToString(this.SFMeanPriorEntropy(), 12, 4) + " bits/instance\n");
                    text.append("@Class complexity | scheme          ");
                    text.append(M5StaticUtils.doubleToString(this.SFSchemeEntropy(), 12, 4) + " bits");
                    text.append(M5StaticUtils.doubleToString(this.SFMeanSchemeEntropy(), 12, 4) + " bits/instance\n");
                    text.append("@Complexity improvement     (Sf)    ");
                    text.append(M5StaticUtils.doubleToString(this.SFEntropyGain(), 12, 4) + " bits");
                    text.append(M5StaticUtils.doubleToString(this.SFMeanEntropyGain(), 12, 4) + " bits/instance\n");
                }
                text.append("@Mean absolute error                ");
                text.append(M5StaticUtils.doubleToString(this.meanAbsoluteError(), 12, 4) + "\n");
                text.append("@Root mean squared error            ");
                text.append(M5StaticUtils.doubleToString(this.rootMeanSquaredError(), 12, 4) + "\n");
                text.append("@Relative absolute error            ");
                text.append(M5StaticUtils.doubleToString(this.relativeAbsoluteError(), 12, 4) + " %\n");
                text.append("@Root relative squared error        ");
                text.append(M5StaticUtils.doubleToString(this.rootRelativeSquaredError(), 12, 4) + " %\n");
            }
            if (M5StaticUtils.gr(this.unclassified(), 0.0)) {
                text.append("@UnClassified Instances             ");
                text.append(M5StaticUtils.doubleToString(this.unclassified(), 12, 4) + "     " + M5StaticUtils.doubleToString(this.pctUnclassified(), 12, 4) + " %\n");
            }
            if (this.m_MissingClass > 0.0) {
                text.append("@Ignored Class Unknown Instances            ");
                text.append(M5StaticUtils.doubleToString(this.m_MissingClass, 12, 4) + "\n");
            }
        }
        catch (Exception ex) {
            System.err.println("Arggh - Must be a bug in EvaluateModel class");
        }
        return text.toString();
    }

    public String toMatrixString() throws Exception {
        return this.toMatrixString("=== Confusion Matrix ===\n");
    }

    public String toMatrixString(String title) throws Exception {
        int j;
        int i;
        StringBuffer text = new StringBuffer();
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        if (!this.m_ClassIsNominal) {
            throw new Exception("EvaluateModel: No confusion matrix possible!");
        }
        double maxval = 0.0;
        for (i = 0; i < this.m_NumClasses; ++i) {
            for (j = 0; j < this.m_NumClasses; ++j) {
                double current = this.m_ConfusionMatrix[i][j];
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (fractional || !(Math.log(fract) / Math.log(10.0) >= -2.0)) continue;
                fractional = true;
            }
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(this.m_NumClasses) / Math.log(IDChars.length)));
        text.append(title).append("\n");
        for (i = 0; i < this.m_NumClasses; ++i) {
            if (fractional) {
                text.append(" ").append(this.num2ShortID(i, IDChars, IDWidth - 3)).append("   ");
                continue;
            }
            text.append(" ").append(this.num2ShortID(i, IDChars, IDWidth));
        }
        text.append("   <-- classified as\n");
        for (i = 0; i < this.m_NumClasses; ++i) {
            for (j = 0; j < this.m_NumClasses; ++j) {
                text.append(" ").append(M5StaticUtils.doubleToString(this.m_ConfusionMatrix[i][j], IDWidth, fractional ? 2 : 0));
            }
            text.append(" | ").append(this.num2ShortID(i, IDChars, IDWidth)).append(" = ").append(this.m_ClassNames[i]).append("\n");
        }
        return text.toString();
    }

    public String toClassDetailsString() throws Exception {
        return this.toClassDetailsString("=== Detailed Accuracy By Class ===\n");
    }

    public String toClassDetailsString(String title) throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("EvaluateModel: No confusion matrix possible!");
        }
        StringBuffer text = new StringBuffer(title + "\nTP Rate   FP Rate" + "   Precision   Recall" + "  F-Measure   Class\n");
        for (int i = 0; i < this.m_NumClasses; ++i) {
            text.append(M5StaticUtils.doubleToString(this.truePositiveRate(i), 7, 3)).append("   ");
            text.append(M5StaticUtils.doubleToString(this.falsePositiveRate(i), 7, 3)).append("    ");
            text.append(M5StaticUtils.doubleToString(this.precision(i), 7, 3)).append("   ");
            text.append(M5StaticUtils.doubleToString(this.recall(i), 7, 3)).append("   ");
            text.append(M5StaticUtils.doubleToString(this.fMeasure(i), 7, 3)).append("    ");
            text.append(this.m_ClassNames[i]).append('\n');
        }
        return text.toString();
    }

    public double numTruePositives(int classIndex) {
        double correct = 0.0;
        for (int j = 0; j < this.m_NumClasses; ++j) {
            if (j != classIndex) continue;
            correct += this.m_ConfusionMatrix[classIndex][j];
        }
        return correct;
    }

    public double truePositiveRate(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        for (int j = 0; j < this.m_NumClasses; ++j) {
            if (j == classIndex) {
                correct += this.m_ConfusionMatrix[classIndex][j];
            }
            total += this.m_ConfusionMatrix[classIndex][j];
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public double numTrueNegatives(int classIndex) {
        double correct = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == classIndex) continue;
                correct += this.m_ConfusionMatrix[i][j];
            }
        }
        return correct;
    }

    public double trueNegativeRate(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != classIndex) {
                    correct += this.m_ConfusionMatrix[i][j];
                }
                total += this.m_ConfusionMatrix[i][j];
            }
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public double numFalsePositives(int classIndex) {
        double incorrect = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != classIndex) continue;
                incorrect += this.m_ConfusionMatrix[i][j];
            }
        }
        return incorrect;
    }

    public double falsePositiveRate(int classIndex) {
        double incorrect = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == classIndex) {
                    incorrect += this.m_ConfusionMatrix[i][j];
                }
                total += this.m_ConfusionMatrix[i][j];
            }
        }
        if (total == 0.0) {
            return 0.0;
        }
        return incorrect / total;
    }

    public double numFalseNegatives(int classIndex) {
        double incorrect = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == classIndex) continue;
                incorrect += this.m_ConfusionMatrix[i][j];
            }
        }
        return incorrect;
    }

    public double falseNegativeRate(int classIndex) {
        double incorrect = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != classIndex) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != classIndex) {
                    incorrect += this.m_ConfusionMatrix[i][j];
                }
                total += this.m_ConfusionMatrix[i][j];
            }
        }
        if (total == 0.0) {
            return 0.0;
        }
        return incorrect / total;
    }

    public double recall(int classIndex) {
        return this.truePositiveRate(classIndex);
    }

    public double precision(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == classIndex) {
                correct += this.m_ConfusionMatrix[i][classIndex];
            }
            total += this.m_ConfusionMatrix[i][classIndex];
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public double fMeasure(int classIndex) {
        double recall;
        double precision = this.precision(classIndex);
        if (precision + (recall = this.recall(classIndex)) == 0.0) {
            return 0.0;
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    public void setPriors(M5Instances train) throws Exception {
        if (!this.m_ClassIsNominal) {
            this.m_NumTrainClassVals = 0;
            this.m_TrainClassVals = null;
            this.m_TrainClassWeights = null;
            this.m_PriorErrorEstimator = null;
            this.m_ErrorEstimator = null;
            for (int i = 0; i < train.numInstances(); ++i) {
                M5Instance currentInst = train.instance(i);
                if (currentInst.classIsMissing()) continue;
                this.addNumericTrainClass(currentInst.classValue(), currentInst.weight());
            }
        } else {
            int i;
            for (i = 0; i < this.m_NumClasses; ++i) {
                this.m_ClassPriors[i] = 1.0;
            }
            this.m_ClassPriorsSum = this.m_NumClasses;
            for (i = 0; i < train.numInstances(); ++i) {
                if (train.instance(i).classIsMissing()) continue;
                int n = (int)train.instance(i).classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + train.instance(i).weight();
                this.m_ClassPriorsSum += train.instance(i).weight();
            }
        }
    }

    public void updatePriors(M5Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (!this.m_ClassIsNominal) {
                if (!instance.classIsMissing()) {
                    this.addNumericTrainClass(instance.classValue(), instance.weight());
                }
            } else {
                int n = (int)instance.classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        EvaluateModel cmp = (EvaluateModel)obj;
        if (this.m_ClassIsNominal != cmp.m_ClassIsNominal) {
            return false;
        }
        if (this.m_NumClasses != cmp.m_NumClasses) {
            return false;
        }
        if (this.m_Incorrect != cmp.m_Incorrect) {
            return false;
        }
        if (this.m_Correct != cmp.m_Correct) {
            return false;
        }
        if (this.m_Unclassified != cmp.m_Unclassified) {
            return false;
        }
        if (this.m_MissingClass != cmp.m_MissingClass) {
            return false;
        }
        if (this.m_WithClass != cmp.m_WithClass) {
            return false;
        }
        if (this.m_SumErr != cmp.m_SumErr) {
            return false;
        }
        if (this.m_SumAbsErr != cmp.m_SumAbsErr) {
            return false;
        }
        if (this.m_SumSqrErr != cmp.m_SumSqrErr) {
            return false;
        }
        if (this.m_SumClass != cmp.m_SumClass) {
            return false;
        }
        if (this.m_SumSqrClass != cmp.m_SumSqrClass) {
            return false;
        }
        if (this.m_SumPredicted != cmp.m_SumPredicted) {
            return false;
        }
        if (this.m_SumSqrPredicted != cmp.m_SumSqrPredicted) {
            return false;
        }
        if (this.m_SumClassPredicted != cmp.m_SumClassPredicted) {
            return false;
        }
        if (this.m_ClassIsNominal) {
            for (int i = 0; i < this.m_NumClasses; ++i) {
                for (int j = 0; j < this.m_NumClasses; ++j) {
                    if (this.m_ConfusionMatrix[i][j] == cmp.m_ConfusionMatrix[i][j]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static String printClassifications(M5 classifier, M5Instances train, String testFileName, int classIndex, Interval attributesToOutput) throws Exception {
        StringBuffer text = new StringBuffer();
        if (testFileName.length() != 0) {
            BufferedReader testReader = null;
            try {
                testReader = new BufferedReader(new FileReader(testFileName));
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + '.');
            }
            M5Instances test = new M5Instances(testReader, 1);
            if (classIndex != -1) {
                test.setClassIndex(classIndex - 1);
            } else {
                String name = test.NameClassIndex();
                if (!name.equalsIgnoreCase("")) {
                    test.setClass(test.attribute(name));
                } else {
                    test.setClassIndex(test.numAttributes() - 1);
                }
            }
            int i = 0;
            while (test.readInstance(testReader)) {
                M5Instance instance = test.instance(0);
                M5Instance withMissing = (M5Instance)instance.copy();
                withMissing.setDataset(test);
                double predValue = classifier.classifyInstance(withMissing);
                predValue = EvaluateModel.roundNum(predValue);
                if (test.classAttribute().isNumeric()) {
                    if (instance.classIsMissing()) {
                        text.append("missing ");
                    } else {
                        text.append(instance.classValue() + " ");
                    }
                    if (M5Instance.isMissingValue(predValue)) {
                        text.append("missing ");
                    } else {
                        text.append(predValue);
                    }
                    text.append(" " + EvaluateModel.attributeValuesString(withMissing, attributesToOutput) + "\n");
                } else {
                    if (M5Instance.isMissingValue(predValue)) {
                        text.append("missing ");
                    } else {
                        text.append(test.classAttribute().value((int)predValue) + " ");
                    }
                    text.append(EvaluateModel.attributeValuesString(withMissing, attributesToOutput) + " " + instance.toString(instance.classIndex()) + "\n");
                }
                test.delete(0);
                ++i;
            }
            testReader.close();
        }
        return text.toString();
    }

    public static double roundNum(double num) {
        double valor = 0.0;
        valor = num;
        valor *= 10000.0;
        valor = Math.round(valor);
        return valor /= 10000.0;
    }

    private static String attributeValuesString(M5Instance instance, Interval attRange) throws Exception {
        StringBuffer text = new StringBuffer();
        if (attRange != null) {
            boolean firstOutput = true;
            attRange.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!attRange.isInRange(i) || i == instance.classIndex()) continue;
                if (firstOutput) {
                    text.append("(");
                } else {
                    text.append(",");
                }
                text.append(instance.toString(i));
                firstOutput = false;
            }
            if (!firstOutput) {
                text.append(")");
            }
        }
        return text.toString();
    }

    private static String makeOptionString(M5 classifier) {
        StringBuffer optionsText = new StringBuffer("");
        optionsText.append("\n\nGeneral options:\n\n");
        optionsText.append("-t <name of training file>\n");
        optionsText.append("\tSets training file.\n");
        optionsText.append("-T <name of test file>\n");
        optionsText.append("\tSets test file. If missing, a cross-validation");
        optionsText.append(" will be performed on the training data.\n");
        optionsText.append("-c <class index>\n");
        optionsText.append("\tSets index of class attribute (default: last).\n");
        optionsText.append("-x <number of folds>\n");
        optionsText.append("\tSets number of folds for cross-validation (default: 10).\n");
        optionsText.append("-s <random number seed>\n");
        optionsText.append("\tSets random number seed for cross-validation (default: 1).\n");
        optionsText.append("-m <name of file with cost matrix>\n");
        optionsText.append("\tSets file with cost matrix.\n");
        optionsText.append("-l <name of input file>\n");
        optionsText.append("\tSets model input file.\n");
        optionsText.append("-d <name of output file>\n");
        optionsText.append("\tSets model output file.\n");
        optionsText.append("-v\n");
        optionsText.append("\tOutputs no statistics for training data.\n");
        optionsText.append("-o\n");
        optionsText.append("\tOutputs statistics only, not the classifier.\n");
        optionsText.append("-i\n");
        optionsText.append("\tOutputs detailed information-retrieval");
        optionsText.append(" statistics for each class.\n");
        optionsText.append("-k\n");
        optionsText.append("\tOutputs information-theoretic statistics.\n");
        optionsText.append("-p <attribute range>\n");
        optionsText.append("\tOnly outputs predictions for test instances, along with attributes (0 for none).\n");
        optionsText.append("-r\n");
        optionsText.append("\tOnly outputs cumulative margin distribution.\n");
        optionsText.append("\nOptions specific to " + classifier.getClass().getName() + ":\n\n");
        Enumeration enuma = classifier.listOptions();
        while (enuma.hasMoreElements()) {
            Information option = (Information)enuma.nextElement();
            optionsText.append(option.synopsis() + '\n');
            optionsText.append(option.description() + "\n");
        }
        return optionsText.toString();
    }

    private String num2ShortID(int num, char[] IDChars, int IDWidth) {
        int i;
        char[] ID = new char[IDWidth];
        for (i = IDWidth - 1; i >= 0; --i) {
            ID[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
        }
        --i;
        while (i >= 0) {
            ID[i] = 32;
            --i;
        }
        return new String(ID);
    }

    private double[] makeDistribution(double predictedClass) {
        double[] result = new double[this.m_NumClasses];
        if (M5Instance.isMissingValue(predictedClass)) {
            return result;
        }
        if (this.m_ClassIsNominal) {
            result[(int)predictedClass] = 1.0;
        } else {
            result[0] = predictedClass;
        }
        return result;
    }

    private void updateStatsForClassifier(double[] predictedDistribution, M5Instance instance) throws Exception {
        int actualClass = (int)instance.classValue();
        double costFactor = 1.0;
        if (!instance.classIsMissing()) {
            double priorProb;
            this.updateMargins(predictedDistribution, actualClass, instance.weight());
            int predictedClass = -1;
            double bestProb = 0.0;
            for (int i = 0; i < this.m_NumClasses; ++i) {
                if (!(predictedDistribution[i] > bestProb)) continue;
                predictedClass = i;
                bestProb = predictedDistribution[i];
            }
            this.m_WithClass += instance.weight();
            if (predictedClass < 0) {
                this.m_Unclassified += instance.weight();
                return;
            }
            double predictedProb = Math.max(Double.MIN_VALUE, predictedDistribution[actualClass]);
            this.m_SumKBInfo = predictedProb >= (priorProb = Math.max(Double.MIN_VALUE, this.m_ClassPriors[actualClass] / this.m_ClassPriorsSum)) ? (this.m_SumKBInfo += (M5StaticUtils.log2(predictedProb) - M5StaticUtils.log2(priorProb)) * instance.weight()) : (this.m_SumKBInfo -= (M5StaticUtils.log2(1.0 - predictedProb) - M5StaticUtils.log2(1.0 - priorProb)) * instance.weight());
            this.m_SumSchemeEntropy -= M5StaticUtils.log2(predictedProb) * instance.weight();
            this.m_SumPriorEntropy -= M5StaticUtils.log2(priorProb) * instance.weight();
            this.updateNumericScores(predictedDistribution, this.makeDistribution(instance.classValue()), instance.weight());
            double[] dArray = this.m_ConfusionMatrix[actualClass];
            int n = predictedClass;
            dArray[n] = dArray[n] + instance.weight();
            if (predictedClass != actualClass) {
                this.m_Incorrect += instance.weight();
            } else {
                this.m_Correct += instance.weight();
            }
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    private void updateStatsForPredictor(double predictedValue, M5Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.m_WithClass += instance.weight();
            if (M5Instance.isMissingValue(predictedValue)) {
                this.m_Unclassified += instance.weight();
                return;
            }
            this.m_SumClass += instance.weight() * instance.classValue();
            this.m_SumSqrClass += instance.weight() * instance.classValue() * instance.classValue();
            this.m_SumClassPredicted += instance.weight() * instance.classValue() * predictedValue;
            this.m_SumPredicted += predictedValue;
            this.m_SumSqrPredicted += predictedValue * predictedValue;
            if (this.m_ErrorEstimator == null) {
                this.setNumericPriorsFromBuffer();
            }
            double predictedProb = Math.max(this.m_ErrorEstimator.getProbability(predictedValue - instance.classValue()), Double.MIN_VALUE);
            double priorProb = Math.max(this.m_PriorErrorEstimator.getProbability(instance.classValue()), Double.MIN_VALUE);
            this.m_SumSchemeEntropy -= M5StaticUtils.log2(predictedProb) * instance.weight();
            this.m_SumPriorEntropy -= M5StaticUtils.log2(priorProb) * instance.weight();
            this.m_ErrorEstimator.addValue(predictedValue - instance.classValue(), instance.weight());
            this.updateNumericScores(this.makeDistribution(predictedValue), this.makeDistribution(instance.classValue()), instance.weight());
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    private void updateMargins(double[] predictedDistribution, int actualClass, double weight) {
        int bin;
        double probActual = predictedDistribution[actualClass];
        double probNext = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == actualClass || !(predictedDistribution[i] > probNext)) continue;
            probNext = predictedDistribution[i];
        }
        double margin = probActual - probNext;
        int n = bin = (int)((margin + 1.0) / 2.0 * (double)k_MarginResolution);
        this.m_MarginCounts[n] = this.m_MarginCounts[n] + weight;
    }

    private void updateNumericScores(double[] predicted, double[] actual, double weight) {
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumSqrErr = 0.0;
        double sumPriorAbsErr = 0.0;
        double sumPriorSqrErr = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double diff = predicted[i] - actual[i];
            sumErr += diff;
            sumAbsErr += Math.abs(diff);
            sumSqrErr += diff * diff;
            diff = this.m_ClassPriors[i] / this.m_ClassPriorsSum - actual[i];
            sumPriorAbsErr += Math.abs(diff);
            sumPriorSqrErr += diff * diff;
        }
        this.m_SumErr += weight * sumErr / (double)this.m_NumClasses;
        this.m_SumAbsErr += weight * sumAbsErr / (double)this.m_NumClasses;
        this.m_SumSqrErr += weight * sumSqrErr / (double)this.m_NumClasses;
        this.m_SumPriorAbsErr += weight * sumPriorAbsErr / (double)this.m_NumClasses;
        this.m_SumPriorSqrErr += weight * sumPriorSqrErr / (double)this.m_NumClasses;
    }

    private void addNumericTrainClass(double classValue, double weight) {
        if (this.m_TrainClassVals == null) {
            this.m_TrainClassVals = new double[100];
            this.m_TrainClassWeights = new double[100];
        }
        if (this.m_NumTrainClassVals == this.m_TrainClassVals.length) {
            double[] temp = new double[this.m_TrainClassVals.length * 2];
            System.arraycopy(this.m_TrainClassVals, 0, temp, 0, this.m_TrainClassVals.length);
            this.m_TrainClassVals = temp;
            temp = new double[this.m_TrainClassWeights.length * 2];
            System.arraycopy(this.m_TrainClassWeights, 0, temp, 0, this.m_TrainClassWeights.length);
            this.m_TrainClassWeights = temp;
        }
        this.m_TrainClassVals[this.m_NumTrainClassVals] = classValue;
        this.m_TrainClassWeights[this.m_NumTrainClassVals] = weight;
        ++this.m_NumTrainClassVals;
    }

    private void setNumericPriorsFromBuffer() {
        double numPrecision = 0.01;
        if (this.m_NumTrainClassVals > 1) {
            double[] temp = new double[this.m_NumTrainClassVals];
            System.arraycopy(this.m_TrainClassVals, 0, temp, 0, this.m_NumTrainClassVals);
            int[] index = M5StaticUtils.sort(temp);
            double lastVal = temp[index[0]];
            double deltaSum = 0.0;
            int distinct = 0;
            for (int i = 1; i < temp.length; ++i) {
                double current = temp[index[i]];
                if (current == lastVal) continue;
                deltaSum += current - lastVal;
                lastVal = current;
                ++distinct;
            }
            if (distinct > 0) {
                numPrecision = deltaSum / (double)distinct;
            }
        }
        this.m_PriorErrorEstimator = new M5Kernel(numPrecision);
        this.m_ErrorEstimator = new M5Kernel(numPrecision);
        this.m_ClassPriorsSum = 1.0E-4;
        this.m_ClassPriors[0] = 1.0E-4;
        for (int i = 0; i < this.m_NumTrainClassVals; ++i) {
            this.m_ClassPriors[0] = this.m_ClassPriors[0] + this.m_TrainClassVals[i] * this.m_TrainClassWeights[i];
            this.m_ClassPriorsSum += this.m_TrainClassWeights[i];
            this.m_PriorErrorEstimator.addValue(this.m_TrainClassVals[i], this.m_TrainClassWeights[i]);
        }
    }
}

