/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet;

import java.util.ArrayList;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class LinkedLayer
implements ILayer<LinkedNeuron> {
    protected static final XmlFormat<LinkedLayer> XML = new XmlFormat<LinkedLayer>(LinkedLayer.class){

        @Override
        public void format(LinkedLayer source, XmlElement xml) {
            xml.setAttribute("initial-max-n-of-neurons", source.initialmaxnofneurons);
            xml.setAttribute("min-n-of-neurons", source.minnofneurons);
            xml.setAttribute("max-n-of-neurons", source.maxnofneurons);
            xml.setAttribute("type", source.type);
            xml.setAttribute("biased", source.biased);
            xml.add(source.neurons, "neurons");
        }

        @Override
        public LinkedLayer parse(XmlElement xml) {
            LinkedLayer result = (LinkedLayer)xml.object();
            result.initialmaxnofneurons = xml.getAttribute("initial-max-n-of-neurons", 1);
            result.minnofneurons = xml.getAttribute("min-n-of-neurons", 1);
            result.maxnofneurons = xml.getAttribute("max-n-of-neurons", 1);
            result.type = xml.getAttribute("type", 1);
            result.biased = xml.getAttribute("biased", false);
            result.neurons = (ArrayList)xml.get("neurons");
            return result;
        }

        @Override
        public String defaultName() {
            return "linked-layer";
        }
    };
    public static final int HIDDEN_LAYER = 1;
    public static final int OUTPUT_LAYER = 2;
    protected int minnofneurons;
    protected int initialmaxnofneurons;
    protected int maxnofneurons;
    protected ArrayList<LinkedNeuron> neurons = new ArrayList();
    protected int type = 0;
    protected boolean biased;

    public int getMinnofneurons() {
        return this.minnofneurons;
    }

    public void setMinnofneurons(int minofneurons) {
        this.minnofneurons = minofneurons;
    }

    public int getInitialmaxnofneurons() {
        return this.initialmaxnofneurons;
    }

    public void setInitialmaxnofneurons(int initialmaxnofneurons) {
        this.initialmaxnofneurons = initialmaxnofneurons;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isBiased() {
        return this.biased;
    }

    public void setBiased(boolean isBiased) {
        this.biased = isBiased;
    }

    @Override
    public int getMaxnofneurons() {
        return this.maxnofneurons;
    }

    public void setMaxnofneurons(int maxnofneurons) {
        this.maxnofneurons = maxnofneurons;
    }

    @Override
    public void addNeuron(LinkedNeuron neuron) {
        if (this.neurons.size() == this.maxnofneurons) {
            return;
        }
        this.neurons.add(neuron);
    }

    public boolean removeNeuron(LinkedNeuron neuron) {
        if (this.neurons.size() == this.minnofneurons) {
            return false;
        }
        return this.neurons.remove(neuron);
    }

    public LinkedNeuron removeNeuron(int index) {
        return this.neurons.remove(index);
    }

    @Override
    public LinkedNeuron getNeuron(int index) {
        return this.neurons.get(index);
    }

    @Override
    public int getNofneurons() {
        return this.neurons.size();
    }

    @Override
    public boolean equals(ILayer<LinkedNeuron> other) {
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(41, 43);
        for (INeuron iNeuron : this.neurons) {
            hcb.append(iNeuron);
        }
        return hcb.toHashCode();
    }

    public boolean neuronsFull() {
        return this.neurons.size() >= this.maxnofneurons;
    }

    public boolean neuronsEmpty() {
        return this.neurons.size() == 0;
    }

    public boolean linksFull(ILayer<? extends INeuron> previous) {
        if (!this.biased) {
            for (LinkedNeuron neuron : this.neurons) {
                if (neuron.getNoflinks() >= previous.getNofneurons()) continue;
                return false;
            }
        } else {
            for (LinkedNeuron neuron : this.neurons) {
                if (neuron.getNoflinks() - 1 >= previous.getNofneurons()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean linksEmpty() {
        for (LinkedNeuron neuron : this.neurons) {
            if ((!neuron.isBiased() || neuron.getNoflinks() <= 1) && (neuron.isBiased() || neuron.getNoflinks() <= 0)) continue;
            return false;
        }
        return true;
    }

    public int getNoflinks() {
        int noflinks = 0;
        for (LinkedNeuron neuron : this.neurons) {
            noflinks += neuron.getNoflinks();
        }
        return noflinks;
    }

    public void keepRelevantLinks(double significativeWeight) {
        for (LinkedNeuron neuron : this.neurons) {
            neuron.keepRelevantLinks(significativeWeight);
        }
    }

    public LinkedLayer copy(ILayer<? extends INeuron> previousLayer) {
        LinkedLayer result = null;
        try {
            result = (LinkedLayer)this.getClass().newInstance();
            result.setMinnofneurons(this.minnofneurons);
            result.setInitialmaxnofneurons(this.initialmaxnofneurons);
            result.setMaxnofneurons(this.maxnofneurons);
            result.setType(this.type);
            result.setBiased(this.biased);
            for (LinkedNeuron neuron : this.neurons) {
                result.addNeuron(neuron.copy(previousLayer));
            }
        }
        catch (InstantiationException e) {
            System.out.println("Instantiation Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("Illegal Access Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return result;
    }

    public abstract LinkedNeuron obtainNewNeuron();
}

