/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.listener;

import java.util.List;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IIndividual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasePopulationReportEntry {
    protected static final XmlFormat<BasePopulationReportEntry> XML = new XmlFormat<BasePopulationReportEntry>(BasePopulationReportEntry.class){

        @Override
        public void format(BasePopulationReportEntry basePopulationReportEntry, XmlElement xml) {
            xml.setAttribute("generation", basePopulationReportEntry.generation);
            xml.add(basePopulationReportEntry.absolutelyBest, "absolutely-best");
            xml.add(basePopulationReportEntry.inhabitants, "inhabitants");
            xml.add(basePopulationReportEntry.bestIndividual, "best-individual");
            xml.add(basePopulationReportEntry.worstIndividual, "worst-individual");
            xml.add(basePopulationReportEntry.medianIndividual, "median-individual");
            xml.add(basePopulationReportEntry.averageFitness, "average-fitness", DOUBLE_XML);
            xml.add(basePopulationReportEntry.fitnessVariance, "fitness-variance", DOUBLE_XML);
        }

        @Override
        public BasePopulationReportEntry parse(XmlElement xml) {
            BasePopulationReportEntry result = (BasePopulationReportEntry)xml.object();
            result.generation = xml.getAttribute("generation", 0);
            result.absolutelyBest = (IIndividual)xml.get("absolutely-best");
            result.inhabitants = (List)xml.get("inhabitants");
            result.bestIndividual = (IIndividual)xml.get("best-individual");
            result.worstIndividual = (IIndividual)xml.get("worst-individual");
            result.medianIndividual = (IIndividual)xml.get("median-individual");
            result.averageFitness = (Double)xml.get("average-fitness", DOUBLE_XML);
            result.fitnessVariance = (Double)xml.get("fitness-variance", DOUBLE_XML);
            return result;
        }

        @Override
        public String defaultName() {
            return "base-population-report-entry";
        }
    };
    int generation;
    IIndividual absolutelyBest;
    List<IIndividual> inhabitants;
    IIndividual bestIndividual;
    IIndividual worstIndividual;
    IIndividual medianIndividual;
    double averageFitness;
    double fitnessVariance;

    public final int getGeneration() {
        return this.generation;
    }

    public final void setGeneration(int generation) {
        this.generation = generation;
    }

    public final IIndividual getAbsolutelyBest() {
        return this.absolutelyBest;
    }

    public final void setAbsolutelyBest(IIndividual absolutelyBest) {
        this.absolutelyBest = absolutelyBest;
    }

    public final IIndividual getBestIndividual() {
        return this.bestIndividual;
    }

    public final void setBestIndividual(IIndividual bestIndividual) {
        this.bestIndividual = bestIndividual;
    }

    public final IIndividual getWorstIndividual() {
        return this.worstIndividual;
    }

    public final void setWorstIndividual(IIndividual worstIndividual) {
        this.worstIndividual = worstIndividual;
    }

    public final double getAverageFitness() {
        return this.averageFitness;
    }

    public final void setAverageFitness(double averageFitness) {
        this.averageFitness = averageFitness;
    }

    public final double getFitnessVariance() {
        return this.fitnessVariance;
    }

    public final void setFitnessVariance(double fitnessVariance) {
        this.fitnessVariance = fitnessVariance;
    }

    public final IIndividual getMedianIndividual() {
        return this.medianIndividual;
    }

    public final void setMedianIndividual(IIndividual medianIndividual) {
        this.medianIndividual = medianIndividual;
    }

    public final List<IIndividual> getInhabitants() {
        return this.inhabitants;
    }

    public final void setInhabitants(List<IIndividual> inhabitants) {
        this.inhabitants = inhabitants;
    }
}

