/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.DataParserConstants;
import keel.Dataset.DataParserTokenManager;
import keel.Dataset.ErrorInfo;
import keel.Dataset.HeaderFormatException;
import keel.Dataset.InstanceSet;
import keel.Dataset.ParseException;
import keel.Dataset.SimpleCharStream;
import keel.Dataset.Token;

public class DataParser
implements DataParserConstants {
    static DataParser dataParser = null;
    static String relationName = null;
    static boolean isTrain = false;
    static Vector inputAttrNames = new Vector();
    static Vector outputAttrNames = new Vector();
    static Vector inputTestAttrNames = new Vector();
    static Vector outputTestAttrNames = new Vector();
    static boolean inputsDef = false;
    static boolean outputsDef = false;
    private static boolean jj_initialized_once = false;
    public static DataParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static Vector jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;

    DataParser() {
    }

    public static void headerParse(String fileName, boolean _isTrain) throws HeaderFormatException {
        try {
            FileInputStream f = null;
            isTrain = _isTrain;
            inputTestAttrNames = new Vector();
            outputTestAttrNames = new Vector();
            inputsDef = false;
            outputsDef = false;
            try {
                f = new FileInputStream(fileName);
            }
            catch (FileNotFoundException e) {
                System.err.println("The data input file '" + fileName + "' doesn't exist.");
                System.exit(0);
            }
            if (dataParser == null) {
                dataParser = new DataParser(f);
            }
            DataParser.ReInit(f);
            dataParser.ppal();
            f.close();
        }
        catch (ParseException e) {
            Token t = DataParser.getToken(1);
            throw new HeaderFormatException("SINTACTICAL ERROR. It has been found the token \"" + t.image + "\" at line " + t.beginLine + " column " + t.beginColumn + ".");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static final void ppal() throws ParseException {
        Object t = null;
        DataParser.readAttributes(0);
        DataParser.readInputs();
        DataParser.readOutputs();
        DataParser.jj_consume_token(12);
        DataParser.processInputsAndOutputs();
    }

    public static final void readRelation() throws ParseException {
        DataParser.jj_consume_token(8);
        DataParser.jj_consume_token(27);
        relationName = DataParser.getToken((int)0).image.trim();
        Attributes.setRelationName(relationName);
        DataParser.identList();
    }

    public static final void identList() throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 27: {
                DataParser.jj_consume_token(27);
                break;
            }
            default: {
                DataParser.jj_la1[0] = jj_gen;
            }
        }
    }

    public static final void readAttributes(int attCount) throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 9: {
                DataParser.jj_consume_token(9);
                DataParser.jj_consume_token(27);
                Attribute at = new Attribute();
                at.setName(DataParser.getToken((int)0).image.trim());
                DataParser.attributeType(at);
                if (isTrain) {
                    Attributes.addAttribute(at);
                } else if (!Attributes.getAttribute(attCount).equals(at)) {
                    Token t = DataParser.getToken(0);
                    ErrorInfo er = new ErrorInfo(8, 0, t.beginLine, attCount, 0, isTrain, "Attribute " + at.getName() + " read in test has not been defined in train DB");
                    InstanceSet.errorLogger.setError(er);
                }
                DataParser.readAttributes(++attCount);
                break;
            }
            default: {
                DataParser.jj_la1[1] = jj_gen;
            }
        }
    }

    public static final void attributeType(Attribute at) throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 13: {
                DataParser.jj_consume_token(13);
                at.setType(1);
                DataParser.integerBoundaries(at);
                break;
            }
            case 14: {
                DataParser.jj_consume_token(14);
                at.setType(2);
                DataParser.realBoundaries(at);
                break;
            }
            case 18: {
                DataParser.jj_consume_token(18);
                at.setType(0);
                DataParser.identNum();
                at.addNominalValue(DataParser.getToken((int)0).image.trim());
                at.setFixedBounds(true);
                DataParser.nominalList(at);
                DataParser.jj_consume_token(19);
                break;
            }
            default: {
                DataParser.jj_la1[2] = jj_gen;
                at.setType(0);
            }
        }
    }

    public static final void integerBoundaries(Attribute at) throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 16: {
                DataParser.jj_consume_token(16);
                DataParser.jj_consume_token(23);
                int min = Integer.parseInt(DataParser.getToken((int)0).image.trim());
                DataParser.jj_consume_token(20);
                DataParser.jj_consume_token(23);
                int max = Integer.parseInt(DataParser.getToken((int)0).image.trim());
                at.setBounds(min, max);
                DataParser.jj_consume_token(17);
                break;
            }
            default: {
                DataParser.jj_la1[3] = jj_gen;
            }
        }
    }

    public static final void realBoundaries(Attribute at) throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 16: {
                DataParser.jj_consume_token(16);
                DataParser.realConst();
                double min = Double.parseDouble(DataParser.getToken((int)0).image.trim());
                DataParser.jj_consume_token(20);
                DataParser.realConst();
                double max = Double.parseDouble(DataParser.getToken((int)0).image.trim());
                at.setBounds(min, max);
                DataParser.jj_consume_token(17);
                break;
            }
            default: {
                DataParser.jj_la1[4] = jj_gen;
            }
        }
    }

    public static final void nominalList(Attribute att) throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 20: {
                DataParser.jj_consume_token(20);
                DataParser.identNum();
                att.addNominalValue(DataParser.getToken((int)0).image.trim());
                DataParser.nominalList(att);
                break;
            }
            default: {
                DataParser.jj_la1[5] = jj_gen;
            }
        }
    }

    public static final void realConst() throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 25: {
                DataParser.jj_consume_token(25);
                DataParser.exponent();
                break;
            }
            case 23: {
                DataParser.jj_consume_token(23);
                break;
            }
            default: {
                DataParser.jj_la1[6] = jj_gen;
                DataParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void exponent() throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 15: {
                DataParser.jj_consume_token(15);
                DataParser.jj_consume_token(23);
                break;
            }
            default: {
                DataParser.jj_la1[7] = jj_gen;
            }
        }
    }

    public static final void identNum() throws ParseException {
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 27: {
                DataParser.jj_consume_token(27);
                break;
            }
            case 23: {
                DataParser.jj_consume_token(23);
                break;
            }
            case 25: {
                DataParser.jj_consume_token(25);
                break;
            }
            default: {
                DataParser.jj_la1[8] = jj_gen;
                DataParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void readInputs() throws ParseException {
        String attName = null;
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 10: {
                DataParser.jj_consume_token(10);
                DataParser.jj_consume_token(27);
                attName = DataParser.getToken((int)0).image.trim();
                inputsDef = true;
                if (isTrain) {
                    if (Attributes.getAttribute(attName) == null) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(9, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @inputs has not been defined previously. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    } else {
                        inputAttrNames.add(attName);
                    }
                } else {
                    if (!inputAttrNames.contains(attName)) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(10, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @inputs in test, it has not been defined in @inputs in its train dataset. It will be ignored");
                        InstanceSet.errorLogger.setError(er);
                    }
                    inputTestAttrNames.add(attName);
                }
                DataParser.inputs_list();
                break;
            }
            default: {
                DataParser.jj_la1[9] = jj_gen;
            }
        }
    }

    public static final void inputs_list() throws ParseException {
        String attName = null;
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 20: {
                DataParser.jj_consume_token(20);
                DataParser.jj_consume_token(27);
                attName = DataParser.getToken((int)0).image.trim();
                if (isTrain) {
                    if (Attributes.getAttribute(attName) == null) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(9, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @inputs has not been defined previously. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    } else {
                        inputAttrNames.add(attName);
                    }
                } else {
                    if (!inputAttrNames.contains(attName)) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(10, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @inputs in test, it has not been defined in @inputs in its train dataset. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    }
                    inputTestAttrNames.add(attName);
                }
                DataParser.inputs_list();
                break;
            }
            default: {
                DataParser.jj_la1[10] = jj_gen;
            }
        }
    }

    public static final void readOutputs() throws ParseException {
        String attName = null;
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 11: {
                DataParser.jj_consume_token(11);
                DataParser.jj_consume_token(27);
                attName = DataParser.getToken((int)0).image.trim();
                outputsDef = true;
                if (isTrain) {
                    if (Attributes.getAttribute(attName) == null) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(11, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @outputs has not been defined previously. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    } else {
                        outputAttrNames.add(attName);
                    }
                } else {
                    if (!outputAttrNames.contains(attName)) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(12, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @outputs in test, it has not been defined in @outputs in its train dataset. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    }
                    outputTestAttrNames.add(attName);
                }
                DataParser.outputs_list();
                break;
            }
            default: {
                DataParser.jj_la1[11] = jj_gen;
            }
        }
    }

    public static final void outputs_list() throws ParseException {
        String attName = null;
        switch (jj_ntk == -1 ? DataParser.jj_ntk() : jj_ntk) {
            case 20: {
                DataParser.jj_consume_token(20);
                DataParser.jj_consume_token(27);
                attName = DataParser.getToken((int)0).image.trim();
                if (isTrain) {
                    if (Attributes.getAttribute(attName) == null) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(11, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @outputs has not been defined previously. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    } else {
                        outputAttrNames.add(attName);
                    }
                } else {
                    if (!outputAttrNames.contains(attName)) {
                        Token t = DataParser.getToken(0);
                        ErrorInfo er = new ErrorInfo(12, 0, t.beginLine, 0, 0, isTrain, "The attribute " + attName + " defined in @outputs in test, it has not been defined in @outputs in its train dataset. It will be ignored.");
                        InstanceSet.errorLogger.setError(er);
                    }
                    outputTestAttrNames.add(attName);
                }
                DataParser.outputs_list();
                break;
            }
            default: {
                DataParser.jj_la1[12] = jj_gen;
            }
        }
    }

    static void processInputsAndOutputs() throws ParseException {
        if (isTrain) {
            if (!inputsDef && !outputsDef) {
                outputAttrNames.add(Attributes.getAttribute(Attributes.getNumAttributes() - 1).getName());
                inputAttrNames = Attributes.getAttributesExcept(outputAttrNames);
            } else if (!inputsDef && outputsDef) {
                inputAttrNames = Attributes.getAttributesExcept(outputAttrNames);
            } else if (inputsDef && !outputsDef) {
                outputAttrNames = Attributes.getAttributesExcept(inputAttrNames);
            }
            Attributes.setOutputInputAttributes(inputAttrNames, outputAttrNames);
        } else {
            ErrorInfo er;
            if (inputsDef && !Attributes.areAllDefinedAsInputs(inputTestAttrNames)) {
                er = new ErrorInfo(13, 0, 0, 0, 0, isTrain, "The @input attributes definition of test run doesn't match with the train definition");
                InstanceSet.errorLogger.setError(er);
            }
            if (outputsDef && !Attributes.areAllDefinedAsOutputs(outputTestAttrNames)) {
                er = new ErrorInfo(14, 0, 0, 0, 0, isTrain, "The @output attributes definition of test run doesn't match with the train definition");
                InstanceSet.errorLogger.setError(er);
            }
        }
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0x8000000, 512, 286720, 65536, 65536, 0x100000, 0x2800000, 32768, 0xA800000, 1024, 0x100000, 2048, 0x100000};
    }

    public DataParser(InputStream stream) {
        this(stream, null);
    }

    public DataParser(InputStream stream, String encoding) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new DataParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            DataParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(InputStream stream) {
        DataParser.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        DataParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            DataParser.jj_la1[i] = -1;
        }
    }

    public DataParser(Reader stream) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new DataParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            DataParser.jj_la1[i] = -1;
        }
    }

    public static void ReInit(Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        DataParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            DataParser.jj_la1[i] = -1;
        }
    }

    public DataParser(DataParserTokenManager tm) {
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  You must");
            System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            DataParser.jj_la1[i] = -1;
        }
    }

    public void ReInit(DataParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 13; ++i) {
            DataParser.jj_la1[i] = -1;
        }
    }

    private static final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? DataParser.token.next : (DataParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (DataParser.token.kind == kind) {
            ++jj_gen;
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw DataParser.generateParseException();
    }

    public static final Token getNextToken() {
        token = DataParser.token.next != null ? DataParser.token.next : (DataParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    private static final int jj_ntk() {
        jj_nt = DataParser.token.next;
        if (jj_nt == null) {
            DataParser.token.next = token_source.getNextToken();
            jj_ntk = DataParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = DataParser.jj_nt.kind;
        return jj_ntk;
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[31];
        for (i = 0; i < 31; ++i) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[DataParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 13; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 31; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            DataParser.jj_expentry[0] = i;
            jj_expentries.addElement(jj_expentry);
        }
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])jj_expentries.elementAt(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    static {
        jj_la1 = new int[13];
        DataParser.jj_la1_0();
        jj_expentries = new Vector();
        jj_kind = -1;
    }
}

