/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Instance_Based_Learning;

import java.util.Arrays;
import keel.Algorithms.Fuzzy_Instance_Based_Learning.Timer;
import org.core.Files;

public class ReportTool {
    private static int[] trOrig;
    private static int[] trPre;
    private static int[] tsOrig;
    private static int[] tsPre;
    private static int testUnclassified;
    private static int trainUnclassified;
    private static int[][] testConfMatrix;
    private static int[][] trainConfMatrix;
    private static int nClasses;
    private static String fileName;

    public static void setResults(int[] trainReal, int[] trainPrediction, int[] testReal, int[] testPrediction, int nClas) {
        int i;
        trOrig = new int[trainReal.length];
        trPre = new int[trainPrediction.length];
        tsOrig = new int[testReal.length];
        tsPre = new int[testPrediction.length];
        for (i = 0; i < trainReal.length; ++i) {
            ReportTool.trOrig[i] = trainReal[i];
        }
        for (i = 0; i < trainPrediction.length; ++i) {
            ReportTool.trPre[i] = trainPrediction[i];
        }
        for (i = 0; i < testReal.length; ++i) {
            ReportTool.tsOrig[i] = testReal[i];
        }
        for (i = 0; i < testPrediction.length; ++i) {
            ReportTool.tsPre[i] = testPrediction[i];
        }
        nClasses = nClas;
    }

    public static void printReport() {
        int j;
        int i;
        String text = "";
        ReportTool.computeConfussionMatrixes();
        text = text + "Accuracy: " + ReportTool.getAccuracy() + "\n";
        text = text + "Accuracy (Training): " + ReportTool.getTrainAccuracy() + "\n";
        text = text + "Kappa: " + ReportTool.getKappa() + "\n";
        text = text + "Kappa (Training): " + ReportTool.getTrainKappa() + "\n";
        text = text + "Unclassified instances: " + testUnclassified + "\n";
        text = text + "Unclassified instances (Training): " + trainUnclassified + "\n";
        text = text + "Model time: " + Timer.getModelTime() + "\n";
        text = text + "Training time: " + Timer.getTrainingTime() + "\n";
        text = text + "Test time: " + Timer.getTestTime() + "\n";
        text = text + "Confussion Matrix:\n";
        for (i = 0; i < nClasses; ++i) {
            for (j = 0; j < nClasses; ++j) {
                text = text + testConfMatrix[i][j] + "\t";
            }
            text = text + "\n";
        }
        text = text + "\n";
        text = text + "Training Confussion Matrix:\n";
        for (i = 0; i < nClasses; ++i) {
            for (j = 0; j < nClasses; ++j) {
                text = text + trainConfMatrix[i][j] + "\t";
            }
            text = text + "\n";
        }
        text = text + "\n";
        Files.writeFile(fileName, text);
    }

    private static void computeConfussionMatrixes() {
        int i;
        testConfMatrix = new int[nClasses][nClasses];
        trainConfMatrix = new int[nClasses][nClasses];
        testUnclassified = 0;
        for (i = 0; i < nClasses; ++i) {
            Arrays.fill(testConfMatrix[i], 0);
        }
        for (i = 0; i < tsPre.length; ++i) {
            if (tsPre[i] == -1) {
                ++testUnclassified;
                continue;
            }
            int[] nArray = testConfMatrix[tsPre[i]];
            int n = tsOrig[i];
            nArray[n] = nArray[n] + 1;
        }
        trainUnclassified = 0;
        for (i = 0; i < nClasses; ++i) {
            Arrays.fill(trainConfMatrix[i], 0);
        }
        for (i = 0; i < trPre.length; ++i) {
            if (trPre[i] == -1) {
                ++trainUnclassified;
                continue;
            }
            int[] nArray = trainConfMatrix[trPre[i]];
            int n = trOrig[i];
            nArray[n] = nArray[n] + 1;
        }
    }

    private static double getAccuracy() {
        int count = 0;
        for (int i = 0; i < nClasses; ++i) {
            count += testConfMatrix[i][i];
        }
        double acc = (double)count / (double)tsOrig.length;
        return acc;
    }

    private static double getTrainAccuracy() {
        int count = 0;
        for (int i = 0; i < nClasses; ++i) {
            count += trainConfMatrix[i][i];
        }
        double acc = (double)count / (double)trOrig.length;
        return acc;
    }

    private static double getKappa() {
        int i;
        int count = 0;
        for (i = 0; i < nClasses; ++i) {
            count += testConfMatrix[i][i];
        }
        double agreement = (double)count / (double)tsOrig.length;
        double expected = 0.0;
        for (i = 0; i < nClasses; ++i) {
            count = 0;
            int count2 = 0;
            for (int j = 0; j < nClasses; ++j) {
                count += testConfMatrix[i][j];
                count2 += testConfMatrix[j][i];
            }
            double prob1 = (double)count / (double)tsOrig.length;
            double prob2 = (double)count2 / (double)tsOrig.length;
            expected += prob1 * prob2;
        }
        double kappa = (agreement - expected) / (1.0 - expected);
        return kappa;
    }

    private static double getTrainKappa() {
        int i;
        int count = 0;
        for (i = 0; i < nClasses; ++i) {
            count += trainConfMatrix[i][i];
        }
        double agreement = (double)count / (double)trOrig.length;
        double expected = 0.0;
        for (i = 0; i < nClasses; ++i) {
            count = 0;
            int count2 = 0;
            for (int j = 0; j < nClasses; ++j) {
                count += trainConfMatrix[i][j];
                count2 += trainConfMatrix[j][i];
            }
            double prob1 = (double)count / (double)trOrig.length;
            double prob2 = (double)count2 / (double)trOrig.length;
            expected += prob1 * prob2;
        }
        double kappa = (agreement - expected) / (1.0 - expected);
        return kappa;
    }

    public static void setOutputFile(String name) {
        fileName = name;
    }

    public static void addToReport(String contents) {
        Files.addToFile(fileName, contents);
    }
}

