/*
 * Decompiled with CFR 0.152.
 */
package javolution.realtime;

import javax.realtime.MemoryArea;
import javolution.Configuration;
import javolution.JavolutionError;
import javolution.lang.ClassInitializer;
import javolution.realtime.Context;
import javolution.realtime.ObjectPool;
import javolution.realtime.PoolContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory<T> {
    static final int MAX = Configuration.factories();
    static ObjectFactory[] INSTANCES = new ObjectFactory[MAX];
    static volatile int Count;
    final int _index;
    private final HeapPool _heapPool = new HeapPool();

    protected ObjectFactory() {
        this._index = ObjectFactory.add(this);
    }

    private static synchronized int add(ObjectFactory objectFactory) {
        int n = Count;
        if (n >= MAX) {
            throw new UnsupportedOperationException("Maximum number of factories (system property \"javolution.factories\", value " + MAX + ") has been reached");
        }
        Class<?> clazz = objectFactory.getClass();
        for (int i = 0; i < n; ++i) {
            if (clazz != INSTANCES[i].getClass()) continue;
            throw new UnsupportedOperationException(clazz + "  cannot have more than one instance");
        }
        ObjectFactory.INSTANCES[n] = objectFactory;
        return Count++;
    }

    protected abstract T create();

    public T object() {
        return this.object(Context.current().inheritedPoolContext);
    }

    public final T object(PoolContext poolContext) {
        return poolContext != null ? poolContext.getLocalPool(this._index).next() : this.create();
    }

    public final ObjectPool<T> currentPool() {
        PoolContext poolContext = Context.current().inheritedPoolContext;
        return poolContext != null ? poolContext.getLocalPool(this._index) : this._heapPool;
    }

    public final ObjectPool<T> heapPool() {
        return this._heapPool;
    }

    protected void cleanup(T t) {
        throw new UnsupportedOperationException();
    }

    protected ObjectPool<T> newPool() {
        return new LocalPool();
    }

    static ObjectFactory getInstance(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n > 0) {
            ClassInitializer.initialize(string.substring(0, n));
        }
        ClassInitializer.initialize(clazz);
        for (int i = 0; i < Count; ++i) {
            if (!INSTANCES[i].getClass().equals(clazz)) continue;
            return INSTANCES[i];
        }
        return null;
    }

    static final class Node {
        Object _object;
        Node _next;

        Node() {
        }
    }

    private final class LocalPool
    extends ObjectPool {
        private final MemoryArea _memoryArea = MemoryArea.getMemoryArea(this);
        private boolean _doCleanup = true;
        private int _size;
        private Node _usedNodes;
        private Node _availNodes;
        private Node _usedNodesTail;
        private Node _node;

        private LocalPool() {
        }

        public int size() {
            return this._size;
        }

        public Object next() {
            if (this._availNodes != null) {
                this._node = this._availNodes;
                this._availNodes = this._node._next;
            } else {
                this._memoryArea.executeInArea(new Runnable(){

                    public void run() {
                        LocalPool.this._node = new Node();
                        ((LocalPool)LocalPool.this)._node._object = ObjectFactory.this.create();
                    }
                });
                ++this._size;
            }
            if (this._usedNodes == null) {
                this._usedNodesTail = this._node;
            }
            this._node._next = this._usedNodes;
            this._usedNodes = this._node;
            return this._node._object;
        }

        public void recycle(Object object) {
            Node node;
            if (this._doCleanup) {
                try {
                    ObjectFactory.this.cleanup(object);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this._doCleanup = false;
                }
            }
            if (this._usedNodes._object == object) {
                node = this._usedNodes;
                if (node == this._usedNodesTail) {
                    this._usedNodesTail = null;
                    if (node._next != null) {
                        throw new JavolutionError("Pool Corrupted");
                    }
                }
            } else {
                Node node2 = this._usedNodes;
                Node node3 = node2._next;
                while (node3 != null) {
                    if (node3._object == object) {
                        if (node3 == this._usedNodesTail) {
                            this._usedNodesTail = node2;
                        }
                        node2._next = node3._next;
                        node3._next = this._availNodes;
                        this._availNodes = node3;
                        return;
                    }
                    node2 = node3;
                    node3 = node3._next;
                }
                throw new IllegalArgumentException("Object not in the pool");
            }
            this._usedNodes = node._next;
            node._next = this._availNodes;
            this._availNodes = node;
        }

        protected void recycleAll() {
            if (this._doCleanup) {
                try {
                    Node node = this._usedNodes;
                    while (node != null) {
                        ObjectFactory.this.cleanup(node._object);
                        node = node._next;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this._doCleanup = false;
                }
            }
            if (this._usedNodes != null) {
                this._usedNodesTail._next = this._availNodes;
                this._availNodes = this._usedNodes;
                this._usedNodes = null;
                this._usedNodesTail = null;
            }
        }

        protected void clearAll() {
            this._availNodes = null;
            this._usedNodes = null;
            this._usedNodesTail = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HeapPool
    extends ObjectPool<T> {
        private HeapPool() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T next() {
            return ObjectFactory.this.create();
        }

        @Override
        public void recycle(T t) {
        }

        @Override
        protected void recycleAll() {
        }

        @Override
        protected void clearAll() {
        }
    }
}

