/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AbstractAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AbstractDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AttributeType;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.CategoricalAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DatasetException;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.FileDataset;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.IntegerNumericalAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.Metadata;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.RealNumericalAttribute;
import net.sf.jclec.util.intset.Interval;
import net.sf.jclec.util.range.Closure;

public class KeelDataSet
extends FileDataset {
    private static final long serialVersionUID = 1L;
    static String KEEL_RELATION = "@relation";
    static String KEEL_ATTRIBUTE = "@attribute";
    static String KEEL_DATA = "@data";
    static String KEEL_OUTPUTS = "@outputs";
    static String KEEL_INPUTS = "@inputs";
    protected String missedValue = "?";
    protected String commentedValue = "%";
    protected String separationValue = ",";
    protected String bufferInstance = new String();

    public KeelDataSet(String fileName, String ... specificationFile) {
        super(fileName);
    }

    public KeelDataSet() {
    }

    @Override
    public void open() {
        this.obtainMetadata(this.fileName);
        this.cursorPosition = 0;
        this.cursorInstance = new AbstractDataset.Instance();
        this.extractIntervalsFromData();
    }

    @Override
    public void reset() {
        try {
            this.fileReader.close();
            this.fileReader = new BufferedReader(new FileReader(new File(this.fileName)));
            String line = ((BufferedReader)this.fileReader).readLine();
            while (!line.equalsIgnoreCase(KEEL_DATA)) {
                line = ((BufferedReader)this.fileReader).readLine();
            }
            this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            while (this.bufferInstance.startsWith(this.commentedValue) || this.bufferInstance.equalsIgnoreCase("")) {
                this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            }
            this.cursorPosition = 0;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean next() throws DatasetException {
        if (this.bufferInstance != null) {
            try {
                ++this.cursorPosition;
                StringTokenizer token = new StringTokenizer(this.bufferInstance, this.separationValue);
                int numAttributes = 0;
                while (token.hasMoreTokens()) {
                    IAttribute attribute = this.metadata.getAttribute(numAttributes);
                    String tok = token.nextToken().trim();
                    if (tok.equals("<null>")) {
                        this.cursorInstance.setValue(numAttributes, Double.NaN);
                    } else {
                        double value = attribute.parse(tok);
                        this.cursorInstance.setValue(numAttributes, value);
                    }
                    ++numAttributes;
                }
                this.prepareNextInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractDataset.Instance read() throws DatasetException {
        return this.cursorInstance;
    }

    @Override
    public void close() throws DatasetException {
        try {
            this.fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void obtainMetadata(String file) {
        File f1 = new File(file);
        this.metadata = new Metadata();
        try {
            this.fileReader = new BufferedReader(new FileReader(f1));
            String line = ((BufferedReader)this.fileReader).readLine();
            int indexAttribute = 0;
            line = line.replace("real[", "real [");
            line = line.replace("integer[", "integer [");
            line = line.replace("{", " {");
            StringTokenizer elementLine = new StringTokenizer(line);
            String element = elementLine.nextToken();
            while (!element.equalsIgnoreCase(KEEL_DATA)) {
                if (element.equalsIgnoreCase(KEEL_ATTRIBUTE)) {
                    ++indexAttribute;
                    String name = elementLine.nextToken();
                    String type = elementLine.nextToken();
                    if (type.equalsIgnoreCase("REAL") || type.equalsIgnoreCase("INTEGER")) {
                        this.addAttributeToSpecification(type, line, name);
                    } else {
                        this.addAttributeToSpecification("STRING", line, name);
                    }
                }
                if (element.equalsIgnoreCase(KEEL_RELATION)) {
                    this.setName(elementLine.nextToken());
                }
                line = ((BufferedReader)this.fileReader).readLine();
                while (line.startsWith(this.commentedValue) || line.equalsIgnoreCase("")) {
                    line = ((BufferedReader)this.fileReader).readLine();
                }
                line = line.replace("real[", "real [");
                line = line.replace("integer[", "integer [");
                line = line.replace("{", " {");
                elementLine = new StringTokenizer(line);
                element = elementLine.nextToken();
            }
            this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            while (this.bufferInstance.startsWith(this.commentedValue) || this.bufferInstance.equalsIgnoreCase("")) {
                this.bufferInstance = ((BufferedReader)this.fileReader).readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareNextInstance() {
        try {
            String lineInstance = ((BufferedReader)this.fileReader).readLine();
            while (lineInstance.startsWith(this.commentedValue) || lineInstance.equalsIgnoreCase("")) {
                lineInstance = ((BufferedReader)this.fileReader).readLine();
            }
            this.bufferInstance = lineInstance;
        }
        catch (Exception e) {
            this.bufferInstance = null;
        }
    }

    private void addAttributeToSpecification(String type, String interval, String name) {
        if (type.equalsIgnoreCase("REAL")) {
            RealNumericalAttribute attribute = new RealNumericalAttribute();
            attribute.setName(name);
            if (interval.contains("[") && interval.contains("]")) {
                int minIndex = interval.indexOf("[");
                int maxIndex = interval.indexOf("]");
                interval = interval.substring(minIndex + 1, maxIndex);
                if (minIndex < maxIndex) {
                    StringTokenizer tkInterval = new StringTokenizer(interval, ",");
                    net.sf.jclec.util.range.Interval intervals = new net.sf.jclec.util.range.Interval();
                    intervals.setClosure(Closure.ClosedClosed);
                    intervals.setLeft(Double.valueOf((String)tkInterval.nextElement()));
                    intervals.setRight(Double.valueOf(tkInterval.nextToken()));
                    attribute.addInterval(intervals);
                    this.metadata.addAttribute(attribute);
                }
            } else {
                net.sf.jclec.util.range.Interval intervals = new net.sf.jclec.util.range.Interval();
                intervals.setClosure(Closure.ClosedClosed);
                intervals.setLeft(Double.MIN_VALUE);
                intervals.setRight(Double.MAX_VALUE);
                attribute.addInterval(intervals);
                this.metadata.addAttribute(attribute);
            }
        } else if (type.equalsIgnoreCase("INTEGER")) {
            IntegerNumericalAttribute attribute = new IntegerNumericalAttribute();
            attribute.setName(name);
            if (interval.contains("[") && interval.contains("]")) {
                int minIndex = interval.indexOf("[");
                int maxIndex = interval.indexOf("]");
                interval = interval.substring(minIndex + 1, maxIndex);
                if (minIndex < maxIndex) {
                    StringTokenizer tkInterval = new StringTokenizer(interval, ",");
                    Interval intervals = new Interval();
                    intervals.setClosure(net.sf.jclec.util.intset.Closure.ClosedClosed);
                    intervals.setLeft(Integer.valueOf((String)tkInterval.nextElement()));
                    intervals.setRight(Integer.valueOf(tkInterval.nextToken().trim()));
                    attribute.addInterval(intervals);
                    this.metadata.addAttribute(attribute);
                }
            } else {
                Interval intervals = new Interval();
                intervals.setClosure(net.sf.jclec.util.intset.Closure.ClosedClosed);
                intervals.setLeft(Integer.MIN_VALUE);
                intervals.setRight(Integer.MAX_VALUE);
                attribute.addInterval(intervals);
                this.metadata.addAttribute(attribute);
            }
        } else {
            int minIndex = interval.indexOf("{");
            int maxIndex = interval.indexOf("}");
            interval = interval.substring(minIndex + 1, maxIndex);
            if (minIndex < maxIndex) {
                CategoricalAttribute attribute = new CategoricalAttribute();
                attribute.setName(name);
                StringTokenizer categories = new StringTokenizer(interval, ",");
                while (categories.hasMoreTokens()) {
                    attribute.addValue(categories.nextToken().trim());
                }
                this.metadata.addAttribute(attribute);
            }
        }
    }

    private void extractIntervalsFromData() {
        try {
            int i;
            double[] min = new double[this.metadata.numberOfAttributes()];
            double[] max = new double[this.metadata.numberOfAttributes()];
            boolean[] nonSpecified = new boolean[this.metadata.numberOfAttributes()];
            for (i = 0; i < this.metadata.numberOfAttributes(); ++i) {
                AbstractAttribute attribute;
                min[i] = Double.MAX_VALUE;
                max[i] = Double.MIN_VALUE;
                if (this.metadata.getAttribute(i).getType() == AttributeType.DoubleNumerical) {
                    attribute = (RealNumericalAttribute)this.metadata.getAttribute(i);
                    nonSpecified[i] = ((RealNumericalAttribute)attribute).intervalValues().getLeft() == Double.MIN_VALUE && ((RealNumericalAttribute)attribute).intervalValues().getRight() == Double.MAX_VALUE;
                    continue;
                }
                if (this.metadata.getAttribute(i).getType() != AttributeType.IntegerNumerical) continue;
                attribute = (IntegerNumericalAttribute)this.metadata.getAttribute(i);
                nonSpecified[i] = ((IntegerNumericalAttribute)attribute).intervalValues().getLeft() == -2.147483648E9 && ((IntegerNumericalAttribute)attribute).intervalValues().getRight() == Integer.MAX_VALUE;
            }
            while (this.next()) {
                AbstractDataset.Instance instancia = this.read();
                for (int i2 = 0; i2 < this.metadata.numberOfAttributes(); ++i2) {
                    if (!nonSpecified[i2]) continue;
                    double value = instancia.getValue(i2);
                    if (value < min[i2]) {
                        min[i2] = value;
                    }
                    if (!(value > max[i2])) continue;
                    max[i2] = value;
                }
            }
            for (i = 0; i < this.metadata.numberOfAttributes(); ++i) {
                AbstractAttribute attribute;
                if (!nonSpecified[i]) continue;
                if (this.metadata.getAttribute(i).getType() == AttributeType.DoubleNumerical) {
                    attribute = (RealNumericalAttribute)this.metadata.getAttribute(i);
                    ((RealNumericalAttribute)attribute).intervalValues().setLeft(min[i]);
                    ((RealNumericalAttribute)attribute).intervalValues().setRight(max[i]);
                    continue;
                }
                if (this.metadata.getAttribute(i).getType() != AttributeType.IntegerNumerical) continue;
                attribute = (IntegerNumericalAttribute)this.metadata.getAttribute(i);
                ((IntegerNumericalAttribute)attribute).intervalValues().setLeft((int)min[i]);
                ((IntegerNumericalAttribute)attribute).intervalValues().setRight((int)max[i]);
            }
            this.reset();
        }
        catch (DatasetException e) {
            e.printStackTrace();
        }
    }
}

