/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class InputNeuron
implements INeuron {
    protected static final XmlFormat<InputNeuron> XML = new XmlFormat<InputNeuron>(InputNeuron.class){

        @Override
        public void format(InputNeuron source, XmlElement xml) {
            xml.setAttribute("index", source.index);
        }

        @Override
        public InputNeuron parse(XmlElement xml) {
            InputNeuron result = (InputNeuron)xml.object();
            result.index = xml.getAttribute("index", 1);
            return result;
        }

        @Override
        public String defaultName() {
            return "input-neuron";
        }
    };
    private static final long serialVersionUID = -6041931197564234348L;
    protected int index;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean equals(INeuron other) {
        return this.hashCode() == other.hashCode();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(31, 37);
        hcb.append(this.index);
        return hcb.toHashCode();
    }

    @Override
    public double operate(double[] inputs) {
        return inputs[this.index];
    }

    public double[] operate(DoubleTransposedDataSet dataSet) {
        return dataSet.getObservationsOf(this.index);
    }

    @Override
    public double[] operate(double[][] inputs) {
        return inputs[this.index];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("x" + (this.index + 1));
        return sb.toString();
    }
}

