/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.intarray;

import java.util.StringTokenizer;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IFitness;
import net.sf.jclec.IIndividual;
import net.sf.jclec.base.AbstractIndividual;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayIndividual
extends AbstractIndividual<int[]> {
    protected static final XmlFormat<IntArrayIndividual> XML = new XmlFormat<IntArrayIndividual>(IntArrayIndividual.class){

        @Override
        public void format(IntArrayIndividual source, XmlElement xml) {
            IntArrayIndividual.access$0().format(source, xml);
            int genotypeLenght = ((int[])source.genotype).length;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < genotypeLenght) {
                sb.append(((int[])source.genotype)[i]);
                if (i != genotypeLenght - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            xml.add(sb.toString(), "genotype", STRING_XML);
        }

        @Override
        public IntArrayIndividual parse(XmlElement xml) {
            IntArrayIndividual result = (IntArrayIndividual)IntArrayIndividual.access$0().parse(xml);
            String genotypeString = (String)xml.get("genotype", STRING_XML);
            StringTokenizer st = new StringTokenizer(genotypeString);
            result.genotype = new int[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                ((int[])((IntArrayIndividual)result).genotype)[i] = Byte.parseByte(st.nextToken());
                ++i;
            }
            return result;
        }

        @Override
        public String defaultName() {
            return "int-array-individual";
        }
    };
    private static final long serialVersionUID = -2908949095129168050L;

    public IntArrayIndividual() {
    }

    public IntArrayIndividual(int[] genotype) {
        super(genotype);
    }

    public IntArrayIndividual(int[] genotype, IFitness fitness) {
        super(genotype, fitness);
    }

    @Override
    public IIndividual copy() {
        int gl = ((int[])this.genotype).length;
        int[] gother = new int[((int[])this.genotype).length];
        System.arraycopy(this.genotype, 0, gother, 0, gl);
        if (this.fitness != null) {
            return new IntArrayIndividual(gother, this.fitness.copy());
        }
        return new IntArrayIndividual(gother);
    }

    @Override
    public double distance(IIndividual other) {
        int[] gother = (int[])((IntArrayIndividual)other).genotype;
        double distance = 0.0;
        int gl = ((int[])this.genotype).length;
        int i = 0;
        while (i < gl) {
            double aux = ((int[])this.genotype)[i] - gother[i];
            distance += aux >= 0.0 ? aux : -aux;
            ++i;
        }
        return distance;
    }

    public boolean equals(Object other) {
        if (other instanceof IntArrayIndividual) {
            IntArrayIndividual iaother = (IntArrayIndividual)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append((int[])this.genotype, (int[])iaother.genotype);
            eb.append(this.fitness, iaother.fitness);
            return eb.isEquals();
        }
        return false;
    }

    static /* synthetic */ XmlFormat access$0() {
        return AbstractIndividual.XML;
    }
}

