/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD.AssocRuleMining;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD.TtreeNode;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.myDataset;

public class TotalSupportTree
extends AssocRuleMining {
    protected TtreeNode[] startTtreeRef;
    private HashSet<Integer> covTIDs = new HashSet();
    protected long numUpdates = 0L;

    public TotalSupportTree(myDataset ds, double sup, double conf) {
        super(ds, sup, conf);
    }

    public void addToTtree(short[] itemSet, int support) {
        int endIndex = itemSet.length - 1;
        this.startTtreeRef = this.addToTtree(this.startTtreeRef, this.numOneItemSets + 1, endIndex, itemSet, support);
    }

    protected TtreeNode[] addToTtree(TtreeNode[] linkRef, int size, int endIndex, short[] itemSet, int support) {
        short currentAttribute;
        if (linkRef == null) {
            linkRef = new TtreeNode[size];
            for (int index = 1; index < linkRef.length; ++index) {
                linkRef[index] = null;
            }
        }
        if (linkRef[currentAttribute = itemSet[endIndex]] == null) {
            linkRef[currentAttribute] = new TtreeNode();
        }
        if (endIndex == 0) {
            linkRef[currentAttribute].support += support;
            return linkRef;
        }
        linkRef[currentAttribute].childRef = this.addToTtree(linkRef[currentAttribute].childRef, currentAttribute, endIndex - 1, itemSet, support);
        return linkRef;
    }

    protected int getSupportForItemSetInTtree(short[] itemSet) {
        int endInd = itemSet.length - 1;
        if (this.startTtreeRef[itemSet[endInd]] != null) {
            if (endInd == 0) {
                return this.startTtreeRef[itemSet[0]].support;
            }
            TtreeNode[] tempRef = this.startTtreeRef[itemSet[endInd]].childRef;
            if (tempRef != null) {
                return this.getSupForIsetInTtree2(itemSet, endInd - 1, tempRef);
            }
            return 0;
        }
        return 0;
    }

    private int getSupForIsetInTtree2(short[] itemSet, int index, TtreeNode[] linkRef) {
        if (linkRef[itemSet[index]] != null) {
            if (index == 0) {
                return linkRef[itemSet[0]].support;
            }
            if (linkRef[itemSet[index]].childRef != null) {
                return this.getSupForIsetInTtree2(itemSet, index - 1, linkRef[itemSet[index]].childRef);
            }
            return 0;
        }
        return 0;
    }

    public void generateARs() {
        this.startRulelist = null;
        this.generateARs2();
    }

    protected void generateARs2() {
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            short[] itemSetSoFar = new short[]{(short)index};
            this.generateARs(itemSetSoFar, index, this.startTtreeRef[index].childRef);
        }
    }

    protected void generateARs(short[] itemSetSofar, int size, TtreeNode[] linkRef) {
        if (linkRef == null) {
            return;
        }
        for (int index = 1; index < size; ++index) {
            if (linkRef[index] == null || !((double)linkRef[index].support >= this.minSupport)) continue;
            short[] tempItemSet = this.realloc2(itemSetSofar, (short)index);
            this.generateARsFromItemset(tempItemSet, linkRef[index].support);
            this.generateARs(tempItemSet, index, linkRef[index].childRef);
        }
    }

    private void generateARsFromItemset(short[] itemSet, double support) {
        boolean atLeastOneGeneratedRule = false;
        for (int i = 0; i < itemSet.length; ++i) {
            short[] consequent = new short[]{itemSet[i]};
            short[] antecedent = this.complement(consequent, itemSet);
            if (antecedent == null) continue;
            double supportForAntecedent = this.getSupportForItemSetInTtree(antecedent);
            double supportForConsequent = this.getSupportForItemSetInTtree(consequent);
            double confidenceForAR = support / supportForAntecedent * 100.0;
            if (!(confidenceForAR >= this.confidence)) continue;
            this.insertRuleintoRulelist(antecedent, consequent, confidenceForAR, support, supportForAntecedent, supportForConsequent);
            if (atLeastOneGeneratedRule) continue;
            atLeastOneGeneratedRule = true;
        }
        if (atLeastOneGeneratedRule) {
            this.covTIDs.addAll(this.getCoveredRecords(this.reconvertItemSet(itemSet)));
        }
    }

    public void setNumOneItemSets() {
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    public void outputFrequentSets() {
        int number = 1;
        System.out.println("FREQUENT (LARGE) ITEM SETS:\n---------------------------");
        System.out.println("Format: [N] {I} = S, where N is a sequential number, I is the item set and S the support.");
        for (short index = 1; index <= this.numOneItemSets; index = (short)((short)(index + 1))) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            String itemSetSofar = new Short(this.reconvertItem(index)).toString();
            System.out.println("[" + number + "] {" + itemSetSofar + "} = " + this.startTtreeRef[index].support);
            number = this.outputFrequentSets(number + 1, itemSetSofar, index, this.startTtreeRef[index].childRef);
        }
        System.out.println("\n");
    }

    private int outputFrequentSets(int number, String itemSetSofar, int size, TtreeNode[] linkRef) {
        if (linkRef == null) {
            return number;
        }
        itemSetSofar = itemSetSofar + " ";
        for (short index = 1; index < size; index = (short)((short)(index + 1))) {
            if (linkRef[index] == null || !((double)linkRef[index].support >= this.minSupport)) continue;
            String newItemSet = itemSetSofar + this.reconvertItem(index);
            System.out.println("[" + number + "] {" + newItemSet + "} = " + linkRef[index].support);
            number = this.outputFrequentSets(number + 1, newItemSet, index, linkRef[index].childRef);
        }
        return number;
    }

    protected int countNumFreqSets() {
        if (this.startTtreeRef == null) {
            return 0;
        }
        int num = 0;
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            num = this.countNumFreqSets(index, this.startTtreeRef[index].childRef, num + 1);
        }
        return num;
    }

    protected int countNumFreqSets(int size, TtreeNode[] linkRef, int num) {
        if (linkRef == null) {
            return num;
        }
        for (int index = 1; index < size; ++index) {
            if (linkRef[index] == null || !((double)linkRef[index].support >= this.minSupport)) continue;
            num = this.countNumFreqSets(index, linkRef[index].childRef, num + 1);
        }
        return num;
    }

    public int getNumFreqSets() {
        if (this.startTtreeRef == null) {
            return 0;
        }
        return this.countNumFreqSets();
    }

    protected HashSet<Integer> getCoveredRecords(short[] itemset) {
        Hashtable<Integer, HashSet<Integer>> tid_list = this.dataset.getTIDList();
        HashSet<Integer> toIntersect = new HashSet<Integer>((Collection)tid_list.get(itemset[0]));
        for (int i = 1; i < itemset.length; ++i) {
            toIntersect.retainAll((Collection)tid_list.get(itemset[i]));
            if (toIntersect.isEmpty()) break;
        }
        return toIntersect;
    }

    public HashSet<Integer> getCoveredRecords() {
        return this.covTIDs;
    }
}

