/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.classic;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.algorithm.classic.DefaultDistance;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.random.IRandGenFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class CHC
extends PopulationAlgorithm {
    private static final long serialVersionUID = -1226411728565815007L;
    protected int initialD;
    protected IDistance distance;
    protected IRecombinator recombinator;
    protected int restartD;
    protected int numberOfSurvivors;
    protected IMutator mutator;
    private transient IRandGen randgen;
    private transient int d;
    private transient BettersSelector bettersSelector = new BettersSelector(this);

    @Override
    public void setRandGenFactory(IRandGenFactory randGenFactory) {
        super.setRandGenFactory(randGenFactory);
        this.randgen = randGenFactory.createRandGen();
    }

    public int getInitialD() {
        return this.initialD;
    }

    public void setInitialD(int initialD) {
        this.initialD = initialD;
    }

    public IDistance getDistance() {
        return this.distance;
    }

    public void setDistance(IDistance distance) {
        this.distance = distance;
    }

    public IRecombinator getRecombinator() {
        return this.recombinator;
    }

    public void setRecombinator(IRecombinator recombinator) {
        this.recombinator = recombinator;
        recombinator.contextualize(this);
    }

    public int getRestartD() {
        return this.restartD;
    }

    public void setRestartD(int restartD) {
        this.restartD = restartD;
    }

    public int getNumberOfSurvidors() {
        return this.numberOfSurvivors;
    }

    public void setNumberOfSurvivors(int numberOfSurvivors) {
        this.numberOfSurvivors = numberOfSurvivors;
    }

    public IMutator getMutator() {
        return this.mutator;
    }

    public void setMutator(IMutator mutator) {
        this.mutator = mutator;
        mutator.contextualize(this);
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        int initialD = configuration.getInt("initial-d");
        this.setInitialD(initialD);
        String distanceClassname = configuration.getString("distance[@type]");
        if (distanceClassname == null) {
            this.distance = new DefaultDistance();
        } else {
            try {
                Class<?> distanceClass = Class.forName(distanceClassname);
                IDistance distance = (IDistance)distanceClass.newInstance();
                if (distance instanceof IConfigure) {
                    Configuration distanceConfiguration = configuration.subset("distance");
                    ((IConfigure)((Object)distance)).configure(distanceConfiguration);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("Illegal distance classname");
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of distance", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of distance", e);
            }
        }
        try {
            String recombinatorClassname = configuration.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = configuration.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        int restartD = configuration.getInt("restart-d");
        this.setRestartD(restartD);
        int numberOfSurvivors = configuration.getInt("number-of-survivors", 1);
        this.setNumberOfSurvivors(numberOfSurvivors);
        String mutatorClassname = configuration.getString("mutator[@type]");
        if (mutatorClassname == null) {
            this.mutator = null;
        } else {
            try {
                Class<?> mutatorClass = Class.forName(mutatorClassname);
                IMutator mutator = (IMutator)mutatorClass.newInstance();
                if (mutator instanceof IConfigure) {
                    Configuration mutatorConfiguration = configuration.subset("mutator");
                    ((IConfigure)((Object)mutator)).configure(mutatorConfiguration);
                }
                this.setMutator(mutator);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationRuntimeException("Illegal mutator classname");
            }
            catch (InstantiationException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
            }
        }
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.d = this.initialD;
    }

    @Override
    protected void doSelection() {
        this.shuffle(this.bset);
        this.pset = new ArrayList();
        int psm1 = this.populationSize - 1;
        int i = 0;
        while (i < psm1) {
            IIndividual ind2;
            IIndividual ind1 = (IIndividual)this.bset.get(i);
            if (this.distance.distance(ind1, ind2 = (IIndividual)this.bset.get(i + 1)) > (double)(2 * this.d)) {
                this.pset.add(ind1);
                this.pset.add(ind2);
            }
            i += 2;
        }
    }

    @Override
    protected void doGeneration() {
        this.cset = this.recombinator.recombine(this.pset);
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
    }

    @Override
    protected void doUpdate() {
        this.bset.addAll(this.cset);
        this.bset = this.bettersSelector.select(this.bset, this.populationSize);
        for (IIndividual ind : this.cset) {
            if (!this.bset.contains(ind)) continue;
            return;
        }
        --this.d;
        if (this.d < 0) {
            this.bset = this.bettersSelector.select(this.bset, this.numberOfSurvivors);
            int ninds = this.populationSize - this.numberOfSurvivors;
            if (this.mutator == null) {
                this.bset.addAll(this.provider.provide(ninds));
            } else {
                this.pset.clear();
                IIndividual seed = (IIndividual)this.bset.get(0);
                int i = 0;
                while (i < ninds) {
                    this.pset.add(seed.copy());
                    ++i;
                }
                this.pset.addAll(this.mutator.mutate(this.pset));
            }
            this.d = this.restartD;
        }
    }

    private final void shuffle(List<IIndividual> list) {
        int size = list.size();
        IIndividual[] arr = list.toArray(new IIndividual[size]);
        int i = size;
        while (i > 1) {
            CHC.swap(arr, i - 1, this.randgen.choose(i));
            --i;
        }
        ListIterator<IIndividual> it = list.listIterator();
        int i2 = 0;
        while (i2 < arr.length) {
            it.next();
            it.set(arr[i2]);
            ++i2;
        }
    }

    private static final void swap(IIndividual[] arr, int i, int j) {
        IIndividual tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    protected static interface IDistance {
        public double distance(IIndividual var1, IIndividual var2);
    }
}

