/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;

public class FuzzyInterval
extends Fuzzy {
    double a;
    double b;

    public double a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    public FuzzyInterval(double pa, double pb) {
        this.a = pa;
        this.b = pb;
    }

    public FuzzyInterval(FuzzyInterval pa) {
        this.a = pa.a;
        this.b = pa.b;
    }

    @Override
    public boolean equals(Fuzzy B) {
        if (!(B instanceof FuzzyInterval)) {
            return false;
        }
        FuzzyInterval bt = (FuzzyInterval)B;
        if (this.a != bt.a) {
            return false;
        }
        return this.b == bt.b;
    }

    @Override
    public Fuzzy clone() {
        return new FuzzyInterval(this);
    }

    public void Asigna(FuzzyInterval pa) {
        this.a = pa.a;
        this.b = pa.b;
    }

    @Override
    public double evaluateMembership(double x) {
        if (x >= this.a && x <= this.b) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double massCentre() {
        return (this.a + this.b) / 2.0;
    }

    @Override
    public FuzzyInterval support() {
        return new FuzzyInterval(this.a, this.b);
    }

    @Override
    public String aString() {
        return "INTERVAL [" + this.a + ", " + this.b + "]";
    }
}

