/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree.rec;

import java.util.ArrayList;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.IRecombineExprTree;
import net.sourceforge.jclec.util.random.IRandGen;

public class SubtreeCrossover
implements IRecombineExprTree {
    private static final long serialVersionUID = -181587917177007772L;

    public boolean equals(Object other) {
        return other instanceof SubtreeCrossover;
    }

    @Override
    public void recombine(ExprTree ptree0, ExprTree ptree1, ExprTree stree0, ExprTree stree1, ExprTreeSchema schema, IRandGen randgen) {
        int treeP0Size = ptree0.size();
        int treeP1Size = ptree1.size();
        int cp1Start = randgen.choose(1, treeP0Size);
        int cp1EndP1 = ptree0.subTree(cp1Start);
        int cp1Size = cp1EndP1 - cp1Start;
        Class<?> cp1Type = ptree0.getBlock(cp1Start).returnType();
        ArrayList<Integer> cp2List1 = new ArrayList<Integer>();
        int i = 1;
        while (i < treeP1Size) {
            if (ptree1.getBlock(i).returnType().equals(cp1Type)) {
                cp2List1.add(i);
            }
            ++i;
        }
        int maxTreeSize = schema.getMaxTreeSize();
        ArrayList<Integer> cp2List2 = new ArrayList<Integer>();
        int i2 = 1;
        while (i2 < cp2List1.size()) {
            boolean cond2;
            int cp2i = (Integer)cp2List1.get(i2);
            int cp2iSize = ptree1.subTree(cp2i) - cp2i;
            boolean cond1 = treeP0Size - cp1Size + cp2iSize <= maxTreeSize;
            boolean bl = cond2 = treeP1Size - cp2iSize + cp1Size <= maxTreeSize;
            if (cond1 && cond2) {
                cp2List2.add(i2);
            }
            ++i2;
        }
        if (cp2List2.size() != 0) {
            int cp2Start = (Integer)cp2List2.get(randgen.choose(0, cp2List2.size()));
            int cp2EndP1 = ptree1.subTree(cp2Start);
            int i3 = 0;
            while (i3 < cp1Start) {
                stree0.addBlock(ptree0.getBlock(i3).copy());
                ++i3;
            }
            i3 = cp2Start;
            while (i3 < cp2EndP1) {
                stree0.addBlock(ptree1.getBlock(i3).copy());
                ++i3;
            }
            i3 = cp1EndP1;
            while (i3 < treeP0Size) {
                stree0.addBlock(ptree0.getBlock(i3).copy());
                ++i3;
            }
            i3 = 0;
            while (i3 < cp2Start) {
                stree1.addBlock(ptree1.getBlock(i3).copy());
                ++i3;
            }
            i3 = cp1Start;
            while (i3 < cp1EndP1) {
                stree1.addBlock(ptree0.getBlock(i3).copy());
                ++i3;
            }
            i3 = cp2EndP1;
            while (i3 < treeP1Size) {
                stree1.addBlock(ptree1.getBlock(i3).copy());
                ++i3;
            }
        } else {
            i2 = 0;
            while (i2 < treeP0Size) {
                stree0.addBlock(ptree0.getBlock(i2).copy());
                ++i2;
            }
            i2 = 0;
            while (i2 < treeP1Size) {
                stree1.addBlock(ptree1.getBlock(i2).copy());
                ++i2;
            }
        }
    }
}

