/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.tan;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IEvaluator;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.FilteredMutator;
import net.sourceforge.jclec.base.FilteredRecombinator;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.problem.classification.falco.FalcoEvaluator;
import net.sourceforge.jclec.problem.classification.tan.TanClassifier;
import net.sourceforge.jclec.problem.classification.tan.TanEvaluator;
import net.sourceforge.jclec.problem.classification.tan.TanSyntaxTreeSpecies;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.AbstractRandGenFactory;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.random.RanecuFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class TanAlgorithm
extends PopulationAlgorithm {
    private static final long serialVersionUID = -8711970425735016406L;
    protected ISelector parentsSelector;
    protected FilteredRecombinator recombinator;
    protected FilteredMutator mutator;
    protected TanClassifier classifier;
    double copyProb;
    double elitistProb;
    private IDataset trainSet;
    private IDataset testSet;
    private IMetadata trainMetadata;
    private IMetadata testMetadata;
    protected double support;
    protected int classesNumber;
    protected int execution = 0;
    protected IRandGen randgen;
    List<IIndividual> eset = new ArrayList<IIndividual>();
    protected BettersSelector bettersSelector = new BettersSelector(this);

    public ISelector getParentsSelector() {
        return this.parentsSelector;
    }

    public void setParentsSelector(ISelector parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public FilteredRecombinator getRecombinator() {
        return this.recombinator;
    }

    public void setRecombinator(IRecombinator recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public FilteredMutator getMutator() {
        return this.mutator;
    }

    public void setMutator(IMutator mutator) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setDecorated(mutator);
    }

    public TanClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(TanClassifier classifier) {
        this.classifier = classifier;
    }

    public double getCopyProb() {
        return this.copyProb;
    }

    public void setCopyProb(double copyProb) {
        this.copyProb = copyProb;
    }

    public double getElitistProb() {
        return this.elitistProb;
    }

    public void setElitistProb(double elitistProb) {
        this.elitistProb = elitistProb;
    }

    public void setSupport(double support) {
        this.support = support;
    }

    public double getSupport() {
        return this.support;
    }

    public IDataset getTrainSet() {
        return this.trainSet;
    }

    public void setTrainSet(IDataset train) {
        this.trainSet = train;
    }

    public IDataset getTestSet() {
        return this.testSet;
    }

    public void setTestSet(IDataset test) {
        this.testSet = test;
    }

    public IMetadata getTrainMetadata() {
        return this.trainMetadata;
    }

    public void setTrainMetadata(IMetadata train) {
        this.trainMetadata = train;
    }

    public IMetadata getTestMetadata() {
        return this.testMetadata;
    }

    public void setTestMetadata(IMetadata test) {
        this.testMetadata = test;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        this.setDatasetSettings(settings);
        int maxDerivSize = settings.getInt("max-deriv-size");
        ((TanSyntaxTreeSpecies)this.getSpecies()).setTanGrammar();
        ((TanSyntaxTreeSpecies)this.getSpecies()).setMaxDerivSize(maxDerivSize);
        RanecuFactory randGenFactory = new RanecuFactory();
        int seed = ((AbstractRandGenFactory)this.getRandGenFactory()).getSeed();
        randGenFactory.setSeed(seed);
        ((TanEvaluator)this.evaluator).setRandGen(randGenFactory.createRandGen());
        ((TanEvaluator)this.evaluator).setMaxDerivSize(maxDerivSize);
        this.SetParentsSelectorSettings(settings);
        this.SetRecombinatorSettings(settings);
        this.SetMutatorSettings(settings);
        double copyProb = settings.getDouble("copy-prob", 0.1);
        this.setCopyProb(copyProb);
        double elitProb = settings.getDouble("elitist-prob", 0.1);
        this.setElitistProb(elitProb);
        double support = settings.getDouble("support", 0.5);
        this.setSupport(support);
    }

    private void SetMutatorSettings(Configuration settings) {
        try {
            String mutatorClassname = settings.getString("mutator[@type]");
            Class<?> mutatorClass = Class.forName(mutatorClassname);
            IMutator mutator = (IMutator)mutatorClass.newInstance();
            if (mutator instanceof IConfigure) {
                Configuration mutatorConfiguration = settings.subset("mutator");
                ((IConfigure)((Object)mutator)).configure(mutatorConfiguration);
            }
            this.setMutator(mutator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        double mutProb = settings.getDouble("mutator[@mut-prob]", 0.05);
        this.setMutationProb(mutProb);
    }

    private void SetRecombinatorSettings(Configuration settings) {
        try {
            String recombinatorClassname = settings.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = settings.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        double recProb = settings.getDouble("recombinator[@rec-prob]", 0.7);
        this.setRecombinationProb(recProb);
    }

    private void SetParentsSelectorSettings(Configuration settings) {
        try {
            String parentsSelectorClassname = settings.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = settings.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
    }

    private void setDatasetSettings(Configuration settings) {
        try {
            String datasetClassname = settings.getString("dataset[@type]");
            Class<?> datasetClass = Class.forName(datasetClassname);
            this.setTrainSet((IDataset)datasetClass.newInstance());
            Configuration datasetSettings = settings.subset("dataset.train-data");
            this.getTrainSet().configure(datasetSettings);
            this.setTestSet((IDataset)datasetClass.newInstance());
            datasetSettings = settings.subset("dataset.test-data");
            this.getTestSet().configure(datasetSettings);
            this.getTrainSet().open();
            this.setTrainMetadata(this.getTrainSet().getMetadata());
            this.getTrainSet().loadInstances();
            this.getTrainSet().close();
            this.getTestSet().open();
            this.setTestMetadata(this.getTestSet().getMetadata());
            this.getTestSet().loadInstances();
            this.getTestSet().close();
            String attributeClass = settings.getString("dataset.attribute-class-name");
            if (attributeClass != null) {
                int attributeClassIndex = this.getTrainMetadata().getIndex(attributeClass);
                this.getTrainMetadata().setClassIndex(attributeClassIndex);
                this.getTestMetadata().setClassIndex(attributeClassIndex);
            } else {
                this.getTrainMetadata().setClassIndex(this.trainMetadata.numberOfAttributes() - 1);
                this.getTestMetadata().setClassIndex(this.testMetadata.numberOfAttributes() - 1);
            }
            this.classifier = new TanClassifier(null, 0.0);
            ((TanSyntaxTreeSpecies)this.getSpecies()).setMetadata(this.getTrainMetadata());
            CategoricalAttribute catAttr = (CategoricalAttribute)this.getTrainMetadata().getAttribute(this.getTrainMetadata().getClassIndex());
            this.setClassesNumber(catAttr.getCategories().size());
            ((TanEvaluator)this.evaluator).setDataset(this.getTrainSet());
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (DatasetException e) {
            e.printStackTrace();
        }
    }

    private void setClassesNumber(int number) {
        this.classesNumber = number;
    }

    private void setRecombinationProb(double recProb) {
        this.recombinator.setRecProb(recProb);
    }

    private void setMutationProb(double mutProb) {
        this.mutator.setMutProb(mutProb);
    }

    private List<IIndividual> doTokenCompetition(List<IIndividual> newpop, List<IIndividual> epop, IEvaluator evaluator) {
        List<IIndividual> unitepopulation = new ArrayList<IIndividual>();
        ArrayList<IIndividual> esetAux = new ArrayList<IIndividual>();
        unitepopulation.addAll(newpop);
        unitepopulation.addAll(epop);
        this.eset.clear();
        int bsetSize = this.bset.size();
        while (unitepopulation.size() > bsetSize) {
            unitepopulation.remove(unitepopulation.size() - 1);
        }
        for (IIndividual ind : unitepopulation) {
            ind.setFitness(null);
        }
        evaluator.evaluate(unitepopulation);
        unitepopulation = this.bettersSelector.select(unitepopulation);
        IDataset.IInstance[] instances = this.getTrainSet().getInstances();
        int numInstances = instances.length;
        int[] patterns = new int[numInstances];
        int uniteSize = unitepopulation.size();
        int i = 0;
        while (i < uniteSize) {
            Individual find = (Individual)unitepopulation.get(i);
            SyntaxTreeClassificationRule rule = (SyntaxTreeClassificationRule)find.getPhenotype();
            int coversCount = 0;
            int nPatternsCovered = 0;
            int j = 0;
            while (j < numInstances) {
                IDataset.IInstance instance = instances[j];
                if (rule.covers(instance) && instance.getValue(this.getTrainMetadata().getClassIndex()) == (double)this.execution) {
                    ++coversCount;
                    if (!this.contains(patterns, j)) {
                        ++nPatternsCovered;
                    }
                }
                ++j;
            }
            if (coversCount != 0) {
                double fitness = ((SimpleValueFitness)unitepopulation.get(i).getFitness()).getValue();
                unitepopulation.get(i).setFitness(new SimpleValueFitness(fitness *= (double)nPatternsCovered / (double)coversCount));
                if ((double)nPatternsCovered / (double)coversCount >= this.getSupport()) {
                    esetAux.add(unitepopulation.get(i).copy());
                }
            } else {
                unitepopulation.get(i).setFitness(new SimpleValueFitness(0.0));
            }
            ++i;
        }
        for (IIndividual ind : esetAux) {
            this.eset.add(ind.copy());
        }
        return this.eset;
    }

    protected boolean contains(int[] patterns, int npattern) {
        if (patterns[npattern] == 1) {
            return true;
        }
        patterns[npattern] = 1;
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TanAlgorithm) {
            TanAlgorithm cother = (TanAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        int numIndividuals = this.bset.size();
        int elitistIndividual = (int)Math.round((double)numIndividuals * this.elitistProb);
        ArrayList<IIndividual> bsetAux = new ArrayList<IIndividual>();
        this.cset = new ArrayList();
        List<IIndividual> bsetBest = this.bettersSelector.select(this.bset, this.bset.size());
        int i = 0;
        while (i < elitistIndividual) {
            this.cset.add(bsetBest.get(i));
            ++i;
        }
        int bsetSize = bsetBest.size();
        int i2 = elitistIndividual;
        while (i2 < bsetSize) {
            bsetAux.add(bsetBest.get(i2));
            ++i2;
        }
        this.pset = this.parentsSelector.select(bsetAux, bsetAux.size());
    }

    @Override
    protected void doGeneration() {
        this.rset = this.recombinator.recombine(this.pset);
        this.rset.addAll(this.recombinator.getSterile());
        List<IIndividual> mset = this.mutator.mutate(this.rset);
        mset.addAll(this.mutator.getSterile());
        this.evaluator.evaluate(mset);
        this.cset.addAll(mset);
    }

    @Override
    protected void doReplacement() {
        this.rset = this.bset;
    }

    @Override
    protected void doUpdate() {
        int numIndividuals = this.bset.size();
        this.eset = this.doTokenCompetition(this.cset, this.eset, this.evaluator);
        this.bset = this.cset.size() > numIndividuals ? this.bettersSelector.select(this.cset, numIndividuals) : this.cset;
        int currentNumber = this.bset.size();
        if (currentNumber < numIndividuals) {
            int i = currentNumber;
            while (i < numIndividuals) {
                int numberIndividual = this.getRandGenFactory().createRandGen().choose(0, this.eset.size());
                IIndividual indc = this.eset.get(numberIndividual).copy();
                indc.setFitness(this.eset.get(numberIndividual).getFitness().copy());
                this.bset.add(indc);
                ++i;
            }
        }
        for (IIndividual ind : this.bset) {
            ind.setFitness(null);
        }
        this.evaluator.evaluate(this.bset);
        this.rset = null;
        this.pset = null;
        this.cset = null;
    }

    @Override
    protected void doControl() {
        if (this.generation >= this.maxOfGenerations) {
            ++this.execution;
            int esetSize = this.eset.size();
            int i = 0;
            while (i < esetSize) {
                ((Individual)this.eset.get(i)).getPhenotype().setConsequent(this.execution - 1);
                this.classifier.addClassificationRule(((Individual)this.eset.get(i)).getPhenotype());
                ++i;
            }
            if (this.execution == this.classesNumber) {
                this.state = 3;
                this.classifier.sortClassifier(this.getTrainSet());
                return;
            }
            ((TanEvaluator)this.evaluator).setClassifiedClass(this.execution);
            this.eset.clear();
            this.generation = 0;
            this.doInit();
        }
        for (IIndividual individual : this.bset) {
            if (!individual.getFitness().isAcceptable()) continue;
            ++this.execution;
            IIndividual best = this.bettersSelector.select(this.bset, 1).get(0);
            IClassificationRule phenotype = ((Individual)best).getPhenotype();
            if (this.execution == this.classesNumber) {
                phenotype.setConsequent(this.execution - 1);
                this.classifier.addClassificationRule(phenotype);
                this.state = 3;
                return;
            }
            this.classifier.addClassificationRule(phenotype);
            ((FalcoEvaluator)this.evaluator).setClassifiedClass(this.execution);
            this.doInit();
            this.generation = 0;
        }
    }
}

