/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import java.io.Serializable;

public class SingleIndex
implements Serializable {
    static final long serialVersionUID = 5285169134430839303L;
    protected String m_IndexString = "";
    protected int m_SelectedIndex = -1;
    protected int m_Upper = -1;

    public SingleIndex() {
    }

    public SingleIndex(String index) {
        this.setSingleIndex(index);
    }

    public void setUpper(int newUpper) {
        if (newUpper >= 0) {
            this.m_Upper = newUpper;
            this.setValue();
        }
    }

    public String getSingleIndex() {
        return this.m_IndexString;
    }

    public void setSingleIndex(String index) {
        this.m_IndexString = index;
        this.m_SelectedIndex = -1;
    }

    public String toString() {
        if (this.m_IndexString.equals("")) {
            return "No index set";
        }
        if (this.m_Upper == -1) {
            throw new RuntimeException("Upper limit has not been specified");
        }
        return this.m_IndexString;
    }

    public int getIndex() {
        if (this.m_IndexString.equals("")) {
            throw new RuntimeException("No index set");
        }
        if (this.m_Upper == -1) {
            throw new RuntimeException("No upper limit has been specified for index");
        }
        return this.m_SelectedIndex;
    }

    public static String indexToString(int index) {
        return "" + (index + 1);
    }

    protected void setValue() {
        if (this.m_IndexString.equals("")) {
            throw new RuntimeException("No index set");
        }
        if (this.m_IndexString.toLowerCase().equals("first")) {
            this.m_SelectedIndex = 0;
        } else if (this.m_IndexString.toLowerCase().equals("last")) {
            this.m_SelectedIndex = this.m_Upper;
        } else {
            this.m_SelectedIndex = Integer.parseInt(this.m_IndexString) - 1;
            if (this.m_SelectedIndex < 0) {
                this.m_IndexString = "";
                throw new IllegalArgumentException("Index must be greater than zero");
            }
            if (this.m_SelectedIndex > this.m_Upper) {
                this.m_IndexString = "";
                throw new IllegalArgumentException("Index is too large");
            }
        }
    }
}

