/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Instance_Selection.EUSCHCQstat;

import java.util.Arrays;
import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Basic.KNN;
import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Basic.Metodo;
import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Basic.OutputIS;
import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Instance_Selection.EUSCHCQstat.Chromosome;
import keel.Algorithms.ImbalancedClassification.Ensembles.parseParameters;
import org.core.Randomize;

public class EUSCHCQstat
extends Metodo {
    private long seed;
    private int popSize;
    private int nEval;
    private double r;
    private double prob0to1Rec;
    private double prob0to1Div;
    private double P;
    private int k;
    private String evMeas;
    private boolean majSelection;
    private boolean pFactor;
    private String hybrid;
    private int kSMOTE;
    private int ASMO;
    private double smoting;
    private boolean balance;
    private String wrapper;
    private boolean[][] anteriores;
    private boolean[][] salidasAnteriores;
    private boolean[] best;
    private boolean[] bestOutputs;

    public EUSCHCQstat(String ficheroScript) {
        super(ficheroScript);
    }

    public void setAnteriores(boolean[][] anteriores) {
        this.anteriores = anteriores;
    }

    public void setSalidasAnteriores(boolean[][] anteriores) {
        this.salidasAnteriores = anteriores;
    }

    public boolean[] getBest() {
        return this.best;
    }

    public boolean[] getBestOutputs() {
        return this.bestOutputs;
    }

    @Override
    public void runAlgorithm() {
        int[] clasesS;
        boolean[][] conjM;
        int[][] conjN;
        double[][] conjR;
        double[][] conjS;
        int l;
        int j;
        int[] clasesArt;
        boolean[][] nulosArt;
        int[][] nominalArt;
        double[][] realArt;
        double[][] datosArt;
        int tamS;
        int tmp;
        int i;
        int nSel = 0;
        int ev = 0;
        int nPos = 0;
        int nNeg = 0;
        long tiempo = System.currentTimeMillis();
        int posID = this.clasesTrain[0];
        int negID = -1;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] == posID) continue;
            negID = this.clasesTrain[i];
            break;
        }
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] == posID) {
                ++nPos;
                continue;
            }
            ++nNeg;
        }
        if (nPos > nNeg) {
            tmp = nPos;
            nPos = nNeg;
            nNeg = tmp;
            tmp = posID;
            posID = negID;
            negID = tmp;
        }
        if (this.hybrid.equalsIgnoreCase("smote + eus")) {
            tamS = this.balance ? 2 * nNeg : nNeg + nPos + (int)((double)nPos * this.smoting);
            datosArt = new double[tamS][this.datosTrain[0].length];
            realArt = new double[tamS][this.datosTrain[0].length];
            nominalArt = new int[tamS][this.datosTrain[0].length];
            nulosArt = new boolean[tamS][this.datosTrain[0].length];
            clasesArt = new int[tamS];
            this.SMOTE(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, datosArt, realArt, nominalArt, nulosArt, clasesArt, this.kSMOTE, this.ASMO, this.smoting, this.balance, nPos, posID, nNeg, negID, this.distanceEu);
        } else {
            datosArt = new double[this.datosTrain.length][this.datosTrain[0].length];
            realArt = new double[this.datosTrain.length][this.datosTrain[0].length];
            nominalArt = new int[this.datosTrain.length][this.datosTrain[0].length];
            nulosArt = new boolean[this.datosTrain.length][this.datosTrain[0].length];
            clasesArt = new int[this.clasesTrain.length];
            for (i = 0; i < this.datosTrain.length; ++i) {
                for (j = 0; j < this.datosTrain[i].length; ++j) {
                    datosArt[i][j] = this.datosTrain[i][j];
                    realArt[i][j] = this.realTrain[i][j];
                    nominalArt[i][j] = this.nominalTrain[i][j];
                    nulosArt[i][j] = this.nulosTrain[i][j];
                }
                clasesArt[i] = this.clasesTrain[i];
            }
        }
        nNeg = 0;
        nPos = 0;
        for (i = 0; i < clasesArt.length; ++i) {
            if (clasesArt[i] == posID) {
                ++nPos;
                continue;
            }
            ++nNeg;
        }
        int d = this.majSelection ? nNeg / 4 : datosArt.length / 4;
        Object[] poblacion = new Chromosome[this.popSize];
        int[] baraje = new int[this.popSize];
        for (i = 0; i < this.popSize; ++i) {
            poblacion[i] = this.majSelection ? new Chromosome(nNeg) : new Chromosome(datosArt.length);
        }
        for (i = 0; i < this.popSize; ++i) {
            poblacion[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, datosArt, realArt, nominalArt, nulosArt, clasesArt, this.wrapper, this.k, this.evMeas, this.majSelection, this.pFactor, this.P, posID, nPos, this.distanceEu, this.entradas, this.anteriores, this.salidasAnteriores);
        }
        while (ev < this.nEval) {
            Chromosome[] C = new Chromosome[this.popSize];
            for (i = 0; i < this.popSize; ++i) {
                baraje[i] = i;
            }
            for (i = 0; i < this.popSize; ++i) {
                int pos = Randomize.Randint(i, this.popSize - 1);
                tmp = baraje[i];
                baraje[i] = baraje[pos];
                baraje[pos] = tmp;
            }
            for (i = 0; i < this.popSize; ++i) {
                C[i] = this.majSelection ? new Chromosome(nNeg, (Chromosome)poblacion[baraje[i]]) : new Chromosome(datosArt.length, (Chromosome)poblacion[baraje[i]]);
            }
            int tamC = this.recombinar(C, d, nNeg, nPos, this.majSelection);
            Object[] newPob = new Chromosome[tamC];
            l = 0;
            for (i = 0; i < C.length; ++i) {
                if (!C[i].esValido()) continue;
                newPob[l] = this.majSelection ? new Chromosome(nNeg, C[i]) : new Chromosome(datosArt.length, C[i]);
                ++l;
            }
            for (i = 0; i < newPob.length; ++i) {
                newPob[i].evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, datosArt, realArt, nominalArt, nulosArt, clasesArt, this.wrapper, this.k, this.evMeas, this.majSelection, this.pFactor, this.P, posID, nPos, this.distanceEu, this.entradas, this.anteriores, this.salidasAnteriores);
                ++ev;
            }
            Arrays.sort(poblacion);
            Arrays.sort(newPob);
            if (tamC == 0 || ((Chromosome)newPob[0]).getCalidad() < ((Chromosome)poblacion[this.popSize - 1]).getCalidad()) {
                --d;
            } else {
                Chromosome[] pobTemp = new Chromosome[this.popSize];
                j = 0;
                l = 0;
                for (i = 0; i < this.popSize && l < tamC; ++i) {
                    if (((Chromosome)poblacion[j]).getCalidad() > ((Chromosome)newPob[l]).getCalidad()) {
                        pobTemp[i] = this.majSelection ? new Chromosome(nNeg, (Chromosome)poblacion[j]) : new Chromosome(datosArt.length, (Chromosome)poblacion[j]);
                        ++j;
                        continue;
                    }
                    pobTemp[i] = this.majSelection ? new Chromosome(nNeg, (Chromosome)newPob[l]) : new Chromosome(datosArt.length, (Chromosome)newPob[l]);
                    ++l;
                }
                if (l == tamC) {
                    while (i < this.popSize) {
                        pobTemp[i] = this.majSelection ? new Chromosome(nNeg, (Chromosome)poblacion[j]) : new Chromosome(datosArt.length, (Chromosome)poblacion[j]);
                        ++j;
                        ++i;
                    }
                }
                poblacion = pobTemp;
            }
            if (d > 0) continue;
            for (i = 1; i < this.popSize; ++i) {
                ((Chromosome)poblacion[i]).divergeCHC(this.r, (Chromosome)poblacion[0], this.prob0to1Div);
            }
            for (i = 0; i < this.popSize; ++i) {
                if (((Chromosome)poblacion[i]).estaEvaluado()) continue;
                ((Chromosome)poblacion[i]).evalua(this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, datosArt, realArt, nominalArt, nulosArt, clasesArt, this.wrapper, this.k, this.evMeas, this.majSelection, this.pFactor, this.P, posID, nPos, this.distanceEu, this.entradas, this.anteriores, this.salidasAnteriores);
                ++ev;
            }
            if (this.majSelection) {
                d = (int)(this.r * (1.0 - this.r) * (double)nNeg);
                continue;
            }
            d = (int)(this.r * (1.0 - this.r) * (double)datosArt.length);
        }
        Arrays.sort(poblacion);
        if (this.majSelection) {
            nSel = ((Chromosome)poblacion[0]).genesActivos() + nPos;
            conjS = new double[nSel][datosArt[0].length];
            conjR = new double[nSel][datosArt[0].length];
            conjN = new int[nSel][datosArt[0].length];
            conjM = new boolean[nSel][datosArt[0].length];
            clasesS = new int[nSel];
            int h = 0;
            i = 0;
            l = 0;
            while (i < nNeg) {
                while (clasesArt[h] == posID && h < clasesArt.length) {
                    ++h;
                }
                if (((Chromosome)poblacion[0]).getGen(i)) {
                    for (j = 0; j < datosArt[h].length; ++j) {
                        conjS[l][j] = datosArt[h][j];
                        conjR[l][j] = realArt[h][j];
                        conjN[l][j] = nominalArt[h][j];
                        conjM[l][j] = nulosArt[h][j];
                    }
                    clasesS[l] = clasesArt[h];
                    ++l;
                }
                ++i;
                ++h;
            }
            for (i = 0; i < datosArt.length; ++i) {
                if (clasesArt[i] != posID) continue;
                for (j = 0; j < datosArt[i].length; ++j) {
                    conjS[l][j] = datosArt[i][j];
                    conjR[l][j] = realArt[i][j];
                    conjN[l][j] = nominalArt[i][j];
                    conjM[l][j] = nulosArt[i][j];
                }
                clasesS[l] = clasesArt[i];
                ++l;
            }
        } else {
            nSel = ((Chromosome)poblacion[0]).genesActivos();
            conjS = new double[nSel][datosArt[0].length];
            conjR = new double[nSel][datosArt[0].length];
            conjN = new int[nSel][datosArt[0].length];
            conjM = new boolean[nSel][datosArt[0].length];
            clasesS = new int[nSel];
            l = 0;
            for (i = 0; i < datosArt.length; ++i) {
                if (!((Chromosome)poblacion[0]).getGen(i)) continue;
                for (j = 0; j < datosArt[i].length; ++j) {
                    conjS[l][j] = datosArt[i][j];
                    conjR[l][j] = realArt[i][j];
                    conjN[l][j] = nominalArt[i][j];
                    conjM[l][j] = nulosArt[i][j];
                }
                clasesS[l] = clasesArt[i];
                ++l;
            }
        }
        if (this.hybrid.equalsIgnoreCase("eus + smote")) {
            nNeg = 0;
            nPos = 0;
            for (i = 0; i < clasesS.length; ++i) {
                if (clasesS[i] == posID) {
                    ++nPos;
                    continue;
                }
                ++nNeg;
            }
            if (nPos < nNeg) {
                tamS = this.balance ? 2 * nNeg : nNeg + nPos + (int)((double)nPos * this.smoting);
                datosArt = new double[tamS][this.datosTrain[0].length];
                realArt = new double[tamS][this.datosTrain[0].length];
                nominalArt = new int[tamS][this.datosTrain[0].length];
                nulosArt = new boolean[tamS][this.datosTrain[0].length];
                clasesArt = new int[tamS];
                this.SMOTE(conjS, conjR, conjN, conjM, clasesS, datosArt, realArt, nominalArt, nulosArt, clasesArt, this.kSMOTE, this.ASMO, this.smoting, this.balance, nPos, posID, nNeg, negID, this.distanceEu);
                nSel = datosArt.length;
                conjS = new double[nSel][datosArt[0].length];
                conjR = new double[nSel][datosArt[0].length];
                conjN = new int[nSel][datosArt[0].length];
                conjM = new boolean[nSel][datosArt[0].length];
                clasesS = new int[nSel];
                for (i = 0; i < datosArt.length; ++i) {
                    for (j = 0; j < datosArt[i].length; ++j) {
                        conjS[i][j] = datosArt[i][j];
                        conjR[i][j] = realArt[i][j];
                        conjN[i][j] = nominalArt[i][j];
                        conjM[i][j] = nulosArt[i][j];
                    }
                    clasesS[i] = clasesArt[i];
                }
            }
        }
        this.best = (boolean[])((Chromosome)poblacion[0]).cuerpo.clone();
        this.bestOutputs = (boolean[])((Chromosome)poblacion[0]).prediction.clone();
        System.out.println("QstatEUSCHC " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida(this.ficheroSalida[0], conjR, conjN, conjM, clasesS, this.entradas, this.salida, this.nEntradas, this.relation);
    }

    private int recombinar(Chromosome[] C, int d, int nNeg, int nPos, boolean majSelection) {
        int tamC = 0;
        int n = majSelection ? nNeg : nNeg + nPos;
        for (int i = 0; i < C.length / 2; ++i) {
            int j;
            int distHamming = 0;
            for (j = 0; j < n; ++j) {
                if (C[i * 2].getGen(j) == C[i * 2 + 1].getGen(j)) continue;
                ++distHamming;
            }
            if (distHamming / 2 > d) {
                for (j = 0; j < n; ++j) {
                    if (C[i * 2].getGen(j) == C[i * 2 + 1].getGen(j) || !(Randomize.Rand() < 0.5)) continue;
                    if (C[i * 2].getGen(j)) {
                        C[i * 2].setGen(j, false);
                    } else if (Randomize.Rand() < this.prob0to1Rec) {
                        C[i * 2].setGen(j, true);
                    }
                    if (C[i * 2 + 1].getGen(j)) {
                        C[i * 2 + 1].setGen(j, false);
                        continue;
                    }
                    if (!(Randomize.Rand() < this.prob0to1Rec)) continue;
                    C[i * 2 + 1].setGen(j, true);
                }
                tamC += 2;
                continue;
            }
            C[i * 2].borrar();
            C[i * 2 + 1].borrar();
        }
        return tamC;
    }

    public void SMOTE(double[][] datosTrain, double[][] realTrain, int[][] nominalTrain, boolean[][] nulosTrain, int[] clasesTrain, double[][] datosArt, double[][] realArt, int[][] nominalArt, boolean[][] nulosArt, int[] clasesArt, int kSMOTE, int ASMO, double smoting, boolean balance, int nPos, int posID, int nNeg, int negID, boolean distanceEu) {
        int l;
        int[] clasesGen;
        boolean[][] genM;
        int[][] genN;
        double[][] genR;
        double[][] genS;
        int i;
        int[] positives = new int[nPos];
        int j = 0;
        for (i = 0; i < clasesTrain.length; ++i) {
            if (clasesTrain[i] != posID) continue;
            positives[j] = i;
            ++j;
        }
        for (i = 0; i < positives.length; ++i) {
            int tmp = positives[i];
            int pos = Randomize.Randint(0, positives.length - 1);
            positives[i] = positives[pos];
            positives[pos] = tmp;
        }
        int[][] neighbors = new int[positives.length][kSMOTE];
        block7: for (i = 0; i < positives.length; ++i) {
            switch (ASMO) {
                case 0: {
                    KNN.evaluacionKNN2(kSMOTE, datosTrain, realTrain, nominalTrain, nulosTrain, clasesTrain, datosTrain[positives[i]], realTrain[positives[i]], nominalTrain[positives[i]], nulosTrain[positives[i]], Math.max(posID, negID) + 1, distanceEu, neighbors[i]);
                    continue block7;
                }
                case 1: {
                    EUSCHCQstat.evaluacionKNNClass(kSMOTE, datosTrain, realTrain, nominalTrain, nulosTrain, clasesTrain, datosTrain[positives[i]], realTrain[positives[i]], nominalTrain[positives[i]], nulosTrain[positives[i]], Math.max(posID, negID) + 1, distanceEu, neighbors[i], posID);
                    continue block7;
                }
                case 2: {
                    EUSCHCQstat.evaluacionKNNClass(kSMOTE, datosTrain, realTrain, nominalTrain, nulosTrain, clasesTrain, datosTrain[positives[i]], realTrain[positives[i]], nominalTrain[positives[i]], nulosTrain[positives[i]], Math.max(posID, negID) + 1, distanceEu, neighbors[i], negID);
                }
            }
        }
        if (balance) {
            genS = new double[nNeg - nPos][datosTrain[0].length];
            genR = new double[nNeg - nPos][datosTrain[0].length];
            genN = new int[nNeg - nPos][datosTrain[0].length];
            genM = new boolean[nNeg - nPos][datosTrain[0].length];
            clasesGen = new int[nNeg - nPos];
        } else {
            genS = new double[(int)((double)nPos * smoting)][datosTrain[0].length];
            genR = new double[(int)((double)nPos * smoting)][datosTrain[0].length];
            genN = new int[(int)((double)nPos * smoting)][datosTrain[0].length];
            genM = new boolean[(int)((double)nPos * smoting)][datosTrain[0].length];
            clasesGen = new int[(int)((double)nPos * smoting)];
        }
        for (i = 0; i < genS.length; ++i) {
            clasesGen[i] = posID;
            int nn = Randomize.Randint(0, kSMOTE - 1);
            this.interpola(realTrain[positives[i % positives.length]], realTrain[neighbors[i % positives.length][nn]], nominalTrain[positives[i % positives.length]], nominalTrain[neighbors[i % positives.length][nn]], nulosTrain[positives[i % positives.length]], nulosTrain[neighbors[i % positives.length][nn]], genS[i], genR[i], genN[i], genM[i]);
        }
        for (j = 0; j < datosTrain.length; ++j) {
            for (l = 0; l < datosTrain[0].length; ++l) {
                datosArt[j][l] = datosTrain[j][l];
                realArt[j][l] = realTrain[j][l];
                nominalArt[j][l] = nominalTrain[j][l];
                nulosArt[j][l] = nulosTrain[j][l];
            }
            clasesArt[j] = clasesTrain[j];
        }
        int m = 0;
        while (j < datosArt.length) {
            for (l = 0; l < datosTrain[0].length; ++l) {
                datosArt[j][l] = genS[m][l];
                realArt[j][l] = genR[m][l];
                nominalArt[j][l] = genN[m][l];
                nulosArt[j][l] = genM[m][l];
            }
            clasesArt[j] = clasesGen[m];
            ++j;
            ++m;
        }
    }

    public static int evaluacionKNNClass(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance, int[] vecinos, int clase) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0) || clases[i] != clase) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        for (i = 0; i < vecinosCercanos.length; ++i) {
            vecinos[i] = vecinosCercanos[i];
        }
        return votada;
    }

    private void interpola(double[] ra, double[] rb, int[] na, int[] nb, boolean[] ma, boolean[] mb, double[] resS, double[] resR, int[] resN, boolean[] resM) {
        for (int i = 0; i < ra.length; ++i) {
            double gap;
            double diff;
            if (ma[i] && mb[i]) {
                resM[i] = true;
                resS[i] = 0.0;
                continue;
            }
            resM[i] = false;
            if (this.entradas[i].getType() == 2) {
                diff = rb[i] - ra[i];
                gap = Randomize.Rand();
                resR[i] = ra[i] + gap * diff;
                resS[i] = (ra[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                continue;
            }
            if (this.entradas[i].getType() == 1) {
                diff = rb[i] - ra[i];
                gap = Randomize.Rand();
                resR[i] = Math.round(ra[i] + gap * diff);
                resS[i] = (ra[i] + this.entradas[i].getMinAttribute()) / (this.entradas[i].getMaxAttribute() - this.entradas[i].getMinAttribute());
                continue;
            }
            int suerte = Randomize.Randint(0, 2);
            resN[i] = suerte == 0 ? na[i] : nb[i];
            resS[i] = (double)resN[i] / (double)(this.entradas[i].getNominalValuesList().size() - 1);
        }
    }

    @Override
    public void readConfiguration(String ficheroScript) {
        parseParameters param = new parseParameters();
        param.parseConfigurationFile(ficheroScript);
        this.ficheroTraining = param.getTrainingInputFile();
        this.ficheroTest = param.getTestInputFile();
        this.ficheroSalida = new String[2];
        this.ficheroSalida[0] = param.getTrainingOutputFile();
        this.ficheroSalida[1] = param.getTestOutputFile();
        int i = 0;
        this.seed = Long.parseLong(param.getParameter(i++));
        this.popSize = Integer.parseInt(param.getParameter(i++));
        this.nEval = Integer.parseInt(param.getParameter(i++));
        this.r = Double.parseDouble(param.getParameter(i++));
        this.prob0to1Rec = Double.parseDouble(param.getParameter(i++));
        this.prob0to1Div = Double.parseDouble(param.getParameter(i++));
        this.wrapper = param.getParameter(i++);
        this.k = Integer.parseInt(param.getParameter(i++));
        this.distanceEu = param.getParameter(i++).equalsIgnoreCase("Euclidean");
        this.evMeas = param.getParameter(i++);
        this.majSelection = param.getParameter(i++).equalsIgnoreCase("majority_selection");
        this.pFactor = param.getParameter(i++).equalsIgnoreCase("EBUS");
        this.P = Double.parseDouble(param.getParameter(i++));
        this.hybrid = param.getParameter(i++);
        this.kSMOTE = Integer.parseInt(param.getParameter(i++));
        this.ASMO = param.getParameter(i).equalsIgnoreCase("both") ? 0 : (param.getParameter(i).equalsIgnoreCase("minority") ? 1 : 2);
        int n = ++i;
        ++i;
        this.balance = param.getParameter(n).equalsIgnoreCase("YES");
        this.smoting = Double.parseDouble(param.getParameter(i++));
    }
}

