/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.RSP;

import java.util.ArrayList;
import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class RSPGenerator
extends PrototypeGenerator {
    private int numberOfBlocks;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;
    private String Subset_choice = "diameter";

    public RSPGenerator(PrototypeSet _trainingDataSet, int blocks, String choice) {
        super(_trainingDataSet);
        this.algorithmName = "RSP";
        this.numberOfBlocks = blocks;
        this.Subset_choice = choice;
    }

    public RSPGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "RSP";
        this.numberOfBlocks = parameters.getNextAsInt();
        this.Subset_choice = parameters.getNextAsString();
        System.out.println("Isaac dice: numberOFblock= " + this.numberOfBlocks + " choice = " + this.Subset_choice);
    }

    protected PrototypeSet ENN(PrototypeSet T) {
        PrototypeSet Sew = new PrototypeSet(T);
        int majority = 2;
        int[] toClean = new int[T.size()];
        Arrays.fill(toClean, 0);
        int pos = 0;
        for (Prototype p : T) {
            double class_p = p.getOutput(0);
            PrototypeSet neighbors = KNN.knn(p, this.trainingDataSet, 3);
            int counter = 0;
            for (Prototype q1 : neighbors) {
                double class_q1 = q1.getOutput(0);
                if (class_q1 != class_p) continue;
                ++counter;
            }
            if (counter < majority) {
                toClean[pos] = 1;
            }
            ++pos;
        }
        PrototypeSet aux = new PrototypeSet();
        for (int i = 0; i < toClean.length; ++i) {
            if (toClean[i] != 0) continue;
            aux.add(T.get(i));
        }
        Sew = aux;
        return Sew;
    }

    @Override
    public PrototypeSet reduceSet() {
        int bc;
        int i;
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.print("\nEditing algorithm is needed...\n Computing...\n");
        this.trainingDataSet = new PrototypeSet(this.ENN(this.trainingDataSet));
        if (this.numberOfBlocks == 0) {
            System.out.println("Executing RSP3 with " + this.Subset_choice);
        } else if (this.Subset_choice == "diameter") {
            System.out.println("Executing RSP2");
        } else {
            System.out.println("Executing RSP1");
        }
        ArrayList<PrototypeSet> C = new ArrayList<PrototypeSet>(this.numberOfBlocks);
        PrototypeSet B = new PrototypeSet(this.trainingDataSet.clone());
        for (i = 0; i < B.size(); ++i) {
            ((Prototype)B.get(i)).setIndex(i);
        }
        i = 0;
        Prototype p1 = B.farthestPrototypes().first();
        Prototype p2 = B.farthestPrototypes().second();
        boolean everyHomogenity = false;
        boolean rsp3 = false;
        if (this.numberOfBlocks == 0) {
            rsp3 = true;
        }
        for (bc = 1; bc < this.numberOfBlocks || rsp3 && !everyHomogenity; ++bc) {
            Pair<PrototypeSet, PrototypeSet> Di = B.partIntoSubsetsWhichSeedPointsAre(p1.formatear(), p2.formatear());
            C.remove(B);
            PrototypeSet D1 = Di.first();
            PrototypeSet D2 = Di.second();
            C.add(D1);
            C.add(D2);
            if (rsp3) {
                everyHomogenity = true;
                for (PrototypeSet pSet : C) {
                    if (pSet.homogeneity()) continue;
                    everyHomogenity = false;
                }
            }
            ArrayList<PrototypeSet> I = null;
            ArrayList<PrototypeSet> I1 = new ArrayList<PrototypeSet>();
            ArrayList<PrototypeSet> I2 = new ArrayList<PrototypeSet>();
            for (PrototypeSet pSet : C) {
                if (pSet.containsSeveralClasses()) {
                    I1.add(pSet);
                    continue;
                }
                I2.add(pSet);
            }
            I = I1.size() != 0 ? I1 : I2;
            double distMax = -1.0;
            PrototypeSet Cj = (PrototypeSet)I.get(0);
            Pair<Prototype, Prototype> diameterPoints = null;
            for (PrototypeSet q : I) {
                if (q.size() <= 1) continue;
                Pair<Prototype, Prototype> farthest = q.farthestPrototypes();
                double curDist = this.Subset_choice == "diameter" ? Distance.d(farthest.first().formatear(), farthest.second().formatear()) : q.Overlapping();
                if (!(distMax < curDist)) continue;
                distMax = curDist;
                Cj = q;
                diameterPoints = farthest;
            }
            B = Cj;
            if (diameterPoints != null) {
                p1 = (Prototype)diameterPoints.first();
                p2 = (Prototype)diameterPoints.second();
                continue;
            }
            everyHomogenity = true;
        }
        Prototype cfr_ignored_0 = (Prototype)this.trainingDataSet.get(0);
        int numberOfClass = Prototype.possibleValuesOfOutput().size();
        PrototypeSet result = new PrototypeSet();
        for (i = 0; i < bc; ++i) {
            for (int j = 0; j < numberOfClass; ++j) {
                PrototypeSet aux = ((PrototypeSet)C.get(i)).getFromClass(j);
                if (aux.size() <= 0) continue;
                Prototype averaged = aux.avg();
                result.add(averaged.formatear());
            }
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(result);
        this.numberOfPrototypes = result.size();
        System.err.println("\n% de acierto en training Nominal " + RSPGenerator.accuracy(nominalPopulation, this.trainingDataSet));
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("RSP", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        RSPGenerator.setSeed(seed);
        int blocks = Parameters.assertExtendedArgAsInt(args, 10, "number of blocks", 1.0, 2.147483647E9);
        RSPGenerator generator = new RSPGenerator(training, blocks, "diameter");
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

