/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Transformations.Nominal2Binary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class Nominal2Binary {
    double tempData = 0.0;
    String[][] X = null;
    int ndatos = 0;
    int nentradas = 0;
    int tipo = 0;
    int direccion = 0;
    int nvariables = 0;
    int nsalidas = 0;
    InstanceSet IS;
    String input_train_name = new String();
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public Nominal2Binary(String fileParam) {
        this.config_read(fileParam);
        this.IS = new InstanceSet();
    }

    public void transform() {
        InstanceSet transformed = null;
        try {
            this.IS.readSet(this.input_train_name, true);
            transformed = this.convertNominal2Binary(this.IS);
        }
        catch (Exception e) {
            System.out.println("Nominal2Binary exception = " + e);
            e.printStackTrace();
            System.exit(1);
        }
        this.write_results(this.output_train_name, transformed);
        if (this.input_train_name.compareTo(this.input_test_name) != 0) {
            try {
                this.IS.readSet(this.input_test_name, false);
                transformed = this.convertNominal2Binary(this.IS);
            }
            catch (Exception e) {
                System.out.println("Nominal2Binary exception = " + e);
                e.printStackTrace();
                System.exit(1);
            }
            this.write_results(this.output_test_name, transformed);
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            file_reader.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    private void write_results(String output, InstanceSet transformed) {
        try {
            FileWriter file_write = new FileWriter(output);
            file_write.write(transformed.getNewHeader());
            file_write.write("@data\n");
            for (int i = 0; i < transformed.getNumInstances(); ++i) {
                Instance inst = transformed.getInstance(i);
                file_write.write(inst.toString(transformed.getAttributeDefinitions()));
                file_write.write("\n");
            }
            file_write.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            System.exit(-1);
        }
    }

    public InstanceSet convertNominal2Binary(InstanceSet is) {
        int j;
        Attribute a;
        int i;
        int out = Attributes.getInputNumAttributes();
        int newNumAttributes = 0;
        Vector<Attribute> atts = new Vector<Attribute>(Attributes.getNumAttributes());
        for (i = 0; i < Attributes.getNumAttributes(); ++i) {
            a = Attributes.getAttribute(i);
            if (a.getType() == 0 && a.getDirectionAttribute() != 2) {
                Attribute newAt;
                if (a.getNumNominalValues() > 2) {
                    newNumAttributes += a.getNumNominalValues();
                    for (j = 0; j < a.getNumNominalValues(); ++j) {
                        newAt = new Attribute();
                        newAt.setType(1);
                        newAt.setDirectionAttribute(a.getDirectionAttribute());
                        newAt.setName(a.getName() + "=" + a.getNominalValue(j));
                        newAt.enlargeBounds(0.0);
                        newAt.enlargeBounds(1.0);
                        atts.addElement(newAt);
                    }
                } else {
                    ++newNumAttributes;
                    newAt = new Attribute();
                    newAt.setType(1);
                    newAt.setDirectionAttribute(a.getDirectionAttribute());
                    newAt.setName(a.getName());
                    newAt.enlargeBounds(0.0);
                    newAt.enlargeBounds(1.0);
                    atts.addElement(newAt);
                }
            }
            if (a.getType() != 0) {
                ++newNumAttributes;
                atts.addElement(a);
            }
            if (a.getDirectionAttribute() != 2) continue;
            atts.addElement(a);
            out = newNumAttributes++;
        }
        InstanceSet data = new InstanceSet(true);
        for (i = 0; i < atts.size(); ++i) {
            data.addAttribute((Attribute)atts.get(i));
        }
        for (i = 0; i < is.getNumInstances(); ++i) {
            Instance instK = is.getInstance(i);
            out = 0;
            int in = 0;
            int enlargedValueVectorPos = 0;
            double[] values = new double[newNumAttributes];
            for (j = 0; j < Attributes.getNumAttributes(); ++j) {
                a = Attributes.getAttribute(j);
                if (a.getDirectionAttribute() == 1) {
                    if (a.getType() == 0) {
                        if (a.getNumNominalValues() > 2) {
                            for (int k = 0; k < a.getNumNominalValues(); ++k) {
                                if (instK.getInputMissingValues(in) || a.getNominalValue(k).compareTo(instK.getInputNominalValues(in)) != 0) continue;
                                values[enlargedValueVectorPos + k] = 1.0;
                            }
                            enlargedValueVectorPos += a.getNumNominalValues();
                        } else {
                            values[enlargedValueVectorPos] = instK.getAllInputValues()[in];
                            ++enlargedValueVectorPos;
                        }
                    } else {
                        values[enlargedValueVectorPos] = instK.getAllInputValues()[in];
                        ++enlargedValueVectorPos;
                    }
                    ++in;
                    continue;
                }
                values[enlargedValueVectorPos] = instK.getAllOutputValues()[out];
                ++out;
                ++enlargedValueVectorPos;
            }
            Instance instW = new Instance(values, data.getAttributeDefinitions());
            data.addInstance(instW);
        }
        return data;
    }
}

