/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AbstractAttribute;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.AttributeType;
import net.sf.jclec.util.intset.Closure;
import net.sf.jclec.util.intset.Interval;

public class CategoricalAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = 1L;
    protected int numCategories = 0;
    protected Hashtable htRealValue = new Hashtable();
    protected Hashtable htDoubleValue = new Hashtable();
    protected List<String> categories = new ArrayList<String>();
    protected List<Double> doubleValues = new ArrayList<Double>();
    protected double lastValue = 0.0;

    public int getNumberCategories() {
        return this.numCategories;
    }

    public void setNumberCategories(int numCategories) {
        this.numCategories = numCategories;
    }

    public void addValue(Object newValue) {
        if (!this.categories.contains(newValue)) {
            this.lastValue += 1.0;
            ++this.numCategories;
            this.categories.add((String)newValue);
            this.htRealValue.put(newValue, new Double(this.lastValue));
            this.htDoubleValue.put(new Double(this.lastValue), newValue);
        }
    }

    @Override
    public AttributeType getType() {
        return AttributeType.Categorical;
    }

    @Override
    public boolean isValid(double internalValue) {
        return this.htDoubleValue.containsKey(internalValue);
    }

    @Override
    public boolean isValid(Object externalValue) {
        return this.htRealValue.containsKey(externalValue);
    }

    @Override
    public double parse(String externalValue) {
        if (this.htRealValue.containsKey(externalValue)) {
            return (Double)this.htRealValue.get(externalValue);
        }
        return -1.0;
    }

    @Override
    public String show(double internalValue) {
        if (this.htDoubleValue.containsKey(new Double(internalValue))) {
            return (String)this.htDoubleValue.get(new Double(internalValue));
        }
        return null;
    }

    public Interval intervalValues() {
        Interval interval = new Interval(1, this.numCategories, Closure.ClosedClosed);
        return interval;
    }
}

