/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.realarray.RealArrayIndividual;
import net.sourceforge.jclec.realarray.RealArrayMutator;
import org.apache.commons.configuration.Configuration;

public abstract class UniformMutator
extends RealArrayMutator
implements IConfigure {
    protected double locusMutProb;

    public double getLocusMutProb() {
        return this.locusMutProb;
    }

    public void setLocusMutProb(double locusMutProb) {
        this.locusMutProb = locusMutProb;
    }

    @Override
    public void configure(Configuration settings) {
        double locusMutProb = settings.getDouble("[@locus-mut-prob]", this.defaultLocusMutProb());
        this.setLocusMutProb(locusMutProb);
    }

    @Override
    protected void mutateNext() {
        RealArrayIndividual ind = (RealArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        double[] parentChromosome = (double[])ind.getGenotype();
        double[] mutantChromosome = new double[this.genotypeLength];
        int i = 0;
        while (i < this.genotypeLength) {
            if (this.randgen.coin(this.locusMutProb)) {
                this.doLocusMutation(parentChromosome, mutantChromosome, i);
            } else {
                mutantChromosome[i] = parentChromosome[i];
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(mutantChromosome));
    }

    protected abstract void doLocusMutation(double[] var1, double[] var2, int var3);

    protected abstract double defaultLocusMutProb();
}

