/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.PART;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.PART.Mask;
import keel.Algorithms.Rule_Learning.PART.MyDataset;
import keel.Algorithms.Rule_Learning.PART.SimpleRule;
import keel.Algorithms.Rule_Learning.PART.Stats;

public class Rule {
    public static int GREATER = SimpleRule.GREATER;
    public static int LOWER = SimpleRule.LOWER;
    public static int EQUAL = SimpleRule.EQUAL;
    private Vector chain = new Vector();
    private String type = "";

    private boolean contains(SimpleRule sr) {
        boolean is_contained = false;
        for (int i = 0; i < this.chain.size() && !is_contained; ++i) {
            is_contained = sr.isEqual((SimpleRule)this.chain.elementAt(i));
        }
        return is_contained;
    }

    public int apply(MyDataset data, Mask select, int ignore) {
        int output = 0;
        select.resetIndex();
        while (select.next()) {
            double[] exemple = data.getExample(select);
            boolean salir = false;
            for (int j = 0; j < this.chain.size() && !salir; ++j) {
                SimpleRule sr = (SimpleRule)this.chain.elementAt(j);
                int attribute = sr.getAttribute();
                double value = sr.getValue();
                if (data.isMissing(select, attribute) && j != ignore) {
                    salir = true;
                    continue;
                }
                if (j == ignore) continue;
                salir = sr.isDiscret() ? exemple[attribute] != value : (sr.getOperator() == SimpleRule.GREATER ? !(exemple[attribute] > value) : !(exemple[attribute] <= value));
            }
            if (salir) continue;
            ++output;
        }
        return output;
    }

    public int apply(MyDataset data, Mask select) {
        return this.apply(data, select, -1);
    }

    public int apply(MyDataset data) {
        return this.apply(data, new Mask(data.size()), -1);
    }

    public Stats apply(MyDataset data, Mask positives, Mask negatives) {
        Stats stats = new Stats();
        stats.tp = this.apply(data, positives);
        stats.fn = positives.getnActive() - stats.tp;
        stats.fp = this.apply(data, negatives);
        stats.tn = negatives.getnActive() - stats.fp;
        return stats;
    }

    public double getMDL(MyDataset data, Mask positives, Mask negatives) {
        Stats quartet = this.apply(data, positives, negatives);
        double tp = quartet.tp;
        double tn = quartet.tn;
        double fp = quartet.fp;
        double fn = quartet.fn;
        double U = tn + fn;
        double C = tp + fp;
        double D = U + C;
        double e = fn + fp;
        double mdl = Double.MAX_VALUE;
        if (C != 0.0 && U != 0.0) {
            double fn_prob;
            double tn_prob;
            double fp_prob;
            double tp_prob;
            if (C >= U) {
                double aux_prob1 = e / (2.0 * C);
                double aux_prob2 = fn / U;
                tp_prob = 1.0 - aux_prob1 == 0.0 ? tp : tp * -Math.log(1.0 - aux_prob1);
                fp_prob = aux_prob1 == 0.0 ? fp : fp * -Math.log(aux_prob1);
                tn_prob = 1.0 - aux_prob2 == 0.0 ? tn : tn * -Math.log(1.0 - aux_prob2);
                fn_prob = aux_prob2 == 0.0 ? fp : fp * -Math.log(aux_prob2);
            } else {
                double aux_prob1 = fp / C;
                double aux_prob2 = e / (2.0 * U);
                tp_prob = 1.0 - aux_prob1 == 0.0 ? tp : tp * -Math.log(1.0 - aux_prob1);
                fp_prob = aux_prob1 == 0.0 ? fp : fp * -Math.log(aux_prob1);
                tn_prob = 1.0 - aux_prob2 == 0.0 ? tn : tn * -Math.log(1.0 - aux_prob2);
                fn_prob = aux_prob2 == 0.0 ? fp : fp * -Math.log(aux_prob2);
            }
            mdl = Math.log(D + 1.0) + tp_prob + tn_prob + fp_prob + fn_prob;
        }
        return mdl;
    }

    public static double getMDL(MyDataset data, int tp, int tn, int fp, int fn) {
        double U = tn + fn;
        double C = tp + fp;
        double D = U + C;
        double e = fn + fp;
        double mdl = Double.MAX_VALUE;
        if (C != 0.0 && U != 0.0) {
            double fn_prob;
            double tn_prob;
            double fp_prob;
            double tp_prob;
            if (C >= U) {
                double aux_prob1 = e / (2.0 * C);
                double aux_prob2 = (double)fn / U;
                tp_prob = 1.0 - aux_prob1 == 0.0 ? (double)tp : (double)tp * -Math.log(1.0 - aux_prob1);
                fp_prob = aux_prob1 == 0.0 ? (double)fp : (double)fp * -Math.log(aux_prob1);
                tn_prob = 1.0 - aux_prob2 == 0.0 ? (double)tn : (double)tn * -Math.log(1.0 - aux_prob2);
                fn_prob = aux_prob2 == 0.0 ? (double)fp : (double)fp * -Math.log(aux_prob2);
            } else {
                double aux_prob1 = (double)fp / C;
                double aux_prob2 = e / (2.0 * U);
                tp_prob = 1.0 - aux_prob1 == 0.0 ? (double)tp : (double)tp * -Math.log(1.0 - aux_prob1);
                fp_prob = aux_prob1 == 0.0 ? (double)fp : (double)fp * -Math.log(aux_prob1);
                tn_prob = 1.0 - aux_prob2 == 0.0 ? (double)tn : (double)tn * -Math.log(1.0 - aux_prob2);
                fn_prob = aux_prob2 == 0.0 ? (double)fp : (double)fp * -Math.log(aux_prob2);
            }
            mdl = Math.log(D + 1.0) + tp_prob + tn_prob + fp_prob + fn_prob;
        }
        return mdl;
    }

    public SimpleRule getSimpleRule(int i) {
        return (SimpleRule)this.chain.elementAt(i);
    }

    public void grow(int attribute, double value, int operator) {
        SimpleRule sr = new SimpleRule(attribute, value, operator);
        this.chain.add(sr);
    }

    public void grow(SimpleRule sr) {
        this.chain.add(sr);
    }

    public void setType(String new_class) {
        this.type = new_class;
    }

    public String getType() {
        return this.type;
    }

    public Rule getCopy() {
        Rule r = new Rule();
        for (int i = 0; i < this.chain.size(); ++i) {
            r.grow(this.getSimpleRule(i).getCopy());
        }
        return r;
    }

    public void prune(int pos) {
        this.chain.remove(pos);
    }

    public int size() {
        return this.chain.size();
    }

    public boolean isEqual(Rule r) {
        if (this.chain.size() != r.size()) {
            return false;
        }
        boolean is_equal = true;
        for (int i = 0; i < r.size() && is_equal; ++i) {
            is_equal = this.contains(r.getSimpleRule(i));
        }
        return is_equal;
    }

    public String toString() {
        String output = "(";
        if (this.chain.size() != 0) {
            output = output + ((SimpleRule)this.chain.elementAt(0)).toString();
        }
        for (int i = 1; i < this.chain.size(); ++i) {
            output = output + " && " + ((SimpleRule)this.chain.elementAt(i)).toString();
        }
        output = output + ")";
        if (!this.type.equals("")) {
            output = output + "-> ";
            output = output + this.type;
        }
        return output;
    }
}

