/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy;

import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyInterval;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyNumberTRIANG;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzySingleton;

public class FuzzyAlphaCut
extends Fuzzy {
    double[] left;
    double[] right;
    double[] alpha;

    public FuzzyAlphaCut(FuzzyNumberTRIANG b) {
        this.left = new double[2];
        this.right = new double[2];
        this.alpha = new double[2];
        this.left[0] = b.left;
        this.left[1] = b.center;
        this.right[0] = b.right;
        this.right[1] = b.center;
        this.alpha[0] = 0.0;
        this.alpha[1] = 1.0;
    }

    public FuzzyAlphaCut(FuzzyInterval b) {
        this.left = new double[2];
        this.right = new double[2];
        this.alpha = new double[2];
        this.left[0] = b.a;
        this.left[1] = b.a;
        this.right[0] = b.b;
        this.right[1] = b.b;
        this.alpha[0] = 0.0;
        this.alpha[1] = 1.0;
    }

    public FuzzyAlphaCut(FuzzySingleton b) {
        this.left = new double[2];
        this.right = new double[2];
        this.alpha = new double[2];
        this.left[0] = b.center;
        this.left[1] = b.center;
        this.right[0] = b.center;
        this.right[1] = b.center;
        this.alpha[0] = 0.0;
        this.alpha[1] = 1.0;
    }

    public FuzzyAlphaCut(FuzzyAlphaCut b) {
        int i;
        this.left = new double[b.left.length];
        for (i = 0; i < this.left.length; ++i) {
            this.left[i] = b.left[i];
        }
        this.right = new double[b.right.length];
        for (i = 0; i < this.right.length; ++i) {
            this.right[i] = b.right[i];
        }
        this.alpha = new double[b.alpha.length];
        for (i = 0; i < this.alpha.length; ++i) {
            this.alpha[i] = b.alpha[i];
        }
    }

    @Override
    public Fuzzy clone() {
        return new FuzzyAlphaCut(this);
    }

    public void set(FuzzyAlphaCut b) {
        int i;
        this.left = new double[b.left.length];
        for (i = 0; i < this.left.length; ++i) {
            this.left[i] = b.left[i];
        }
        this.right = new double[b.right.length];
        for (i = 0; i < this.right.length; ++i) {
            this.right[i] = b.right[i];
        }
        this.alpha = new double[b.alpha.length];
        for (i = 0; i < this.alpha.length; ++i) {
            this.alpha[i] = b.alpha[i];
        }
    }

    @Override
    public boolean equals(Fuzzy B) {
        int i;
        if (!(B instanceof FuzzyAlphaCut)) {
            return false;
        }
        FuzzyAlphaCut b = (FuzzyAlphaCut)B;
        for (i = 0; i < this.left.length; ++i) {
            if (this.left[i] == b.left[i]) continue;
            return false;
        }
        for (i = 0; i < this.right.length; ++i) {
            if (this.right[i] == b.right[i]) continue;
            return false;
        }
        for (i = 0; i < this.alpha.length; ++i) {
            if (this.alpha[i] == b.alpha[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public double evaluateMembership(double x) {
        if (x < this.left[0] || x > this.right[0]) {
            return 0.0;
        }
        for (int i = 1; i < this.left.length; ++i) {
            if (!(x < this.left[i]) && !(x > this.right[i])) continue;
            if (x < this.left[i]) {
                return this.alpha[i - 1] + (this.alpha[i] - this.alpha[i - 1]) * (x - this.left[i - 1]) / (this.left[i] - this.left[i - 1]);
            }
            return this.alpha[i - 1] + (this.alpha[i] - this.alpha[i - 1]) * (this.right[i - 1] - x) / (this.right[i - 1] - this.right[i]);
        }
        return 1.0;
    }

    public FuzzyInterval alphaCut(double a) {
        if (a == 0.0) {
            return this.support();
        }
        if (this.left[0] < -1.0E10 || this.right[0] > 1.0E10) {
            return this.support();
        }
        for (int i = 1; i < this.left.length; ++i) {
            if (!(a < this.alpha[i])) continue;
            double f = (a - this.alpha[i - 1]) / (this.alpha[i] - this.alpha[i - 1]);
            double le = f * (this.left[i] - this.left[i - 1]) + this.left[i - 1];
            double ri = f * (this.right[i] - this.right[i - 1]) + this.right[i - 1];
            return new FuzzyInterval(le, ri);
        }
        return new FuzzyInterval(this.left[this.left.length - 1], this.right[this.right.length - 1]);
    }

    @Override
    public FuzzyInterval support() {
        return new FuzzyInterval(this.left[0], this.right[0]);
    }

    public FuzzyAlphaCut sum(FuzzyAlphaCut x) {
        if (this.left.length != x.left.length) {
            System.out.println("FuzzyAlphaCut::suma: option not supported");
        }
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            int n = i;
            result.left[n] = result.left[n] + x.left[i];
            int n2 = i;
            result.right[n2] = result.right[n2] + x.right[i];
        }
        return result;
    }

    public FuzzyAlphaCut subtract(FuzzyAlphaCut x) {
        if (this.left.length != x.left.length) {
            System.out.println("FuzzyAlphaCut::resta: option not supported");
        }
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            int n = i;
            result.left[n] = result.left[n] - x.right[i];
            int n2 = i;
            result.right[n2] = result.right[n2] - x.left[i];
        }
        return result;
    }

    public FuzzyAlphaCut multiply(double k) {
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            if (k > 0.0) {
                result.left[i] = this.left[i] * k;
                result.right[i] = this.right[i] * k;
                continue;
            }
            result.left[i] = this.right[i] * k;
            result.right[i] = this.left[i] * k;
        }
        return result;
    }

    public FuzzyAlphaCut multiply(FuzzyAlphaCut x) {
        if (this.left.length != x.left.length) {
            System.out.println("FuzzyAlphaCut::producto: option not supported");
        }
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            double d;
            double c;
            double a;
            double max = a = result.left[i] * x.left[i];
            double min = a;
            double b = result.right[i] * x.right[i];
            if (max < b) {
                max = b;
            }
            if (min > b) {
                min = b;
            }
            if (max < (c = result.left[i] * x.right[i])) {
                max = c;
            }
            if (min > c) {
                min = c;
            }
            if (max < (d = result.right[i] * x.left[i])) {
                max = d;
            }
            if (min > d) {
                min = d;
            }
            if (max * min > 0.0 && (result.left[i] * result.right[i] < 0.0 || x.left[i] * x.right[i] < 0.0)) {
                if (max < 0.0) {
                    max = 0.0;
                } else {
                    min = 0.0;
                }
            }
            result.left[i] = min;
            result.right[i] = max;
        }
        return result;
    }

    public FuzzyAlphaCut sqrt() {
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            double b;
            double a = Math.sqrt(Math.abs(this.left[i]));
            if (a < (b = Math.sqrt(Math.abs(this.right[i])))) {
                result.left[i] = a;
                result.right[i] = b;
            } else {
                result.left[i] = b;
                result.right[i] = a;
            }
            if (!(this.left[i] * this.right[i] < 0.0)) continue;
            result.left[i] = 0.0;
        }
        return result;
    }

    public FuzzyAlphaCut sqr() {
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            double a = this.left[i] * this.left[i];
            double b = this.right[i] * this.right[i];
            if (a < b) {
                result.left[i] = a;
                result.right[i] = b;
            } else {
                result.left[i] = b;
                result.right[i] = a;
            }
            if (!(this.left[i] * this.right[i] < 0.0)) continue;
            result.left[i] = 0.0;
        }
        return result;
    }

    public FuzzyAlphaCut exp() {
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        for (int i = 0; i < this.left.length; ++i) {
            double le = this.left[i];
            double ri = this.right[i];
            if (le > 30.0) {
                le = 30.0;
            }
            if (ri > 30.0) {
                ri = 30.0;
            }
            double a = Math.exp(le);
            double b = Math.exp(ri);
            result.left[i] = a;
            result.right[i] = b;
        }
        return result;
    }

    public FuzzyAlphaCut log() {
        FuzzyAlphaCut result = new FuzzyAlphaCut(this);
        double MINIMUM = 1.0E-6;
        double MINUSINF = Math.log(1.0E-6);
        for (int i = 0; i < this.left.length; ++i) {
            double a = MINUSINF;
            double b = MINUSINF;
            if (this.left[i] > 1.0E-6) {
                a = Math.log(this.left[i]);
            }
            if (this.right[i] > 1.0E-6) {
                b = Math.log(this.right[i]);
            }
            result.left[i] = a;
            result.right[i] = b;
        }
        return result;
    }

    @Override
    public double massCentre() {
        double mass = 0.0;
        double sumxw = 0.0;
        double c = this.left[0];
        double d = this.right[0];
        for (int i = 1; i < this.left.length; ++i) {
            double a = this.left[i];
            double b = this.right[i];
            double h = this.alpha[i] - this.alpha[i - 1];
            double w = h / 2.0 * (-a + b - c + d);
            double xc = ((a - c) * (2.0 * a + c) + 3.0 * (a + b) * (b - a) + (d - b) * (2.0 * b + d)) / (3.0 * (-a + b - c + d));
            c = a;
            d = b;
            mass += w;
            sumxw += xc * w;
        }
        if (mass == 0.0) {
            return this.left[0];
        }
        return sumxw / mass;
    }

    public void averageAmplitude() {
        for (int i = 0; i < this.left.length; ++i) {
            double c = (this.left[i] + this.right[i]) / 2.0;
            double m = this.right[i] - c;
            this.left[i] = c - m / 2.0;
            this.right[i] = c + m / 2.0;
        }
    }

    public void linearComb(FuzzyAlphaCut a, FuzzyAlphaCut b, double alphap) {
        int i;
        this.left = new double[b.left.length];
        for (i = 0; i < this.left.length; ++i) {
            this.left[i] = a.left[i] * alphap + b.left[i] * (1.0 - alphap);
        }
        this.right = new double[b.right.length];
        for (i = 0; i < this.right.length; ++i) {
            this.right[i] = a.right[i] * alphap + b.right[i] * (1.0 - alphap);
        }
        this.alpha = new double[b.alpha.length];
        for (i = 0; i < this.alpha.length; ++i) {
            this.alpha[i] = b.alpha[i];
        }
    }

    @Override
    public String aString() {
        String result = "ALFA_CORTES{";
        for (int i = 0; i < this.left.length; ++i) {
            result = result + "[" + this.left[i] + ", " + this.right[i] + "] ";
        }
        return result + "}";
    }
}

