/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.StreamableFilter;

public class MultiFilter
extends SimpleStreamFilter
implements WeightedAttributesHandler,
WeightedInstancesHandler {
    private static final long serialVersionUID = -6293720886005713120L;
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected boolean m_Streamable = false;
    protected boolean m_StreamableChecked = false;

    @Override
    public String globalInfo() {
        return "Applies several filters successively. In case all supplied filters are StreamableFilters, it will act as a streamable one, too.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        super.setOptions(options);
        Vector<Filter> filters = new Vector<Filter>();
        while ((tmpStr = Utils.getOption("F", options)).length() != 0) {
            String[] options2 = Utils.splitOptions(tmpStr);
            String filter = options2[0];
            options2[0] = "";
            filters.add((Filter)Utils.forName(Filter.class, filter, options2));
        }
        if (filters.size() == 0) {
            filters.add(new AllFilter());
        }
        this.setFilters(filters.toArray(new Filter[filters.size()]));
    }

    @Override
    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        for (i = 0; i < this.getFilters().length; ++i) {
            result.add("-F");
            result.add(this.getFilterSpec(this.getFilter(i)));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.getFilters().length == 0) {
            Capabilities result = super.getCapabilities();
            result.disableAll();
            return result;
        }
        return this.getFilters()[0].getCapabilities();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_StreamableChecked = false;
    }

    public void setFilters(Filter[] filters) {
        this.m_Filters = filters;
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int index) {
        return this.m_Filters[index];
    }

    protected String getFilterSpec(Filter filter) {
        String result;
        if (filter == null) {
            result = "";
        } else {
            result = filter.getClass().getName();
            if (filter instanceof OptionHandler) {
                result = result + " " + Utils.joinOptions(filter.getOptions());
            }
        }
        return result;
    }

    public boolean isStreamableFilter() {
        if (!this.m_StreamableChecked) {
            this.m_Streamable = true;
            this.m_StreamableChecked = true;
            for (int i = 0; i < this.getFilters().length; ++i) {
                this.m_Streamable = this.getFilter(i) instanceof MultiFilter ? ((MultiFilter)this.getFilter(i)).isStreamableFilter() : this.getFilter(i) instanceof StreamableFilter;
                if (!this.m_Streamable) break;
            }
            if (this.getDebug()) {
                System.out.println("Streamable: " + this.m_Streamable);
            }
        }
        return this.m_Streamable;
    }

    @Override
    protected boolean hasImmediateOutputFormat() {
        return this.isStreamableFilter();
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Instances result = this.getInputFormat();
        for (int i = 0; i < this.getFilters().length; ++i) {
            if (!this.isFirstBatchDone()) {
                this.getFilter(i).setInputFormat(result);
            }
            result = this.getFilter(i).getOutputFormat();
        }
        return result;
    }

    @Override
    protected Instance process(Instance instance) throws Exception {
        Instance result = (Instance)instance.copy();
        for (int i = 0; i < this.getFilters().length; ++i) {
            if (!this.getFilter(i).input(result)) {
                result = null;
                break;
            }
            result = this.getFilter(i).output();
        }
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances result = instances;
        for (int i = 0; i < this.getFilters().length; ++i) {
            if (!this.isFirstBatchDone()) {
                this.getFilter(i).setInputFormat(result);
            }
            result = Filter.useFilter(result, this.getFilter(i));
        }
        return result;
    }

    @Override
    public boolean batchFinished() throws Exception {
        super.batchFinished();
        for (int i = 0; i > this.getFilters().length; ++i) {
            this.getFilter(i).batchFinished();
        }
        return this.numPendingOutput() != 0;
    }

    @Override
    public boolean mayRemoveInstanceAfterFirstBatchDone() {
        boolean result = false;
        for (Filter f : this.m_Filters) {
            result = result || f.mayRemoveInstanceAfterFirstBatchDone();
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14508 $");
    }

    public static void main(String[] args) {
        MultiFilter.runFilter(new MultiFilter(), args);
    }
}

