/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.AbstractTraitFactory;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.factmodel.traits.VirtualPropertyMode;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.HierarchyEncoderImpl;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleFactoryImpl;
import org.drools.core.util.TripleStore;

public class StandaloneTraitFactory<T extends Thing<K>, K extends TraitableBean>
extends AbstractTraitFactory<T, K> {
    private ProjectClassLoader classLoader;
    private KieComponentFactory kieComponentFactory;
    private TraitRegistry registry;
    private ClassFieldAccessorStore store;
    private HierarchyEncoder encoder;
    private TripleStore tripleStore;
    private TripleFactory tripleFactory;

    public StandaloneTraitFactory(ProjectClassLoader classLoader) {
        this(classLoader, new KieComponentFactory());
    }

    public StandaloneTraitFactory(ProjectClassLoader classLoader, KieComponentFactory factory) {
        this(classLoader, factory, VirtualPropertyMode.MAP);
    }

    public StandaloneTraitFactory(ProjectClassLoader classLoader, KieComponentFactory factory, VirtualPropertyMode mode) {
        this.classLoader = classLoader;
        this.kieComponentFactory = factory;
        this.registry = this.kieComponentFactory.getTraitRegistry();
        this.store = new ClassFieldAccessorStore();
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.classLoader));
        this.encoder = new HierarchyEncoderImpl();
        this.encoder.encode(Thing.class, Collections.emptyList());
        this.mode = mode;
        StandaloneTraitFactory.setMode(this.mode, this.getComponentFactory());
    }

    @Override
    protected Class<?> registerAndLoadTypeDefinition(String className, byte[] def) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (def != null) {
                return this.classLoader.defineClass(className, def);
            }
            throw e;
        }
    }

    @Override
    protected ClassLoader getRootClassLoader() {
        return this.classLoader;
    }

    @Override
    protected KieComponentFactory getComponentFactory() {
        return this.kieComponentFactory;
    }

    @Override
    protected TraitRegistry getTraitRegistry() {
        return this.registry;
    }

    @Override
    protected HierarchyEncoder getHierarchyEncoder() {
        return this.encoder;
    }

    @Override
    protected TripleStore getTripleStore() {
        if (this.tripleStore == null) {
            this.tripleStore = new TripleStore();
        }
        return this.tripleStore;
    }

    @Override
    protected TripleFactory getTripleFactory() {
        if (this.tripleFactory == null) {
            this.tripleFactory = new TripleFactoryImpl();
        }
        return this.tripleFactory;
    }

    @Override
    protected ClassFieldAccessorStore getClassFieldAccessorStore() {
        return this.store;
    }

    @Override
    public T getProxy(K core, Class<?> trait, boolean logical) throws LogicalTypeInconsistencyException {
        this.encode(trait);
        if (!this.getTraitRegistry().getTraits().containsKey(trait.getName())) {
            try {
                this.getTraitRegistry().addTrait(trait.getName(), this.buildClassDefinition(trait, trait));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return super.getProxy(core, trait, logical);
    }

    private void encode(Class<?> trait) {
        for (Class<?> sup : trait.getInterfaces()) {
            this.encode(sup);
        }
        ArrayList<String> supers = new ArrayList<String>(trait.getInterfaces().length);
        for (Class<?> k : trait.getInterfaces()) {
            supers.add(k.getName());
        }
        this.getHierarchyEncoder().encode(trait.getName(), supers);
    }

    public <X> CoreWrapper<X> makeTraitable(X o, Class<X> klass) {
        if (o instanceof TraitableBean) {
            throw new IllegalStateException("Method makeTraitable should be used on non-traitable objects");
        }
        try {
            Class<CoreWrapper<X>> wrapperClass = this.buildCoreWrapper(klass, this.buildClassDefinition(klass, klass));
            CoreWrapper<X> wrapper = this.getCoreWrapper(klass, this.buildClassDefinition(klass, wrapperClass));
            wrapper.init(o);
            return wrapper;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public T don(K core, Class<T> trait) throws LogicalTypeInconsistencyException {
        if (trait.getAnnotation(Trait.class) == null || !Thing.class.isAssignableFrom(trait)) {
            trait = this.extendAsProperTrait(trait);
        }
        return this.getProxy(core, trait, false);
    }

    private Class<T> extendAsProperTrait(Class<T> trait) {
        String extName = trait.getName() + "_Trait__Extension";
        if (!this.classLoader.isClassInUse(extName)) {
            try {
                ClassDefinition extDef = new ClassDefinition(extName);
                extDef.setSuperClass(Object.class.getName());
                AnnotationDefinition annot = new AnnotationDefinition(Trait.class.getName());
                extDef.addAnnotation(annot);
                String[] supers = new String[]{Thing.class.getName(), trait.getName()};
                extDef.setInterfaces(supers);
                byte[] ext = this.getComponentFactory().getClassBuilderFactory().getTraitBuilder().buildClass(extDef, this.classLoader);
                Class<?> klass = this.registerAndLoadTypeDefinition(extName, ext);
                ClassDefinition tDef = this.buildClassDefinition(trait, trait);
                tDef.setDefinedClass(klass);
                this.getTraitRegistry().addTrait(tDef);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return Class.forName(extName, false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

