/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.jamesframework.core.exceptions.SearchException;
import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.listeners.SearchListener;
import org.jamesframework.core.search.status.SearchStatus;
import org.jamesframework.core.search.stopcriteria.StopCriterion;
import org.jamesframework.core.search.stopcriteria.StopCriterionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Search<SolutionType extends Solution>
implements Runnable {
    private static int nextID = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(Search.class);
    private long startTime;
    private long stopTime;
    private long currentSteps;
    private long lastImprovementTime;
    private long stepsSinceLastImprovement;
    private boolean improvementDuringCurrentStep;
    private double minDelta;
    private SolutionType bestSolution;
    private Evaluation bestSolutionEvaluation;
    private Validation bestSolutionValidation;
    private SearchStatus status;
    private Random rnd;
    private final String name;
    private final int id;
    private final Problem<SolutionType> problem;
    private final List<SearchListener<? super SolutionType>> searchListeners;
    private final List<SearchListener<? super SolutionType>> searchListenersView;
    private final StopCriterionChecker stopCriterionChecker;
    private final Object statusLock = new Object();

    public Search(Problem<SolutionType> problem) {
        this(null, problem);
    }

    public Search(String name, Problem<SolutionType> problem) {
        if (problem == null) {
            throw new NullPointerException("Error while creating search: problem can not be null.");
        }
        this.problem = problem;
        this.name = name != null ? name : "Search";
        this.id = this.getNextUniqueID();
        this.searchListeners = new ArrayList<SearchListener<? super SolutionType>>();
        this.searchListenersView = Collections.unmodifiableList(this.searchListeners);
        this.stopCriterionChecker = new StopCriterionChecker(this);
        this.rnd = new Random();
        this.status = SearchStatus.IDLE;
        this.bestSolution = null;
        this.bestSolutionEvaluation = null;
        this.bestSolutionValidation = null;
        this.startTime = -1L;
        this.stopTime = -1L;
        this.currentSteps = -1L;
        this.lastImprovementTime = -1L;
        this.stepsSinceLastImprovement = -1L;
        this.minDelta = -1.0;
        this.improvementDuringCurrentStep = false;
        LOGGER.info("Created search {}", (Object)this);
    }

    private synchronized int getNextUniqueID() {
        return nextID++;
    }

    public Problem<SolutionType> getProblem() {
        return this.problem;
    }

    public Random getRandom() {
        return this.rnd;
    }

    public void setRandom(Random rnd) {
        this.rnd = rnd;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot start search.");
            LOGGER.debug("Search {} changed status: {} --> {}", new Object[]{this, this.status, SearchStatus.INITIALIZING});
            this.status = SearchStatus.INITIALIZING;
            this.fireStatusChanged(this.status);
        }
        LOGGER.info("Search {} started", (Object)this);
        this.fireSearchStarted();
        this.searchStarted();
        if (this.continueSearch()) {
            this.stopCriterionChecker.startChecking();
            object = this.statusLock;
            synchronized (object) {
                LOGGER.debug("Search {} changed status: {} --> {}", new Object[]{this, this.status, SearchStatus.RUNNING});
                this.status = SearchStatus.RUNNING;
                this.fireStatusChanged(this.status);
            }
            while (this.continueSearch()) {
                this.improvementDuringCurrentStep = false;
                this.searchStep();
                ++this.currentSteps;
                if (this.improvementDuringCurrentStep) {
                    this.stepsSinceLastImprovement = 0L;
                } else if (this.stepsSinceLastImprovement != -1L) {
                    ++this.stepsSinceLastImprovement;
                }
                this.fireStepCompleted(this.currentSteps);
                if (!this.stopCriterionChecker.stopCriterionSatisfied()) continue;
                this.stop();
            }
            this.stopCriterionChecker.stopChecking();
        }
        this.searchStopped();
        this.fireSearchStopped();
        LOGGER.info("Search {} stopped (runtime: {} ms, steps: {})", this, this.getRuntime(), this.getSteps());
        object = this.statusLock;
        synchronized (object) {
            LOGGER.debug("Search {} changed status: {} --> {}", new Object[]{this, this.status, SearchStatus.IDLE});
            this.status = SearchStatus.IDLE;
            this.fireStatusChanged(this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.INITIALIZING || this.status == SearchStatus.RUNNING) {
                LOGGER.debug("Search {} changed status: {} --> {}", new Object[]{this, this.status, SearchStatus.TERMINATING});
                this.status = SearchStatus.TERMINATING;
                this.fireStatusChanged(this.status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.DISPOSED) {
                return;
            }
            this.assertIdle("Cannot dispose search.");
            this.searchDisposed();
            LOGGER.debug("Search {} changed status: {} --> {}", new Object[]{this, this.status, SearchStatus.DISPOSED});
            this.status = SearchStatus.DISPOSED;
            this.fireStatusChanged(this.status);
        }
    }

    @Override
    public void run() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStopCriterion(StopCriterion stopCriterion) {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot add stop criterion.");
            this.stopCriterionChecker.add(stopCriterion);
            LOGGER.debug("{}: added stop criterion {}", (Object)this, (Object)stopCriterion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStopCriterion(StopCriterion stopCriterion) {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot remove stop criterion.");
            if (this.stopCriterionChecker.remove(stopCriterion)) {
                LOGGER.debug("{}: removed stop criterion {}", (Object)this, (Object)stopCriterion);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStopCriteria() {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot clear stop criteria.");
            this.stopCriterionChecker.clear();
            LOGGER.debug("{}: cleared stop criteria", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopCriterionCheckPeriod(long period, TimeUnit timeUnit) {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot modify stop criterion check period.");
            this.stopCriterionChecker.setPeriod(period, timeUnit);
            LOGGER.debug("{}: set stop criterion check period to {} ms", (Object)this, (Object)timeUnit.toMillis(period));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSearchListener(SearchListener<? super SolutionType> listener) {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot add search listener.");
            this.searchListeners.add(listener);
            LOGGER.debug("{}: added search listener {}", (Object)this, (Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSearchListener(SearchListener<? super SolutionType> listener) {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot remove search listener.");
            if (this.searchListeners.remove(listener)) {
                LOGGER.debug("{}: removed search listener {}", (Object)this, (Object)listener);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSearchListeners() {
        Object object = this.statusLock;
        synchronized (object) {
            this.assertIdle("Cannot clear search listeners.");
            this.searchListeners.clear();
            LOGGER.debug("{}: cleared search listeners", (Object)this);
        }
    }

    private void fireSearchStarted() {
        for (SearchListener<SolutionType> l : this.searchListeners) {
            l.searchStarted(this);
        }
    }

    private void fireSearchStopped() {
        for (SearchListener<SolutionType> l : this.searchListeners) {
            l.searchStopped(this);
        }
    }

    private void fireNewBestSolution(SolutionType newBestSolution, Evaluation newBestSolutionEvaluation, Validation newBestSolutionValidation) {
        for (SearchListener<SolutionType> l : this.searchListeners) {
            l.newBestSolution(this, newBestSolution, newBestSolutionEvaluation, newBestSolutionValidation);
        }
    }

    private void fireStepCompleted(long numSteps) {
        for (SearchListener<SolutionType> l : this.searchListeners) {
            l.stepCompleted(this, numSteps);
        }
    }

    private void fireStatusChanged(SearchStatus newStatus) {
        for (SearchListener<SolutionType> l : this.searchListeners) {
            l.statusChanged(this, newStatus);
        }
    }

    protected List<SearchListener<? super SolutionType>> getSearchListeners() {
        return this.searchListenersView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchStatus getStatus() {
        Object object = this.statusLock;
        synchronized (object) {
            return this.status;
        }
    }

    protected Object getStatusLock() {
        return this.statusLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertIdle(String errorMessage) {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status != SearchStatus.IDLE) {
                throw new SearchException(errorMessage + " (current status: " + (Object)((Object)this.status) + "; required: IDLE)");
            }
        }
    }

    public SolutionType getBestSolution() {
        return this.bestSolution;
    }

    public Evaluation getBestSolutionEvaluation() {
        return this.bestSolutionEvaluation;
    }

    public Validation getBestSolutionValidation() {
        return this.bestSolutionValidation;
    }

    protected boolean updateBestSolution(SolutionType newSolution) {
        Validation validation = this.getProblem().validate(newSolution);
        if (validation.passed()) {
            Evaluation evaluation = this.getProblem().evaluate(newSolution);
            return this.updateBestSolution(newSolution, evaluation, validation);
        }
        return false;
    }

    protected boolean updateBestSolution(SolutionType newSolution, Evaluation newSolutionEvaluation, Validation newSolutionValidation) {
        block4: {
            block6: {
                Double delta;
                block5: {
                    Double d;
                    if (!newSolutionValidation.passed()) break block4;
                    delta = null;
                    if (this.bestSolution == null) break block5;
                    delta = this.computeDelta(newSolutionEvaluation, this.getBestSolutionEvaluation());
                    if (!(d > 0.0)) break block6;
                }
                this.improvementDuringCurrentStep = true;
                this.lastImprovementTime = System.currentTimeMillis();
                if (delta != null && (this.minDelta == -1.0 || delta < this.minDelta)) {
                    this.minDelta = delta;
                }
                this.bestSolution = Solution.checkedCopy(newSolution);
                this.bestSolutionEvaluation = newSolutionEvaluation;
                this.bestSolutionValidation = newSolutionValidation;
                this.fireNewBestSolution(this.bestSolution, this.bestSolutionEvaluation, this.bestSolutionValidation);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRuntime() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.INITIALIZING) {
                return -1L;
            }
            if (this.status == SearchStatus.IDLE || this.status == SearchStatus.DISPOSED) {
                if (this.stopTime == -1L) {
                    return -1L;
                }
                return this.stopTime - this.startTime;
            }
            return System.currentTimeMillis() - this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSteps() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.INITIALIZING) {
                return -1L;
            }
            return this.currentSteps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeWithoutImprovement() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.INITIALIZING) {
                return -1L;
            }
            if (this.lastImprovementTime == -1L) {
                return this.getRuntime();
            }
            if (this.status == SearchStatus.IDLE || this.status == SearchStatus.DISPOSED) {
                return this.stopTime - this.lastImprovementTime;
            }
            return System.currentTimeMillis() - this.lastImprovementTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStepsWithoutImprovement() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.INITIALIZING) {
                return -1L;
            }
            if (this.stepsSinceLastImprovement == -1L) {
                return this.getSteps();
            }
            return this.stepsSinceLastImprovement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMinDelta() {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status == SearchStatus.INITIALIZING) {
                return -1.0;
            }
            return this.minDelta;
        }
    }

    private boolean continueSearch() {
        return this.status != SearchStatus.TERMINATING;
    }

    protected double computeDelta(Evaluation currentEvaluation, Evaluation previousEvaluation) {
        if (this.problem.isMinimizing()) {
            return previousEvaluation.getValue() - currentEvaluation.getValue();
        }
        return currentEvaluation.getValue() - previousEvaluation.getValue();
    }

    protected void searchStarted() {
        this.init();
        this.startTime = System.currentTimeMillis();
        this.stopTime = -1L;
        this.currentSteps = 0L;
        this.lastImprovementTime = -1L;
        this.stepsSinceLastImprovement = -1L;
        this.minDelta = -1.0;
    }

    protected void searchStopped() {
        this.stopTime = System.currentTimeMillis();
    }

    protected void searchDisposed() {
    }

    protected abstract void searchStep();
}

