/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.subset;

import java.util.Comparator;
import java.util.Set;
import org.jamesframework.core.exceptions.IncompatibleDeltaValidationException;
import org.jamesframework.core.problems.GenericProblem;
import org.jamesframework.core.problems.constraints.validations.SimpleValidation;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.datatypes.IntegerIdentifiedData;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;
import org.jamesframework.core.subset.validations.SubsetValidation;
import org.jamesframework.core.util.SetUtilities;

public class SubsetProblem<DataType extends IntegerIdentifiedData>
extends GenericProblem<SubsetSolution, DataType> {
    private int minSubsetSize;
    private int maxSubsetSize;
    private final Comparator<Integer> orderOfIDs;
    private static final SubsetValidation UNCONSTRAINED_VALID_SIZE = new SubsetValidation(true, SimpleValidation.PASSED);
    private static final SubsetValidation UNCONSTRAINED_INVALID_SIZE = new SubsetValidation(false, SimpleValidation.PASSED);

    public SubsetProblem(DataType data, Objective<? super SubsetSolution, ? super DataType> objective, int minSubsetSize, int maxSubsetSize, Comparator<Integer> orderOfIDs) {
        super(data, objective, (r, d) -> {
            int size = minSubsetSize + r.nextInt(maxSubsetSize - minSubsetSize + 1);
            Set<Integer> selection = SetUtilities.getRandomSubset(d.getIDs(), size, r);
            SubsetSolution sol = new SubsetSolution(d.getIDs(), selection, orderOfIDs);
            return sol;
        });
        if (data == null) {
            throw new NullPointerException("Error while creating subset problem: data is required, can not be null.");
        }
        if (minSubsetSize < 0) {
            throw new IllegalArgumentException("Error while creating subset problem: minimum subset size should be >= 0.");
        }
        if (maxSubsetSize > data.getIDs().size()) {
            throw new IllegalArgumentException("Error while creating subset problem: maximum subset size can not be larger than number of items in underlying data.");
        }
        if (minSubsetSize > maxSubsetSize) {
            throw new IllegalArgumentException("Error while creating subset problem: minimum subset size should be <= maximum subset size.");
        }
        this.minSubsetSize = minSubsetSize;
        this.maxSubsetSize = maxSubsetSize;
        this.orderOfIDs = orderOfIDs;
    }

    public SubsetProblem(DataType data, Objective<? super SubsetSolution, ? super DataType> objective, int minSubsetSize, int maxSubsetSize, boolean orderIDs) {
        this((DataType)data, (Objective<SubsetSolution, ? super DataType>)objective, minSubsetSize, maxSubsetSize, orderIDs ? Comparator.naturalOrder() : null);
    }

    public SubsetProblem(DataType data, Objective<? super SubsetSolution, ? super DataType> objective, int minSubsetSize, int maxSubsetSize) {
        this((DataType)data, (Objective<SubsetSolution, ? super DataType>)objective, minSubsetSize, maxSubsetSize, false);
    }

    public SubsetProblem(DataType data, Objective<? super SubsetSolution, ? super DataType> objective, int fixedSubsetSize) {
        this((DataType)data, (Objective<SubsetSolution, ? super DataType>)objective, fixedSubsetSize, fixedSubsetSize);
    }

    public SubsetProblem(DataType data, Objective<? super SubsetSolution, ? super DataType> objective) {
        this((DataType)data, (Objective<SubsetSolution, ? super DataType>)objective, 0, data.getIDs().size());
    }

    @Override
    public void setData(DataType data) {
        if (data == null) {
            throw new NullPointerException("Error while setting data in subset problem: data can not be null.");
        }
        super.setData(data);
    }

    public SubsetSolution createEmptySubsetSolution() {
        return new SubsetSolution(((IntegerIdentifiedData)this.getData()).getIDs(), this.orderOfIDs);
    }

    public SubsetValidation validate(SubsetSolution solution) {
        boolean validSize;
        boolean bl = validSize = solution.getNumSelectedIDs() >= this.getMinSubsetSize() && solution.getNumSelectedIDs() <= this.getMaxSubsetSize();
        if (this.getMandatoryConstraints().isEmpty()) {
            return validSize ? UNCONSTRAINED_VALID_SIZE : UNCONSTRAINED_INVALID_SIZE;
        }
        Validation constraintVal = super.validate(solution);
        return new SubsetValidation(validSize, constraintVal);
    }

    public SubsetValidation validate(Move<? super SubsetSolution> move, SubsetSolution curSolution, Validation curValidation) {
        if (move instanceof SubsetMove) {
            boolean validSize;
            SubsetMove subsetMove = (SubsetMove)move;
            int newSize = curSolution.getNumSelectedIDs() + subsetMove.getNumAdded() - subsetMove.getNumDeleted();
            boolean bl = validSize = newSize >= this.getMinSubsetSize() && newSize <= this.getMaxSubsetSize();
            if (this.getMandatoryConstraints().isEmpty()) {
                return validSize ? UNCONSTRAINED_VALID_SIZE : UNCONSTRAINED_INVALID_SIZE;
            }
            SubsetValidation subsetVal = (SubsetValidation)curValidation;
            Validation deltaVal = super.validate(subsetMove, curSolution, subsetVal.getConstraintValidation());
            return new SubsetValidation(validSize, deltaVal);
        }
        throw new IncompatibleDeltaValidationException("Delta validation in subset problem expects moves of type SubsetMove. Received: " + move.getClass().getSimpleName());
    }

    public int getMinSubsetSize() {
        return this.minSubsetSize;
    }

    public void setMinSubsetSize(int minSubsetSize) {
        if (minSubsetSize <= 0) {
            throw new IllegalArgumentException("Error while setting minimum subset size: should be > 0.");
        }
        if (minSubsetSize > this.maxSubsetSize) {
            throw new IllegalArgumentException("Error while setting minimum subset size: should be <= maximum subset size.");
        }
        this.minSubsetSize = minSubsetSize;
    }

    public int getMaxSubsetSize() {
        return this.maxSubsetSize;
    }

    public void setMaxSubsetSize(int maxSubsetSize) {
        if (maxSubsetSize < this.minSubsetSize) {
            throw new IllegalArgumentException("Error while setting maximum subset size: should be >= minimum subset size.");
        }
        if (maxSubsetSize > ((IntegerIdentifiedData)this.getData()).getIDs().size()) {
            throw new IllegalArgumentException("Error while setting maximum subset size: can not be larger than number of items in underlying data.");
        }
        this.maxSubsetSize = maxSubsetSize;
    }
}

