/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.subset.neigh;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jamesframework.core.search.neigh.Neighbourhood;
import org.jamesframework.core.subset.SubsetSolution;

public abstract class SubsetNeighbourhood
implements Neighbourhood<SubsetSolution> {
    private final Set<Integer> fixedIDs;

    public SubsetNeighbourhood(Set<Integer> fixedIDs) {
        this.fixedIDs = fixedIDs;
    }

    protected Set<Integer> getAddCandidates(SubsetSolution currentSolution) {
        Set<Integer> addCandidates = currentSolution.getUnselectedIDs();
        if (this.fixedIDs != null && !this.fixedIDs.isEmpty()) {
            addCandidates = new LinkedHashSet<Integer>(addCandidates);
            addCandidates.removeAll(this.fixedIDs);
        }
        return addCandidates;
    }

    protected Set<Integer> getRemoveCandidates(SubsetSolution currentSolution) {
        Set<Integer> removeCandidates = currentSolution.getSelectedIDs();
        if (this.fixedIDs != null && !this.fixedIDs.isEmpty()) {
            removeCandidates = new LinkedHashSet<Integer>(removeCandidates);
            removeCandidates.removeAll(this.fixedIDs);
        }
        return removeCandidates;
    }
}

