/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.BrokerNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.tools.ConsumerOffsetChecker$;
import kafka.tools.ConsumerOffsetChecker$$anonfun$kafka$tools$ConsumerOffsetChecker$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging,
ScalaObject {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final scala.collection.mutable.Map<Integer, Option<SimpleConsumer>> consumerMap;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    private scala.collection.mutable.Map<Integer, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    /*
     * WARNING - void declaration
     */
    public final Option kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, int bid) {
        void var3_3;
        Option exceptionResult1 = null;
        try {
            Object a;
            Option<Object> option;
            Option<String> option2 = ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append(BoxesRunTime.boxToInteger(bid)).toString())._1();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String string2 = (String)some.x();
                String brokerInfoString = string2;
                option = Json$.MODULE$.parseFull(brokerInfoString);
                if (!(option instanceof Some)) {
                    None$ none$ = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                        throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(bid)})));
                    }
                    throw new MatchError(option);
                }
            } else {
                None$ none$ = None$.MODULE$;
                Option<String> option4 = option2;
                if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
                    throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(bid)})));
                }
                throw new MatchError(option2);
            }
            Some some = (Some)option;
            Object m = a = some.x();
            Map brokerInfo = (Map)m;
            String host = (String)brokerInfo.get("host").get();
            int port = BoxesRunTime.unboxToInt(brokerInfo.get("port").get());
            exceptionResult1 = new Some<SimpleConsumer>(new SimpleConsumer(host, port, 10000, 100000, "ConsumerOffsetChecker"));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new anonfun$kafka$tools$ConsumerOffsetChecker$$getConsumer$1(), (Function0<Throwable>)new anonfun$kafka$tools$ConsumerOffsetChecker$$getConsumer$2(throwable));
            exceptionResult1 = None$.MODULE$;
        }
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient$1, String group, String topic$1, int pid$1) {
        long offset = Predef$.MODULE$.augmentString(ZkUtils$.MODULE$.readData(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{group, topic$1, BoxesRunTime.boxToInteger(pid$1)})))._1()).toLong();
        Option<String> owner = ZkUtils$.MODULE$.readDataMaybeNull(zkClient$1, Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{group, topic$1, BoxesRunTime.boxToInteger(pid$1)})))._1();
        Option<Integer> option = ZkUtils$.MODULE$.getLeaderForPartition(zkClient$1, topic$1, pid$1);
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            int bid$1 = n = BoxesRunTime.unboxToInt(some.x());
            Option consumerOpt = (Option)this.consumerMap().getOrElseUpdate(BoxesRunTime.boxToInteger(bid$1), new anonfun.1(zkClient$1, bid$1));
            Option option2 = consumerOpt;
            if (option2 instanceof Some) {
                Object object;
                SimpleConsumer simpleConsumer;
                Some some2 = (Some)option2;
                SimpleConsumer consumer = simpleConsumer = (SimpleConsumer)some2.x();
                TopicAndPartition topicAndPartition = new TopicAndPartition(topic$1, pid$1);
                OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition).$minus$greater(new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                long logSize = BoxesRunTime.unboxToLong(((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets().head());
                long lag = logSize - offset;
                StringOps stringOps = Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s");
                Object[] objectArray = new Object[7];
                objectArray[0] = group;
                objectArray[1] = topic$1;
                objectArray[2] = BoxesRunTime.boxToInteger(pid$1);
                objectArray[3] = BoxesRunTime.boxToLong(offset);
                objectArray[4] = BoxesRunTime.boxToLong(logSize);
                objectArray[5] = BoxesRunTime.boxToLong(lag);
                Option<String> option3 = owner;
                if (option3 instanceof Some) {
                    object = ((Some)option3).x();
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<String> option4 = option3;
                    if (none$ == null) {
                        if (option4 != null) {
                            throw new MatchError(option3);
                        }
                    } else if (!none$.equals(option4)) throw new MatchError(option3);
                    object = "none";
                }
                objectArray[6] = object;
                Predef$.MODULE$.println(stringOps.format((Seq<Object>)Predef$.MODULE$.genericWrapArray(objectArray)));
                return;
            }
            None$ none$ = None$.MODULE$;
            Option option5 = option2;
            if (none$ == null) {
                if (option5 == null) return;
                throw new MatchError(option2);
            }
            if (none$.equals(option5)) return;
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        Option<Integer> option6 = option;
        if (none$ == null) {
            if (option6 != null) {
                throw new MatchError(option);
            }
        } else if (!none$.equals(option6)) throw new MatchError(option);
        this.error((Function0<String>)new anonfun$kafka$tools$ConsumerOffsetChecker$$processPartition$1(topic$1, pid$1));
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient$2, String group$1, String topic$2) {
        Option option;
        block4: {
            block3: {
                block2: {
                    scala.collection.mutable.Map<String, Seq<Integer>> pidMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient$2, (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$2})));
                    option = pidMap.get(topic$2);
                    if (!(option instanceof Some)) break block2;
                    ((IterableLike)((SeqLike)((Some)option).x()).sorted(Ordering$Int$.MODULE$)).foreach(new anonfun$kafka$tools$ConsumerOffsetChecker$$processTopic$1(zkClient$2, group$1, topic$2));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println("BROKER INFO");
        this.consumerMap().foreach(new anonfun.printBrokerInfo.1());
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser$1.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo("localhost:2181", (String[])((Object[])new String[0])).ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicsOpt = parser$1.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> groupOpt = parser$1.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        parser$1.accepts("broker-info", "Print broker info");
        parser$1.accepts("help", "Print this message.");
        OptionSet options$1 = parser$1.parse(args);
        if (options$1.has("help")) {
            parser$1.printHelpOn(System.out);
            System.exit(0);
        }
        List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach(new anonfun.main.1(parser$1, options$1));
        String zkConnect$1 = options$1.valueOf(zkConnectOpt);
        String group$2 = options$1.valueOf(groupOpt);
        Option topics = options$1.has(topicsOpt) ? new Some<String>(options$1.valueOf(topicsOpt)) : None$.MODULE$;
        ObjectRef zkClient$3 = new ObjectRef(null);
        try {
            Option option;
            block12: {
                List list2;
                block11: {
                    block10: {
                        zkClient$3.elem = new ZkClient(zkConnect$1, 30000, 30000, ZKStringSerializer$.MODULE$);
                        option = topics;
                        if (!(option instanceof Some)) break block10;
                        list2 = Predef$.MODULE$.refArrayOps((Object[])((String)((Some)option).x()).split(",")).view().toList();
                        break block11;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block12;
                    list2 = ZkUtils$.MODULE$.getChildren((ZkClient)zkClient$3.elem, Predef$.MODULE$.augmentString("/consumers/%s/offsets").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{group$2}))).toList();
                }
                List topicList$1 = list2;
                this.debug((Function0<String>)new anonfun.main.2(zkConnect$1, group$2, topicList$1));
                Predef$.MODULE$.println(Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{"Group", "Topic", "Pid", "Offset", "logSize", "Lag", "Owner"})));
                ((LinearSeqOptimized)topicList$1.sorted(Ordering$String$.MODULE$)).foreach(new anonfun.main.3(group$2, zkClient$3));
                if (options$1.has("broker-info")) {
                    this.printBrokerInfo();
                }
                this.consumerMap().foreach(new anonfun.main.4());
                return;
            }
            throw new MatchError(option);
        }
        finally {
            this.consumerMap().values().foreach(new anonfun.main.5());
            if ((ZkClient)zkClient$3.elem != null) {
                ((ZkClient)zkClient$3.elem).close();
            }
        }
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }
}

