ui = fluidPage(theme = teachingApps::add_theme(getShinyOption("theme")), 
               teachingApps::add_css(),

sidebarLayout(
  sidebarPanel(width = 3,
    sliderInput("range.sget", 
                label = "Range",
                min = 0, 
                max = 20, 
                value = c(0,4)),
    sliderInput("al.sgets", 
                label = h2(HTML("&alpha;")),
                min =  0, 
                max =  3, 
                step = 0.5, 
                value = 1, 
                animate = TRUE),
    sliderInput("si.sgets", 
                label = h2(HTML("&sigma;")),
                min = -5, 
                max =  5, 
                step = 0.5, 
                value = 0, 
                animate = TRUE),
    sliderInput("xi.sgets", 
                label = h2(HTML("&xi;")),
                min = .5, 
                max = 10, 
                step = 0.5, 
                value = 1, 
                animate = TRUE)),

  mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',metricsgraphicsOutput("sgetC",height = "600px")),
  tabPanel('Density',              metricsgraphicsOutput("sgetP",height = "600px")),
  tabPanel('Survival',             metricsgraphicsOutput("sgetR",height = "600px")),
  tabPanel('Hazard',               metricsgraphicsOutput("sgeth",height = "600px")),
  tabPanel('Cumulative Hazard',    metricsgraphicsOutput("sgetH",height = "600px")),
  tabPanel('Quantile',             metricsgraphicsOutput("sgetQ",height = "600px"))
  ))))

