## ----include=FALSE-------------------------------------------------------
# real API access requires a key so these are prefetched 
# results from June 23, 2017
load('prefetched.rda')

## ------------------------------------------------------------------------
library(twfy)

## ---- eval=FALSE---------------------------------------------------------
#  keighley <- getConstituency("Keighley")

## ---- eval=FALSE---------------------------------------------------------
#  mp <- getMP(postcode="BD21 2DH")

## ------------------------------------------------------------------------
mp$full_name

## ------------------------------------------------------------------------
mp$party

## ------------------------------------------------------------------------
mp$house

## ------------------------------------------------------------------------
mp$member_id

## ------------------------------------------------------------------------
mp$person_id

## ---- eval=FALSE---------------------------------------------------------
#  mp_per <- getPerson(mp$person_id)

## ---- eval=FALSE---------------------------------------------------------
#  mp_talk <- getDebates(person=mp$person_id)

## ------------------------------------------------------------------------
names(mp_talk)
names(mp_talk$info) # what we've got to work with

## ------------------------------------------------------------------------
mp_talk$info$total_results

## ------------------------------------------------------------------------
mp_talk$info$results_per_page

## ------------------------------------------------------------------------
mp_talk$info$first_result

## ------------------------------------------------------------------------
first_entry <- mp_talk$rows[1,]
first_entry$hdate

## ------------------------------------------------------------------------
first_entry$body

## ------------------------------------------------------------------------
first_entry$speaker$constituency

