/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.osx;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.ext.nanoxml.XMLElement;
import ch.randelshofer.quaqua.ext.nanoxml.XMLParseException;
import ch.randelshofer.quaqua.util.BinaryPListParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSXPreferences {
    public static final File GLOBAL_PREFERENCES = new File(QuaquaManager.getProperty("user.home"), "Library/Preferences/.GlobalPreferences.plist");
    public static final File FINDER_PREFERENCES = new File(QuaquaManager.getProperty("user.home"), "Library/Preferences/com.apple.finder.plist");
    private static HashMap<File, HashMap<String, Object>> cachedFiles;

    public static String getString(File file, String key) {
        return (String)OSXPreferences.get(file, key);
    }

    public static String getString(File file, String key, String defaultValue) {
        return (String)OSXPreferences.get(file, key, defaultValue);
    }

    public static boolean isStringEqualTo(File file, String key, String defaultValue, String compareWithThisValue) {
        return ((String)OSXPreferences.get(file, key, defaultValue)).equals(compareWithThisValue);
    }

    public static Object get(File file, String key) {
        OSXPreferences.ensureCached(file);
        return cachedFiles.get(file).get(key);
    }

    public static Set<String> getKeySet(File file) {
        OSXPreferences.ensureCached(file);
        return cachedFiles.get(file).keySet();
    }

    public static void clearAllCaches() {
        cachedFiles.clear();
    }

    public static void clearCache(File f) {
        cachedFiles.remove(f);
    }

    public static Object get(File file, String key, Object defaultValue) {
        OSXPreferences.ensureCached(file);
        return cachedFiles.get(file).containsKey(key) ? cachedFiles.get(file).get(key) : defaultValue;
    }

    private static void ensureCached(File file) {
        if (cachedFiles == null) {
            cachedFiles = new HashMap();
        }
        if (!cachedFiles.containsKey(file)) {
            HashMap<String, Object> cache = new HashMap<String, Object>();
            cachedFiles.put(file, cache);
            OSXPreferences.updateCache(file, cache);
        }
    }

    private static void updateCache(File file, HashMap<String, Object> cache) {
        cache.clear();
        if (QuaquaManager.isOSX()) {
            try {
                XMLElement plist = OSXPreferences.readPList(file);
                Stack<String> keyPath = new Stack<String>();
                OSXPreferences.readNode(plist, keyPath, cache);
            }
            catch (Throwable e) {
                System.err.println("Warning: ch.randelshofer.quaqua.util.OSXPreferences failed to load " + file);
                e.printStackTrace();
            }
        }
    }

    private static void readNode(XMLElement node, Stack<String> keyPath, HashMap<String, Object> cache) throws IOException {
        String name = node.getName();
        if (name.equals("plist")) {
            OSXPreferences.readPList(node, keyPath, cache);
        } else if (name.equals("dict")) {
            OSXPreferences.readDict(node, keyPath, cache);
        } else if (name.equals("array")) {
            OSXPreferences.readArray(node, keyPath, cache);
        } else {
            OSXPreferences.readValue(node, keyPath, cache);
        }
    }

    private static void readPList(XMLElement plist, Stack<String> keyPath, HashMap<String, Object> cache) throws IOException {
        ArrayList children = plist.getChildren();
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            OSXPreferences.readNode((XMLElement)children.get(i), keyPath, cache);
        }
    }

    private static void readDict(XMLElement dict, Stack<String> keyPath, HashMap<String, Object> cache) throws IOException {
        ArrayList children = dict.getChildren();
        int n = children.size();
        for (int i = 0; i < n; i += 2) {
            XMLElement keyElem = (XMLElement)children.get(i);
            if (!keyElem.getName().equals("key")) {
                throw new IOException("missing dictionary key at" + keyPath);
            }
            keyPath.push(keyElem.getContent());
            OSXPreferences.readNode((XMLElement)children.get(i + 1), keyPath, cache);
            keyPath.pop();
        }
    }

    private static void readArray(XMLElement array, Stack<String> keyPath, HashMap<String, Object> cache) throws IOException {
        ArrayList children = array.getChildren();
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            keyPath.push(Integer.toString(i));
            OSXPreferences.readNode((XMLElement)children.get(i), keyPath, cache);
            keyPath.pop();
        }
    }

    private static void readValue(XMLElement value, Stack<String> keyPath, HashMap<String, Object> cache) throws IOException {
        StringBuffer key = new StringBuffer();
        Iterator i = keyPath.iterator();
        while (i.hasNext()) {
            key.append((String)i.next());
            if (!i.hasNext()) continue;
            key.append('\t');
        }
        cache.put(key.toString(), value.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLElement readPList(File plistFile) throws IOException {
        FileReader reader = null;
        XMLElement xml = null;
        try {
            reader = new FileReader(plistFile);
            xml = new XMLElement(new HashMap(), false, false);
            try {
                xml.parseFromReader(reader);
            }
            catch (XMLParseException e) {
                xml = new BinaryPListParser().parse(plistFile);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return xml;
    }
}

