/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdouble;

import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.math.tdouble.DoubleConstants;

public class Bessel
extends DoubleConstants {
    protected static final double[] A_i0 = new double[]{-4.4153416464793395E-18, 3.3307945188222384E-17, -2.431279846547955E-16, 1.715391285555133E-15, -1.1685332877993451E-14, 7.676185498604936E-14, -4.856446783111929E-13, 2.95505266312964E-12, -1.726826291441556E-11, 9.675809035373237E-11, -5.189795601635263E-10, 2.6598237246823866E-9, -1.300025009986248E-8, 6.046995022541919E-8, -2.670793853940612E-7, 1.1173875391201037E-6, -4.4167383584587505E-6, 1.6448448070728896E-5, -5.754195010082104E-5, 1.8850288509584165E-4, -5.763755745385824E-4, 0.0016394756169413357, -0.004324309995050576, 0.010546460394594998, -0.02373741480589947, 0.04930528423967071, -0.09490109704804764, 0.17162090152220877, -0.3046826723431984, 0.6767952744094761};
    protected static final double[] B_i0 = new double[]{-7.233180487874754E-18, -4.830504485944182E-18, 4.46562142029676E-17, 3.461222867697461E-17, -2.8276239805165836E-16, -3.425485619677219E-16, 1.7725601330565263E-15, 3.8116806693526224E-15, -9.554846698828307E-15, -4.150569347287222E-14, 1.54008621752141E-14, 3.8527783827421426E-13, 7.180124451383666E-13, -1.7941785315068062E-12, -1.3215811840447713E-11, -3.1499165279632416E-11, 1.1889147107846439E-11, 4.94060238822497E-10, 3.3962320257083865E-9, 2.266668990498178E-8, 2.0489185894690638E-7, 2.8913705208347567E-6, 6.889758346916825E-5, 0.0033691164782556943, 0.8044904110141088};
    protected static final double[] A_i1 = new double[]{2.7779141127610464E-18, -2.111421214358166E-17, 1.5536319577362005E-16, -1.1055969477353862E-15, 7.600684294735408E-15, -5.042185504727912E-14, 3.223793365945575E-13, -1.9839743977649436E-12, 1.1736186298890901E-11, -6.663489723502027E-11, 3.625590281552117E-10, -1.8872497517228294E-9, 9.381537386495773E-9, -4.445059128796328E-8, 2.0032947535521353E-7, -8.568720264695455E-7, 3.4702513081376785E-6, -1.3273163656039436E-5, 4.781565107550054E-5, -1.6176081582589674E-4, 5.122859561685758E-4, -0.0015135724506312532, 0.004156422944312888, -0.010564084894626197, 0.024726449030626516, -0.05294598120809499, 0.1026436586898471, -0.17641651835783406, 0.25258718644363365};
    protected static final double[] B_i1 = new double[]{7.517296310842105E-18, 4.414348323071708E-18, -4.6503053684893586E-17, -3.209525921993424E-17, 2.96262899764595E-16, 3.3082023109209285E-16, -1.8803547755107825E-15, -3.8144030724370075E-15, 1.0420276984128802E-14, 4.272440016711951E-14, -2.1015418427726643E-14, -4.0835511110921974E-13, -7.198551776245908E-13, 2.0356285441470896E-12, 1.4125807436613782E-11, 3.2526035830154884E-11, -1.8974958123505413E-11, -5.589743462196584E-10, -3.835380385964237E-9, -2.6314688468895196E-8, -2.512236237870209E-7, -3.882564808877691E-6, -1.1058893876262371E-4, -0.009761097491361469, 0.7785762350182801};
    protected static final double[] A_k0 = new double[]{1.374465435613523E-16, 4.25981614279661E-14, 1.0349695257633842E-11, 1.904516377220209E-9, 2.5347910790261494E-7, 2.286212103119452E-5, 0.001264615411446926, 0.0359799365153615, 0.3442898999246285, -0.5353273932339028};
    protected static final double[] B_k0 = new double[]{5.300433772686263E-18, -1.6475804301524212E-17, 5.2103915050390274E-17, -1.678231096805412E-16, 5.512055978524319E-16, -1.848593377343779E-15, 6.3400764774050706E-15, -2.2275133269916698E-14, 8.032890775363575E-14, -2.9800969231727303E-13, 1.140340588208475E-12, -4.514597883373944E-12, 1.8559491149547177E-11, -7.957489244477107E-11, 3.577397281400301E-10, -1.69753450938906E-9, 8.574034017414225E-9, -4.660489897687948E-8, 2.766813639445015E-7, -1.8317555227191195E-6, 1.39498137188765E-5, -1.2849549581627802E-4, 0.0015698838857300533, -0.0314481013119645, 2.4403030820659555};
    protected static final double[] A_k1 = new double[]{-7.023863479386288E-18, -2.427449850519366E-15, -6.666901694199329E-13, -1.4114883926335278E-10, -2.213387630734726E-8, -2.4334061415659684E-6, -1.730288957513052E-4, -0.006975723859639864, -0.12261118082265715, -0.3531559607765449, 1.5253002273389478};
    protected static final double[] B_k1 = new double[]{-5.756744483665017E-18, 1.7940508731475592E-17, -5.689462558442859E-17, 1.838093544366639E-16, -6.057047248373319E-16, 2.038703165624334E-15, -7.019837090418314E-15, 2.4771544244813043E-14, -8.976705182324994E-14, 3.3484196660784293E-13, -1.2891739609510289E-12, 5.13963967348173E-12, -2.1299678384275683E-11, 9.218315187605006E-11, -4.1903547593418965E-10, 2.015049755197033E-9, -1.0345762465678097E-8, 5.7410841254500495E-8, -3.5019606030878126E-7, 2.406484947837217E-6, -1.936197974166083E-5, 1.9521551847135162E-4, -0.002857816859622779, 0.10392373657681724, 2.7206261904844427};

    protected Bessel() {
    }

    public static double i0(double d) throws ArithmeticException {
        if (d < 0.0) {
            d = -d;
        }
        if (d <= 8.0) {
            double d2 = d / 2.0 - 2.0;
            return Math.exp(d) * DoubleArithmetic.chbevl(d2, A_i0, 30);
        }
        return Math.exp(d) * DoubleArithmetic.chbevl(32.0 / d - 2.0, B_i0, 25) / Math.sqrt(d);
    }

    public static double i0e(double d) throws ArithmeticException {
        if (d < 0.0) {
            d = -d;
        }
        if (d <= 8.0) {
            double d2 = d / 2.0 - 2.0;
            return DoubleArithmetic.chbevl(d2, A_i0, 30);
        }
        return DoubleArithmetic.chbevl(32.0 / d - 2.0, B_i0, 25) / Math.sqrt(d);
    }

    public static double i1(double d) throws ArithmeticException {
        double d2 = Math.abs(d);
        if (d2 <= 8.0) {
            double d3 = d2 / 2.0 - 2.0;
            d2 = DoubleArithmetic.chbevl(d3, A_i1, 29) * d2 * Math.exp(d2);
        } else {
            d2 = Math.exp(d2) * DoubleArithmetic.chbevl(32.0 / d2 - 2.0, B_i1, 25) / Math.sqrt(d2);
        }
        if (d < 0.0) {
            d2 = -d2;
        }
        return d2;
    }

    public static double i1e(double d) throws ArithmeticException {
        double d2 = Math.abs(d);
        if (d2 <= 8.0) {
            double d3 = d2 / 2.0 - 2.0;
            d2 = DoubleArithmetic.chbevl(d3, A_i1, 29) * d2;
        } else {
            d2 = DoubleArithmetic.chbevl(32.0 / d2 - 2.0, B_i1, 25) / Math.sqrt(d2);
        }
        if (d < 0.0) {
            d2 = -d2;
        }
        return d2;
    }

    public static double j0(double d) throws ArithmeticException {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = 5.7568490574E10 + d4 * (-1.3362590354E10 + d4 * (6.516196407E8 + d4 * (-1.121442418E7 + d4 * (77392.33017 + d4 * -184.9052456))));
            double d6 = 5.7568490411E10 + d4 * (1.029532985E9 + d4 * (9494680.718 + d4 * (59272.64853 + d4 * (267.8532712 + d4 * 1.0))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d7 * d7;
        double d9 = d3 - 0.785398164;
        double d10 = 1.0 + d8 * (-0.001098628627 + d8 * (2.734510407E-5 + d8 * (-2.073370639E-6 + d8 * 2.093887211E-7)));
        double d11 = -0.01562499995 + d8 * (1.430488765E-4 + d8 * (-6.911147651E-6 + d8 * (7.621095161E-7 - d8 * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / d3) * (Math.cos(d9) * d10 - d7 * Math.sin(d9) * d11);
    }

    public static double j1(double d) throws ArithmeticException {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = d * (7.2362614232E10 + d4 * (-7.895059235E9 + d4 * (2.423968531E8 + d4 * (-2972611.439 + d4 * (15704.4826 + d4 * -30.16036606)))));
            double d6 = 1.44725228442E11 + d4 * (2.300535178E9 + d4 * (1.858330474E7 + d4 * (99447.43394 + d4 * (376.9991397 + d4 * 1.0))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d3 - 2.356194491;
        double d9 = d7 * d7;
        double d10 = 1.0 + d9 * (0.00183105 + d9 * (-3.516396496E-5 + d9 * (2.457520174E-6 + d9 * -2.40337019E-7)));
        double d11 = 0.04687499995 + d9 * (-2.002690873E-4 + d9 * (8.449199096E-6 + d9 * (-8.8228987E-7 + d9 * 1.05787412E-7)));
        double d12 = Math.sqrt(0.636619772 / d3) * (Math.cos(d8) * d10 - d7 * Math.sin(d8) * d11);
        if (d < 0.0) {
            d12 = -d12;
        }
        return d12;
    }

    public static double jn(int n, double d) throws ArithmeticException {
        double d2;
        if (n == 0) {
            return Bessel.j0(d);
        }
        if (n == 1) {
            return Bessel.j1(d);
        }
        double d3 = Math.abs(d);
        if (d3 == 0.0) {
            return 0.0;
        }
        if (d3 > (double)n) {
            double d4 = 2.0 / d3;
            double d5 = Bessel.j0(d3);
            double d6 = Bessel.j1(d3);
            for (int i = 1; i < n; ++i) {
                double d7 = (double)i * d4 * d6 - d5;
                d5 = d6;
                d6 = d7;
            }
            d2 = d6;
        } else {
            double d8 = 2.0 / d3;
            int n2 = 2 * ((n + (int)Math.sqrt(40.0 * (double)n)) / 2);
            boolean bl = false;
            double d9 = 0.0;
            d2 = 0.0;
            double d10 = 0.0;
            double d11 = 1.0;
            for (int i = n2; i > 0; --i) {
                double d12 = (double)i * d8 * d11 - d10;
                d10 = d11;
                d11 = d12;
                if (Math.abs(d11) > 1.0E10) {
                    d11 *= 1.0E-10;
                    d10 *= 1.0E-10;
                    d2 *= 1.0E-10;
                    d9 *= 1.0E-10;
                }
                if (bl) {
                    d9 += d11;
                }
                boolean bl2 = bl = !bl;
                if (i != n) continue;
                d2 = d10;
            }
            d9 = 2.0 * d9 - d11;
            d2 /= d9;
        }
        return d < 0.0 && n % 2 == 1 ? -d2 : d2;
    }

    public static double k0(double d) throws ArithmeticException {
        if (d <= 0.0) {
            throw new ArithmeticException();
        }
        if (d <= 2.0) {
            double d2 = d * d - 2.0;
            d2 = DoubleArithmetic.chbevl(d2, A_k0, 10) - Math.log(0.5 * d) * Bessel.i0(d);
            return d2;
        }
        double d3 = 8.0 / d - 2.0;
        double d4 = Math.exp(-d) * DoubleArithmetic.chbevl(d3, B_k0, 25) / Math.sqrt(d);
        return d4;
    }

    public static double k0e(double d) throws ArithmeticException {
        if (d <= 0.0) {
            throw new ArithmeticException();
        }
        if (d <= 2.0) {
            double d2 = d * d - 2.0;
            d2 = DoubleArithmetic.chbevl(d2, A_k0, 10) - Math.log(0.5 * d) * Bessel.i0(d);
            return d2 * Math.exp(d);
        }
        double d3 = DoubleArithmetic.chbevl(8.0 / d - 2.0, B_k0, 25) / Math.sqrt(d);
        return d3;
    }

    public static double k1(double d) throws ArithmeticException {
        double d2 = 0.5 * d;
        if (d2 <= 0.0) {
            throw new ArithmeticException();
        }
        if (d <= 2.0) {
            double d3 = d * d - 2.0;
            d3 = Math.log(d2) * Bessel.i1(d) + DoubleArithmetic.chbevl(d3, A_k1, 11) / d;
            return d3;
        }
        return Math.exp(-d) * DoubleArithmetic.chbevl(8.0 / d - 2.0, B_k1, 25) / Math.sqrt(d);
    }

    public static double k1e(double d) throws ArithmeticException {
        if (d <= 0.0) {
            throw new ArithmeticException();
        }
        if (d <= 2.0) {
            double d2 = d * d - 2.0;
            d2 = Math.log(0.5 * d) * Bessel.i1(d) + DoubleArithmetic.chbevl(d2, A_k1, 11) / d;
            return d2 * Math.exp(d);
        }
        return DoubleArithmetic.chbevl(8.0 / d - 2.0, B_k1, 25) / Math.sqrt(d);
    }

    public static double kn(int n, double d) throws ArithmeticException {
        double d2;
        int n2 = n < 0 ? -n : n;
        if (n2 > 31) {
            throw new ArithmeticException("Overflow");
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d <= 9.55) {
            double d3;
            double d4;
            double d5;
            double d6 = 0.0;
            double d7 = 0.25 * d * d;
            double d8 = 1.0;
            double d9 = 0.0;
            double d10 = 1.0;
            double d11 = 2.0 / d;
            if (n2 > 0) {
                int n3;
                d9 = -0.5772156649015329;
                d5 = 1.0;
                for (n3 = 1; n3 < n2; ++n3) {
                    d9 += 1.0 / d5;
                    d8 *= (d5 += 1.0);
                }
                d10 = d11;
                if (n2 == 1) {
                    d6 = 1.0 / d;
                } else {
                    double d12 = d8 / (double)n2;
                    double d13 = 1.0;
                    d4 = d12;
                    double d14 = -d7;
                    double d15 = 1.0;
                    for (n3 = 1; n3 < n2; ++n3) {
                        d3 = (d12 /= (double)(n2 - n3)) * (d15 *= d14) / (d13 *= (double)n3);
                        d4 += d3;
                        if (Double.MAX_VALUE - Math.abs(d3) < Math.abs(d4)) {
                            throw new ArithmeticException("Overflow");
                        }
                        if (d11 > 1.0 && Double.MAX_VALUE / d11 < d10) {
                            throw new ArithmeticException("Overflow");
                        }
                        d10 *= d11;
                    }
                    d3 = Math.abs(d4 *= 0.5);
                    if (d10 > 1.0 && Double.MAX_VALUE / d10 < d3) {
                        throw new ArithmeticException("Overflow");
                    }
                    if (d3 > 1.0 && Double.MAX_VALUE / d3 < d10) {
                        throw new ArithmeticException("Overflow");
                    }
                    d6 = d4 * d10;
                }
            }
            double d16 = 2.0 * Math.log(0.5 * d);
            double d17 = -0.5772156649015329;
            if (n2 == 0) {
                d9 = d17;
                d3 = 1.0;
            } else {
                d9 += 1.0 / (double)n2;
                d3 = 1.0 / d8;
            }
            d4 = (d17 + d9 - d16) * d3;
            d5 = 1.0;
            while (Math.abs(d3 / (d4 += ((d17 += 1.0 / (d5 += 1.0)) + (d9 += 1.0 / (d5 + (double)n2)) - d16) * (d3 *= d7 / (d5 * (d5 + (double)n2))))) > (double)1.110223E-16f) {
            }
            d4 = 0.5 * d4 / d10;
            if ((n2 & 1) > 0) {
                d4 = -d4;
            }
            return d6 += d4;
        }
        if (d > 709.782712893384) {
            throw new ArithmeticException("Underflow");
        }
        double d18 = n2;
        double d19 = 4.0 * d18 * d18;
        double d20 = 1.0;
        double d21 = 8.0 * d;
        double d22 = 1.0;
        double d23 = d2 = 1.0;
        double d24 = Double.MAX_VALUE;
        int n4 = 0;
        do {
            double d25 = d19 - d20 * d20;
            d2 = d2 * d25 / (d22 * d21);
            double d26 = Math.abs(d2);
            if (n4 >= n2 && d26 > d24) {
                double d27 = Math.exp(-d) * Math.sqrt(Math.PI / (2.0 * d)) * d23;
                return d27;
            }
            d24 = d26;
            d22 += 1.0;
            d20 += 2.0;
            ++n4;
        } while (Math.abs(d2 / (d23 += d2)) > (double)1.110223E-16f);
        double d28 = Math.exp(-d) * Math.sqrt(Math.PI / (2.0 * d)) * d23;
        return d28;
    }

    public static double y0(double d) throws ArithmeticException {
        if (d < 8.0) {
            double d2 = d * d;
            double d3 = -2.957821389E9 + d2 * (7.062834065E9 + d2 * (-5.123598036E8 + d2 * (1.087988129E7 + d2 * (-86327.92757 + d2 * 228.4622733))));
            double d4 = 4.0076544269E10 + d2 * (7.452499648E8 + d2 * (7189466.438 + d2 * (47447.2647 + d2 * (226.1030244 + d2 * 1.0))));
            return d3 / d4 + 0.636619772 * Bessel.j0(d) * Math.log(d);
        }
        double d5 = 8.0 / d;
        double d6 = d5 * d5;
        double d7 = d - 0.785398164;
        double d8 = 1.0 + d6 * (-0.001098628627 + d6 * (2.734510407E-5 + d6 * (-2.073370639E-6 + d6 * 2.093887211E-7)));
        double d9 = -0.01562499995 + d6 * (1.430488765E-4 + d6 * (-6.911147651E-6 + d6 * (7.621095161E-7 + d6 * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / d) * (Math.sin(d7) * d8 + d5 * Math.cos(d7) * d9);
    }

    public static double y1(double d) throws ArithmeticException {
        if (d < 8.0) {
            double d2 = d * d;
            double d3 = d * (-4.900604943E12 + d2 * (1.27527439E12 + d2 * (-5.153438139E10 + d2 * (7.349264551E8 + d2 * (-4237922.726 + d2 * 8511.937935)))));
            double d4 = 2.49958057E13 + d2 * (4.244419664E11 + d2 * (3.733650367E9 + d2 * (2.245904002E7 + d2 * (102042.605 + d2 * (354.9632885 + d2)))));
            return d3 / d4 + 0.636619772 * (Bessel.j1(d) * Math.log(d) - 1.0 / d);
        }
        double d5 = 8.0 / d;
        double d6 = d5 * d5;
        double d7 = d - 2.356194491;
        double d8 = 1.0 + d6 * (0.00183105 + d6 * (-3.516396496E-5 + d6 * (2.457520174E-6 + d6 * -2.40337019E-7)));
        double d9 = 0.04687499995 + d6 * (-2.002690873E-4 + d6 * (8.449199096E-6 + d6 * (-8.8228987E-7 + d6 * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / d) * (Math.sin(d7) * d8 + d5 * Math.cos(d7) * d9);
    }

    public static double yn(int n, double d) throws ArithmeticException {
        if (n == 0) {
            return Bessel.y0(d);
        }
        if (n == 1) {
            return Bessel.y1(d);
        }
        double d2 = 2.0 / d;
        double d3 = Bessel.y1(d);
        double d4 = Bessel.y0(d);
        for (int i = 1; i < n; ++i) {
            double d5 = (double)i * d2 * d3 - d4;
            d4 = d3;
            d3 = d5;
        }
        return d3;
    }
}

