/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.QualityFunction;
import uk.ac.rhul.cs.cl1.ui.PValueRenderer;

public class NodeSetPropertiesPanel
extends JPanel {
    protected NodeSet nodeSet = null;
    protected QualityFunction qualityFunc = null;
    protected JLabel label = null;
    protected JTable detailsTable = null;
    protected DefaultTableModel model = null;
    protected static String[] columnNames = new String[]{"Property", "Value"};

    public NodeSetPropertiesPanel() {
        this.setLayout(new BoxLayout(this, 3));
        this.label = new JLabel("", 0);
        this.label.setMaximumSize(null);
        this.add(this.label);
        this.detailsTable = new JTable(5, 2);
        this.detailsTable.setRowSelectionAllowed(false);
        this.detailsTable.setColumnSelectionAllowed(false);
        this.detailsTable.setCellSelectionEnabled(false);
        this.detailsTable.setFocusable(false);
        this.detailsTable.setAutoCreateColumnsFromModel(true);
        this.detailsTable.setBackground(this.getBackground());
        this.detailsTable.setGridColor(this.getBackground());
        this.detailsTable.setFont(this.getFont());
        this.detailsTable.setIntercellSpacing(new Dimension(5, 0));
        this.add(this.detailsTable);
        this.setupTableModel();
        this.updatePanel();
    }

    protected void setupTableModel() {
        this.model = new DefaultTableModel(columnNames, 0);
        String[] rowNames = new String[]{"Number of nodes:", "In-weight:", "Out-weight:", "Density:", "Quality:", "P-value:"};
        Object[] row = new Object[2];
        for (String rowName : rowNames) {
            row[0] = rowName;
            row[1] = null;
            this.model.addRow(row);
        }
        this.detailsTable.setModel(this.model);
        this.detailsTable.getColumn(this.detailsTable.getColumnName(0)).setCellRenderer(new RightAlignedLabelRenderer());
    }

    protected void updatePanel() {
        if (this.nodeSet != null) {
            String qualityStr = this.qualityFunc != null ? PValueRenderer.formatValue(this.qualityFunc.calculate(this.nodeSet), false) : null;
            this.model.setValueAt(this.nodeSet.size(), 0, 1);
            this.model.setValueAt(PValueRenderer.formatValue(this.nodeSet.getTotalInternalEdgeWeight(), false), 1, 1);
            this.model.setValueAt(PValueRenderer.formatValue(this.nodeSet.getTotalBoundaryEdgeWeight(), false), 2, 1);
            this.model.setValueAt(PValueRenderer.formatValue(this.nodeSet.getDensity(), false), 3, 1);
            this.model.setValueAt(qualityStr, 4, 1);
            this.model.setValueAt(PValueRenderer.formatValue(this.nodeSet.getSignificance(), false), 5, 1);
        } else {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                this.model.setValueAt(null, i, 1);
            }
        }
    }

    public NodeSet getNodeSet() {
        return this.nodeSet;
    }

    public QualityFunction getQualityFunction() {
        return this.qualityFunc;
    }

    public void setNodeSet(NodeSet nodeSet) {
        this.nodeSet = nodeSet;
        this.updatePanel();
    }

    public void setQualityFunction(QualityFunction qualityFunc) {
        this.qualityFunc = qualityFunc;
        this.updatePanel();
    }

    class RightAlignedLabelRenderer
    extends JLabel
    implements TableCellRenderer {
        public RightAlignedLabelRenderer() {
            super("", 4);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }
}

